'use strict';

var React = require('react');
var classNames = require('classnames');

var Icon = require('./Icon');
var Form = require('./Form');
var Input = require('./Input');

var SearchBar = React.createClass({
    displayName: 'SearchBar',

    propTypes: {
        className: React.PropTypes.string,
        placeholder: React.PropTypes.string,
        value: React.PropTypes.string,
        action: React.PropTypes.string,
        name: React.PropTypes.string,
        method: React.PropTypes.string,
        onSubmit: React.PropTypes.func,
        onChange: React.PropTypes.func
    },

    getDefaultProps: function getDefaultProps() {
        return {
            method: 'get'
        };
    },
    getInitialState: function getInitialState() {
        return {
            value: this.props.value
        };
    },
    componentWillReceiveProps: function componentWillReceiveProps(newProps) {
        this.setState({
            value: newProps.value
        });
    },
    onChange: function onChange(e) {
        var value = e.target.value;


        this.setState({ value: value });

        if (this.props.onChange) {
            this.props.onChange(value);
        }
    },
    onSubmit: function onSubmit(e) {
        if (this.props.onSubmit) {
            e.preventDefault();
            this.props.onSubmit(this.state.value);
        }
    },
    render: function render() {
        var _props = this.props,
            action = _props.action,
            placeholder = _props.placeholder,
            name = _props.name,
            method = _props.method;
        var value = this.state.value;


        return React.createElement(
            Form,
            { className: classNames('search-bar', this.props.className),
                method: method,
                action: action },
            React.createElement(Icon, { id: 'search', size: 'sm' }),
            React.createElement(Input, { name: name,
                value: value,
                onChange: this.onChange,
                placeholder: placeholder })
        );
    }
});

module.exports = SearchBar;
//# sourceMappingURL=data:application/json;base64,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