'use strict';

var React = require('react');
var classNames = require('classnames');

var SIZES = require('./SIZES');

var Spinner = React.createClass({
    displayName: 'Spinner',

    propTypes: {
        centered: React.PropTypes.bool,
        inverse: React.PropTypes.bool,
        size: React.PropTypes.oneOf(SIZES)
    },

    getDefaultProps: function getDefaultProps() {
        return {
            centered: true,
            size: 'md'
        };
    },
    render: function render() {
        var className = classNames('gb-spinner', 'spinner-' + this.props.size, {
            'spinner-inverse': this.props.inverse,
            'spinner-centered': this.props.centered
        });

        return React.createElement('span', { className: className });
    }
});

/**
 * Block div representing a loading area
 */
var SpinnerSlate = React.createClass({
    displayName: 'SpinnerSlate',
    render: function render() {
        return React.createElement(
            'div',
            { className: 'gb-spinner-slate' },
            React.createElement(Spinner, this.props)
        );
    }
});

module.exports = Spinner;
module.exports.Slate = SpinnerSlate;
//# sourceMappingURL=data:application/json;base64,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