'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var React = require('react');
var classNames = require('classnames');

var Icon = require('./Icon');
var STYLES = require('./STYLES');
var SIZES = require('./SIZES');
var warning = require('./utils/warning');

var BUTTONS_STYLES = STYLES.concat(['link', 'marketing-primary', 'secondary', 'count']);

var Button = React.createClass({
    displayName: 'Button',

    propTypes: {
        className: React.PropTypes.string,
        children: React.PropTypes.node,
        type: React.PropTypes.string,
        size: React.PropTypes.oneOf(SIZES),
        style: React.PropTypes.oneOf(BUTTONS_STYLES),
        // Makes a link button
        href: React.PropTypes.string,
        // Form button
        value: React.PropTypes.oneOfType([React.PropTypes.string, React.PropTypes.bool, React.PropTypes.number]),
        name: React.PropTypes.string,
        // For links
        target: React.PropTypes.string,
        filled: React.PropTypes.bool,
        noBorder: React.PropTypes.bool,
        disabled: React.PropTypes.bool,
        active: React.PropTypes.bool,
        block: React.PropTypes.bool,
        dropdownToggle: React.PropTypes.bool,
        onClick: React.PropTypes.func,
        title: React.PropTypes.string,
        icon: React.PropTypes.string
    },

    getInitialState: function getInitialState() {
        return {
            clicked: false
        };
    },
    getDefaultProps: function getDefaultProps() {
        return {
            style: 'default',
            size: 'md',
            type: 'button',
            filled: false,
            disabled: false,
            active: false
        };
    },
    onClick: function onClick(e) {
        var _this = this;

        // Prevent any action if button is disabled
        var disabled = this.props.disabled;

        if (disabled) {
            e.preventDefault();
            return;
        }

        var clicked = this.state.clicked;

        if (this.props.onClick && !clicked) {
            this.props.onClick(e);
        }

        if (!this.isFormButton()) {
            return;
        } else if (clicked) {
            return this.setState({
                clicked: false
            });
        }

        // Add this submitting button's value to the form as hidden
        // input. Only after that do the click.
        // This fixes issues with PJAX[1] in Firefox[2]
        // [1]: https://github.com/defunkt/jquery-pjax/pull/295
        // [2]: http://stackoverflow.com/questions/38277900/formdata-object-does-not-add-submit-type-inputs-from-form-while-on-firefox
        e.preventDefault();
        this.setState({
            clicked: true
        }, function () {
            _this.refs.button.click();
        });
    },
    isFormButton: function isFormButton() {
        var _props = this.props,
            type = _props.type,
            name = _props.name;

        return type === 'submit' && name;
    },
    render: function render() {
        var clicked = this.state.clicked;

        var _props2 = this.props,
            title = _props2.title,
            icon = _props2.icon,
            filled = _props2.filled,
            block = _props2.block,
            noBorder = _props2.noBorder,
            active = _props2.active,
            dropdownToggle = _props2.dropdownToggle,
            style = _props2.style,
            size = _props2.size,
            className = _props2.className,
            children = _props2.children,
            name = _props2.name,
            value = _props2.value,
            disabled = _props2.disabled,
            props = _objectWithoutProperties(_props2, ['title', 'icon', 'filled', 'block', 'noBorder', 'active', 'dropdownToggle', 'style', 'size', 'className', 'children', 'name', 'value', 'disabled']);

        var inner = icon ? React.createElement(Icon, { className: icon }) : '';
        if (icon) {
            warning('Prop "icon" on Button is deprecated, use <Icon /> as children instead');
        }

        props.className = classNames('btn', 'btn-' + style, 'btn-' + size, className, {
            'btn-fill': filled,
            'btn-block': block,
            'btn-noborder': noBorder,
            active: active, disabled: disabled,
            'dropdown-toggle': dropdownToggle,
            'tooltipped': Boolean(title)
        });
        props['aria-label'] = title;
        props.role = 'button';
        props.disabled = disabled;
        props.onClick = this.onClick;
        // Update href if button is disabled
        if (props.href) {
            props.href = disabled ? '#' : props.href;
        }

        var input = void 0;

        if (clicked && this.isFormButton()) {
            input = React.createElement('input', { type: 'hidden', name: name, value: value });
        }

        if (props.href) {
            delete props.type;
            return React.createElement(
                'a',
                props,
                inner,
                ' ',
                children
            );
        } else {
            return React.createElement(
                'button',
                _extends({ ref: 'button' }, props),
                inner,
                ' ',
                children,
                input
            );
        }
    }
});

var ButtonGroup = React.createClass({
    displayName: 'ButtonGroup',

    propTypes: {
        className: React.PropTypes.string,
        children: React.PropTypes.node,
        pull: React.PropTypes.string,
        block: React.PropTypes.bool
    },

    render: function render() {
        var _props3 = this.props,
            className = _props3.className,
            pull = _props3.pull,
            children = _props3.children,
            block = _props3.block,
            props = _objectWithoutProperties(_props3, ['className', 'pull', 'children', 'block']);

        className = classNames('btn-group', className, pull ? 'pull-' + pull : '', {
            'btn-group-block': block
        });

        return React.createElement(
            'div',
            _extends({ className: className }, props),
            children
        );
    }
});

var ButtonToolbar = React.createClass({
    displayName: 'ButtonToolbar',

    propTypes: {
        className: React.PropTypes.string,
        children: React.PropTypes.node
    },

    render: function render() {
        var _props4 = this.props,
            className = _props4.className,
            children = _props4.children,
            props = _objectWithoutProperties(_props4, ['className', 'children']);

        return React.createElement(
            'div',
            _extends({ className: 'btn-toolbar ' + (className || '') }, props),
            children
        );
    }
});

var ButtonCaret = React.createClass({
    displayName: 'ButtonCaret',
    render: function render() {
        return React.createElement('span', { className: 'caret' });
    }
});

var ButtonTextExpander = React.createClass({
    displayName: 'ButtonTextExpander',

    propTypes: {
        onClick: React.PropTypes.func
    },

    onClick: function onClick(e) {
        if (this.props.onClick) {
            this.props.onClick();
        }
    },
    render: function render() {
        return React.createElement(
            'span',
            { className: 'hidden-text-expander' },
            React.createElement(
                'button',
                { type: 'button', className: 'ellipsis-expander', onClick: this.onClick },
                '\u2026'
            )
        );
    }
});

module.exports = Button;
module.exports.Group = ButtonGroup;
module.exports.Toolbar = ButtonToolbar;
module.exports.Caret = ButtonCaret;
module.exports.TextExpander = ButtonTextExpander;
module.exports.STYLES = BUTTONS_STYLES;
//# sourceMappingURL=data:application/json;base64,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