'use strict';

var React = require('react');
var classNames = require('classnames');

var SIZES = require('./SIZES');

/**
 * An icon using an internal SVG.
 *
 * @type {ReactClass}
 */
var SVGIcon = React.createClass({
    displayName: 'SVGIcon',

    propTypes: {
        svg: React.PropTypes.string,
        className: React.PropTypes.string,
        size: React.PropTypes.oneOf(SIZES)
    },

    getDefaultProps: function getDefaultProps() {
        return {
            size: 'sm'
        };
    },
    render: function render() {
        var _props = this.props,
            svg = _props.svg,
            size = _props.size,
            className = _props.className;

        var cl = classNames('Icon', 'SVGIcon', 'size-' + size, className);

        return React.createElement('span', { className: cl, dangerouslySetInnerHTML: { __html: svg } });
    }
});

module.exports = SVGIcon;
//# sourceMappingURL=data:application/json;base64,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