'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Alert = require('../src/Alert');
var Icon = require('../src/Icon');

var SCOPE = { React: React, Alert: Alert, Icon: Icon };

var EXAMPLE_DEFAULT = '<Alert.Info>Flash message goes here.</Alert.Info>';
var EXAMPLE_DANGER = '<Alert.Danger>\n    <Icon id="alert" size="sm" /> This is an alert!\n</Alert.Danger>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Alerts', active: 'alerts' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Alerts' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'Flash messages, or alerts, inform users of successful or pending actions. Use them sparingly. Don\u2019t show more than one at a time.'
                ),
                React.createElement(CodeEditor, { source: 'const Alert = require(\'gitbook-styleguide/lib/Alert\');' })
            )
        ),
        React.createElement(Example, { title: 'Default', source: EXAMPLE_DEFAULT, scope: SCOPE }),
        React.createElement(Example, { title: 'Danger', source: EXAMPLE_DANGER, scope: SCOPE })
    );
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInBhZ2VzL2FsZXJ0cy5qcz9lbnRyeSJdLCJuYW1lcyI6WyJSZWFjdCIsInJlcXVpcmUiLCJQYWdlIiwiRXhhbXBsZSIsIkNvZGVFZGl0b3IiLCJQYW5lbCIsIkFsZXJ0IiwiSWNvbiIsIlNDT1BFIiwiRVhBTVBMRV9ERUZBVUxUIiwiRVhBTVBMRV9EQU5HRVIiXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsSUFBTUEsUUFBUUMsUUFBUSxPQUFSLENBQWQ7O0FBRUEsSUFBTUMsT0FBT0QsUUFBUSxtQkFBUixDQUFiO0FBQ0EsSUFBTUUsVUFBVUYsUUFBUSxzQkFBUixDQUFoQjtBQUNBLElBQU1HLGFBQWFILFFBQVEseUJBQVIsQ0FBbkI7O0FBRUEsSUFBTUksUUFBUUosUUFBUSxjQUFSLENBQWQ7QUFDQSxJQUFNSyxRQUFRTCxRQUFRLGNBQVIsQ0FBZDtBQUNBLElBQU1NLE9BQU9OLFFBQVEsYUFBUixDQUFiOztBQUVBLElBQU1PLFFBQVEsRUFBRVIsWUFBRixFQUFTTSxZQUFULEVBQWdCQyxVQUFoQixFQUFkOztBQUVBLElBQU1FLGtCQUFrQixtREFBeEI7QUFDQSxJQUFNQyx1R0FBTjs7a0JBS2UsWUFBTTtBQUNqQixXQUNJO0FBQUMsWUFBRDtBQUFBLFVBQU0sT0FBTSxRQUFaLEVBQXFCLFFBQU8sUUFBNUI7QUFDSTtBQUFDLGlCQUFEO0FBQUE7QUFDSSxnQ0FBQyxLQUFELENBQU8sT0FBUCxJQUFlLE9BQU0sUUFBckIsR0FESjtBQUVJO0FBQUMscUJBQUQsQ0FBTyxJQUFQO0FBQUE7QUFDSTtBQUFBO0FBQUE7QUFBQTtBQUFBLGlCQURKO0FBRUksb0NBQUMsVUFBRCxJQUFZLFFBQU8sMERBQW5CO0FBRko7QUFGSixTQURKO0FBU0ksNEJBQUMsT0FBRCxJQUFTLE9BQU0sU0FBZixFQUF5QixRQUFRRCxlQUFqQyxFQUFrRCxPQUFPRCxLQUF6RCxHQVRKO0FBVUksNEJBQUMsT0FBRCxJQUFTLE9BQU0sUUFBZixFQUF3QixRQUFRRSxjQUFoQyxFQUFnRCxPQUFPRixLQUF2RDtBQVZKLEtBREo7QUFjSCxDIiwiZmlsZSI6ImFsZXJ0cy5qcz9lbnRyeSIsInNvdXJjZVJvb3QiOiIvVXNlcnMvanByZXluYXQvR2l0Qm9vay9zdHlsZWd1aWRlIiwic291cmNlc0NvbnRlbnQiOlsiY29uc3QgUmVhY3QgPSByZXF1aXJlKCdyZWFjdCcpO1xuXG5jb25zdCBQYWdlID0gcmVxdWlyZSgnLi9jb21wb25lbnRzL1BhZ2UnKTtcbmNvbnN0IEV4YW1wbGUgPSByZXF1aXJlKCcuL2NvbXBvbmVudHMvRXhhbXBsZScpO1xuY29uc3QgQ29kZUVkaXRvciA9IHJlcXVpcmUoJy4vY29tcG9uZW50cy9Db2RlRWRpdG9yJyk7XG5cbmNvbnN0IFBhbmVsID0gcmVxdWlyZSgnLi4vc3JjL1BhbmVsJyk7XG5jb25zdCBBbGVydCA9IHJlcXVpcmUoJy4uL3NyYy9BbGVydCcpO1xuY29uc3QgSWNvbiA9IHJlcXVpcmUoJy4uL3NyYy9JY29uJyk7XG5cbmNvbnN0IFNDT1BFID0geyBSZWFjdCwgQWxlcnQsIEljb24gfTtcblxuY29uc3QgRVhBTVBMRV9ERUZBVUxUID0gJzxBbGVydC5JbmZvPkZsYXNoIG1lc3NhZ2UgZ29lcyBoZXJlLjwvQWxlcnQuSW5mbz4nO1xuY29uc3QgRVhBTVBMRV9EQU5HRVIgPVxuYDxBbGVydC5EYW5nZXI+XG4gICAgPEljb24gaWQ9XCJhbGVydFwiIHNpemU9XCJzbVwiIC8+IFRoaXMgaXMgYW4gYWxlcnQhXG48L0FsZXJ0LkRhbmdlcj5gO1xuXG5leHBvcnQgZGVmYXVsdCAoKSA9PiB7XG4gICAgcmV0dXJuIChcbiAgICAgICAgPFBhZ2UgdGl0bGU9XCJBbGVydHNcIiBhY3RpdmU9XCJhbGVydHNcIj5cbiAgICAgICAgICAgIDxQYW5lbD5cbiAgICAgICAgICAgICAgICA8UGFuZWwuSGVhZGluZyB0aXRsZT1cIkFsZXJ0c1wiIC8+XG4gICAgICAgICAgICAgICAgPFBhbmVsLkJvZHk+XG4gICAgICAgICAgICAgICAgICAgIDxwPkZsYXNoIG1lc3NhZ2VzLCBvciBhbGVydHMsIGluZm9ybSB1c2VycyBvZiBzdWNjZXNzZnVsIG9yIHBlbmRpbmcgYWN0aW9ucy4gVXNlIHRoZW0gc3BhcmluZ2x5LiBEb27igJl0IHNob3cgbW9yZSB0aGFuIG9uZSBhdCBhIHRpbWUuPC9wPlxuICAgICAgICAgICAgICAgICAgICA8Q29kZUVkaXRvciBzb3VyY2U9XCJjb25zdCBBbGVydCA9IHJlcXVpcmUoJ2dpdGJvb2stc3R5bGVndWlkZS9saWIvQWxlcnQnKTtcIiAvPlxuICAgICAgICAgICAgICAgIDwvUGFuZWwuQm9keT5cbiAgICAgICAgICAgIDwvUGFuZWw+XG5cbiAgICAgICAgICAgIDxFeGFtcGxlIHRpdGxlPVwiRGVmYXVsdFwiIHNvdXJjZT17RVhBTVBMRV9ERUZBVUxUfSBzY29wZT17U0NPUEV9PjwvRXhhbXBsZT5cbiAgICAgICAgICAgIDxFeGFtcGxlIHRpdGxlPVwiRGFuZ2VyXCIgc291cmNlPXtFWEFNUExFX0RBTkdFUn0gc2NvcGU9e1NDT1BFfT48L0V4YW1wbGU+XG4gICAgICAgIDwvUGFnZT5cbiAgICApO1xufTtcbiJdfQ==