'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Autocomplete = require('../src/Autocomplete');

var SCOPE = { React: React, Autocomplete: Autocomplete };

var EXAMPLE_IMPORT = 'const Autocomplete = require(\'gitbook-styleguide/lib/Autocomplete\');';

var EXAMPLE_DEFAULT = '<Autocomplete\n    placeholder="Enter a language"\n    onFetch={(query, callback) => {\n        callback([\n            { id: \'en\', label: \'English\' },\n            { id: \'fr\', label: \'French\' }\n        ])\n    }}\n    onChange={(query, result) => alert(\'Selected is \' + result.label)}\n    renderResult={({result}) => <span><b>{result.id}</b> {result.label}</span>}\n/>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Autocomplete', active: 'autocomplete' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Autocomplete' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'Modals are streamlined, but flexible, dialog prompts with the minimum required functionality and smart defaults.'
                ),
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Example', source: EXAMPLE_DEFAULT, scope: SCOPE })
    );
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInBhZ2VzL2F1dG9jb21wbGV0ZS5qcz9lbnRyeSJdLCJuYW1lcyI6WyJSZWFjdCIsInJlcXVpcmUiLCJQYWdlIiwiRXhhbXBsZSIsIkNvZGVFZGl0b3IiLCJQYW5lbCIsIkF1dG9jb21wbGV0ZSIsIlNDT1BFIiwiRVhBTVBMRV9JTVBPUlQiLCJFWEFNUExFX0RFRkFVTFQiXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsSUFBTUEsUUFBUUMsUUFBUSxPQUFSLENBQWQ7O0FBRUEsSUFBTUMsT0FBT0QsUUFBUSxtQkFBUixDQUFiO0FBQ0EsSUFBTUUsVUFBVUYsUUFBUSxzQkFBUixDQUFoQjtBQUNBLElBQU1HLGFBQWFILFFBQVEseUJBQVIsQ0FBbkI7O0FBRUEsSUFBTUksUUFBUUosUUFBUSxjQUFSLENBQWQ7QUFDQSxJQUFNSyxlQUFlTCxRQUFRLHFCQUFSLENBQXJCOztBQUVBLElBQU1NLFFBQVEsRUFBRVAsWUFBRixFQUFTTSwwQkFBVCxFQUFkOztBQUVBLElBQU1FLGlCQUNOLHdFQURBOztBQUdBLElBQU1DLGlaQUFOOztrQkFhZSxZQUFNO0FBQ2pCLFdBQ0k7QUFBQyxZQUFEO0FBQUEsVUFBTSxPQUFNLGNBQVosRUFBMkIsUUFBTyxjQUFsQztBQUNJO0FBQUMsaUJBQUQ7QUFBQTtBQUNJLGdDQUFDLEtBQUQsQ0FBTyxPQUFQLElBQWUsT0FBTSxjQUFyQixHQURKO0FBRUk7QUFBQyxxQkFBRCxDQUFPLElBQVA7QUFBQTtBQUNJO0FBQUE7QUFBQTtBQUFBO0FBQUEsaUJBREo7QUFFSSxvQ0FBQyxVQUFELElBQVksUUFBUUQsY0FBcEI7QUFGSjtBQUZKLFNBREo7QUFTSSw0QkFBQyxPQUFELElBQVMsT0FBTSxTQUFmLEVBQXlCLFFBQVFDLGVBQWpDLEVBQWtELE9BQU9GLEtBQXpEO0FBVEosS0FESjtBQWFILEMiLCJmaWxlIjoiYXV0b2NvbXBsZXRlLmpzP2VudHJ5Iiwic291cmNlUm9vdCI6Ii9Vc2Vycy9qcHJleW5hdC9HaXRCb29rL3N0eWxlZ3VpZGUiLCJzb3VyY2VzQ29udGVudCI6WyJjb25zdCBSZWFjdCA9IHJlcXVpcmUoJ3JlYWN0Jyk7XG5cbmNvbnN0IFBhZ2UgPSByZXF1aXJlKCcuL2NvbXBvbmVudHMvUGFnZScpO1xuY29uc3QgRXhhbXBsZSA9IHJlcXVpcmUoJy4vY29tcG9uZW50cy9FeGFtcGxlJyk7XG5jb25zdCBDb2RlRWRpdG9yID0gcmVxdWlyZSgnLi9jb21wb25lbnRzL0NvZGVFZGl0b3InKTtcblxuY29uc3QgUGFuZWwgPSByZXF1aXJlKCcuLi9zcmMvUGFuZWwnKTtcbmNvbnN0IEF1dG9jb21wbGV0ZSA9IHJlcXVpcmUoJy4uL3NyYy9BdXRvY29tcGxldGUnKTtcblxuY29uc3QgU0NPUEUgPSB7IFJlYWN0LCBBdXRvY29tcGxldGUgfTtcblxuY29uc3QgRVhBTVBMRV9JTVBPUlQgPVxuJ2NvbnN0IEF1dG9jb21wbGV0ZSA9IHJlcXVpcmUoXFwnZ2l0Ym9vay1zdHlsZWd1aWRlL2xpYi9BdXRvY29tcGxldGVcXCcpOyc7XG5cbmNvbnN0IEVYQU1QTEVfREVGQVVMVCA9XG5gPEF1dG9jb21wbGV0ZVxuICAgIHBsYWNlaG9sZGVyPVwiRW50ZXIgYSBsYW5ndWFnZVwiXG4gICAgb25GZXRjaD17KHF1ZXJ5LCBjYWxsYmFjaykgPT4ge1xuICAgICAgICBjYWxsYmFjayhbXG4gICAgICAgICAgICB7IGlkOiAnZW4nLCBsYWJlbDogJ0VuZ2xpc2gnIH0sXG4gICAgICAgICAgICB7IGlkOiAnZnInLCBsYWJlbDogJ0ZyZW5jaCcgfVxuICAgICAgICBdKVxuICAgIH19XG4gICAgb25DaGFuZ2U9eyhxdWVyeSwgcmVzdWx0KSA9PiBhbGVydCgnU2VsZWN0ZWQgaXMgJyArIHJlc3VsdC5sYWJlbCl9XG4gICAgcmVuZGVyUmVzdWx0PXsoe3Jlc3VsdH0pID0+IDxzcGFuPjxiPntyZXN1bHQuaWR9PC9iPiB7cmVzdWx0LmxhYmVsfTwvc3Bhbj59XG4vPmA7XG5cbmV4cG9ydCBkZWZhdWx0ICgpID0+IHtcbiAgICByZXR1cm4gKFxuICAgICAgICA8UGFnZSB0aXRsZT1cIkF1dG9jb21wbGV0ZVwiIGFjdGl2ZT1cImF1dG9jb21wbGV0ZVwiPlxuICAgICAgICAgICAgPFBhbmVsPlxuICAgICAgICAgICAgICAgIDxQYW5lbC5IZWFkaW5nIHRpdGxlPVwiQXV0b2NvbXBsZXRlXCIgLz5cbiAgICAgICAgICAgICAgICA8UGFuZWwuQm9keT5cbiAgICAgICAgICAgICAgICAgICAgPHA+TW9kYWxzIGFyZSBzdHJlYW1saW5lZCwgYnV0IGZsZXhpYmxlLCBkaWFsb2cgcHJvbXB0cyB3aXRoIHRoZSBtaW5pbXVtIHJlcXVpcmVkIGZ1bmN0aW9uYWxpdHkgYW5kIHNtYXJ0IGRlZmF1bHRzLjwvcD5cbiAgICAgICAgICAgICAgICAgICAgPENvZGVFZGl0b3Igc291cmNlPXtFWEFNUExFX0lNUE9SVH0gLz5cbiAgICAgICAgICAgICAgICA8L1BhbmVsLkJvZHk+XG4gICAgICAgICAgICA8L1BhbmVsPlxuXG4gICAgICAgICAgICA8RXhhbXBsZSB0aXRsZT1cIkV4YW1wbGVcIiBzb3VyY2U9e0VYQU1QTEVfREVGQVVMVH0gc2NvcGU9e1NDT1BFfT48L0V4YW1wbGU+XG4gICAgICAgIDwvUGFnZT5cbiAgICApO1xufTtcbiJdfQ==