'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Avatar = require('../src/Avatar');
var AvatarsStack = require('../src/AvatarsStack');

var SCOPE = { React: React, Avatar: Avatar, AvatarsStack: AvatarsStack };

var EXAMPLE_IMPORT = 'const Avatar = require(\'gitbook-styleguide/lib/Avatar\');\nconst AvatarsStack = require(\'gitbook-styleguide/lib/AvatarsStack\');';

var EXAMPLE_DEFAULT = '<Avatar\n    src="https://picturepan2.github.io/spectre/demo/img/avatar-1.png"\n    size="lg"\n    />\n<Avatar\n    src="https://picturepan2.github.io/spectre/demo/img/avatar-3.png"\n    size="md"\n    />\n<Avatar\n    src="https://picturepan2.github.io/spectre/demo/img/avatar-4.png"\n    size="sm"\n    />';

var EXAMPLE_STACK = '<AvatarsStack>\n    <AvatarsStack.Item>\n        <Avatar\n            src="https://picturepan2.github.io/spectre/demo/img/avatar-1.png"\n            size="sm"\n            />\n    </AvatarsStack.Item>\n    <AvatarsStack.Item>\n        <Avatar\n            src="https://picturepan2.github.io/spectre/demo/img/avatar-3.png"\n            size="sm"\n            />\n    </AvatarsStack.Item>\n    <AvatarsStack.Item>\n        <Avatar\n            src="https://picturepan2.github.io/spectre/demo/img/avatar-4.png"\n            size="sm"\n            />\n    </AvatarsStack.Item>\n</AvatarsStack>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Avatars', active: 'avatars' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Avatars' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement('p', null),
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Layout', source: EXAMPLE_DEFAULT, scope: SCOPE }),
        React.createElement(
            Example,
            { title: 'Stack', source: EXAMPLE_STACK, scope: SCOPE },
            'Stack of avatars can be used to display a list of participants.'
        )
    );
};
//# sourceMappingURL=data:application/json;base64,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