'use strict';

var React = require('react');
var Slate = require('slate');
var Prism = require('slate-prism');
require('prismjs/components/prism-jsx');

var plugins = [Prism({
    onlyIn: function onlyIn(node) {
        return true;
    },
    getSyntax: function getSyntax(node) {
        return 'jsx';
    }
})];

var CodeEditor = React.createClass({
    displayName: 'CodeEditor',

    propTypes: {
        source: React.PropTypes.string,
        onChange: React.PropTypes.func
    },

    getDefaultProps: function getDefaultProps() {
        return {
            source: ''
        };
    },


    // Setup initial state for editor
    getInitialState: function getInitialState() {
        var source = this.props.source;

        return {
            state: Slate.Plain.deserialize(source)
        };
    },


    // Editor has been modified
    onChange: function onChange(state) {
        var source = Slate.Plain.serialize(state);
        this.setState({ state: state });
        this.props.onChange(source);
    },
    render: function render() {
        var state = this.state.state;

        return React.createElement(
            'pre',
            null,
            React.createElement(Slate.Editor, {
                spellCheck: false,
                state: state,
                plugins: plugins,
                onChange: this.onChange
            })
        );
    }
});

module.exports = CodeEditor;
//# sourceMappingURL=data:application/json;base64,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