'use strict';

var _head = require('next/head');

var _head2 = _interopRequireDefault(_head);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var React = require('react');

var _require = require('react-sticky'),
    StickyContainer = _require.StickyContainer,
    Sticky = _require.Sticky;

var PageWrapper = require('../../src/PageWrapper');
var PageInner = require('../../src/PageInner');
var PageBody = require('../../src/PageBody');
var Container = require('../../src/Container');
var Panel = require('../../src/Panel');
var Row = require('../../src/Row');
var ListGroup = require('../../src/ListGroup');

var Footer = require('./Footer');
var Header = require('./Header');

var Menu = function Menu(_ref) {
    var active = _ref.active;
    return React.createElement(
        ListGroup,
        null,
        React.createElement(
            ListGroup.Item,
            { active: active == 'introduction', href: '/' },
            'Introduction'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'icons', href: '/icons' },
            'Logos and Icons'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'buttons', href: '/buttons' },
            'Buttons'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'links', href: '/links' },
            'Links'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'forms', href: '/forms' },
            'Forms and Inputs'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'navigation', href: '/navigation' },
            'Navigation'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'alerts', href: '/alerts' },
            'Alerts'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'blankslates', href: '/blankslates' },
            'Blankslates'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'modals', href: '/modals' },
            'Modals'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'tooltips', href: '/tooltips' },
            'Tooltips'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'panels', href: '/panels' },
            'Panels'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'dropdowns', href: '/dropdowns' },
            'Dropdowns'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'popovers', href: '/popovers' },
            'Popovers'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'autocomplete', href: '/autocomplete' },
            'Autocomplete'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'avatars', href: '/avatars' },
            'Avatars'
        )
    );
};
Menu.propTypes = {
    active: React.PropTypes.bool
};

var Page = React.createClass({
    displayName: 'Page',

    propTypes: {
        title: React.PropTypes.string,
        active: React.PropTypes.string,
        children: React.PropTypes.node
    },

    render: function render() {
        var _props = this.props,
            title = _props.title,
            children = _props.children,
            active = _props.active;


        return React.createElement(
            PageWrapper,
            null,
            React.createElement(
                _head2.default,
                null,
                React.createElement(
                    'title',
                    null,
                    title
                ),
                React.createElement('link', { rel: 'stylesheet', href: '/static/css/gitbook.css' }),
                React.createElement('link', { rel: 'stylesheet', href: '/static/images/logo/favicon.ico' }),
                React.createElement('link', { rel: 'stylesheet', href: 'https://cdnjs.cloudflare.com/ajax/libs/prism/1.5.1/themes/prism.css' }),
                React.createElement('meta', { charSet: 'UTF-8' }),
                React.createElement('meta', { name: 'viewport', content: 'initial-scale=1.0, width=device-width' })
            ),
            React.createElement(Header, null),
            React.createElement(
                PageBody,
                null,
                React.createElement(
                    PageInner,
                    null,
                    React.createElement(
                        StickyContainer,
                        null,
                        React.createElement(
                            Container,
                            null,
                            React.createElement(
                                Row,
                                null,
                                React.createElement(
                                    Row.Col,
                                    { md: 3 },
                                    React.createElement(
                                        Sticky,
                                        { stickyStyle: { marginTop: 20 } },
                                        React.createElement(
                                            Panel,
                                            null,
                                            React.createElement(Menu, { active: active })
                                        )
                                    )
                                ),
                                React.createElement(
                                    Row.Col,
                                    { md: 9 },
                                    children
                                )
                            )
                        )
                    )
                )
            ),
            React.createElement(Footer, null)
        );
    }
});

module.exports = Page;
//# sourceMappingURL=data:application/json;base64,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