'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Panel = require('../src/Panel');
var Container = require('../src/Container');
var Row = require('../src/Row');
var Icon = require('../src/Icon');
var LogoText = require('../icons/LogoText');
var Logo = require('../icons/Logo');

var CodeEditor = require('./components/CodeEditor');

var SOURCE_IMPORT = 'const LogoText = require(\'gitbook-styleguide/icons/LogoText\');\nconst Logo = require(\'gitbook-styleguide/icons/Logo\');\nconst Icon = require(\'gitbook-styleguide/icons/Icon\');';

var LOGOS = [{ source: '<LogoText />', component: function component() {
        return React.createElement(LogoText, { size: 'md' });
    } }, { source: '<Logo />', component: function component() {
        return React.createElement(Logo, { size: 'md' });
    } }];

var OCTICONS = Icon.OCTICONS.map(function (id) {
    return {
        source: '<Icon id="' + id + '" />',
        component: function component() {
            return React.createElement(
                'span',
                { style: { fontSize: 32 } },
                React.createElement(Icon, { id: id, size: 'md' })
            );
        }
    };
});

var IconsSet = React.createClass({
    displayName: 'IconsSet',

    propTypes: {
        icons: React.PropTypes.array.isRequired,
        perLine: React.PropTypes.number
    },

    getDefaultProps: function getDefaultProps() {
        return {
            perLine: 4
        };
    },
    render: function render() {
        var _props = this.props,
            icons = _props.icons,
            perLine = _props.perLine;

        var lines = [];

        while (icons.length > 0) {
            var cells = icons.splice(0, perLine);
            lines.push(React.createElement(
                Row,
                null,
                cells.map(function (cell) {
                    return React.createElement(
                        Row.Col,
                        { md: 12 / perLine },
                        React.createElement(
                            Panel,
                            null,
                            React.createElement(
                                Panel.Body,
                                null,
                                React.createElement(
                                    'div',
                                    { style: { textAlign: 'center' } },
                                    React.createElement(cell.component, null)
                                )
                            ),
                            React.createElement(
                                Panel.Body,
                                null,
                                React.createElement(
                                    'div',
                                    { style: { textAlign: 'center' } },
                                    React.createElement(
                                        'code',
                                        null,
                                        cell.source
                                    )
                                )
                            )
                        )
                    );
                })
            ));
        }

        return React.createElement(
            Container,
            { fluid: true },
            lines
        );
    }
});

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Logos and Icons', active: 'icons' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Logos and Icons' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'The styleguide provides all logos and icons as react component (rendered as an SVG).'
                ),
                React.createElement(
                    'p',
                    null,
                    'GitBook Styleguide is currently providing the octicons icons set.'
                ),
                React.createElement(CodeEditor, { source: SOURCE_IMPORT })
            )
        ),
        React.createElement(IconsSet, { icons: LOGOS }),
        React.createElement(IconsSet, { icons: OCTICONS })
    );
};
//# sourceMappingURL=data:application/json;base64,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