'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Table = require('../src/Table');
var ListGroup = require('../src/ListGroup');

var SCOPE = { React: React, Panel: Panel, Table: Table, ListGroup: ListGroup };

var EXAMPLE_IMPORT = 'const Panel = require(\'gitbook-styleguide/lib/Panel\');';

var EXAMPLE_DEFAULT = '<Panel>\n    <Panel.Heading title="Title" />\n    <Panel.Body>\n        Body of the panel\n    </Panel.Body>\n</Panel>';

var EXAMPLE_STYLES = '<Panel style="danger">\n    <Panel.Heading title="Title" />\n    <Panel.Body>\n        Body of the panel\n    </Panel.Body>\n</Panel>';

var EXAMPLE_LISTGROUP = '<Panel>\n    <Panel.Heading title="Title" />\n    <ListGroup>\n        <ListGroup.Item active={true}>Account</ListGroup.Item>\n        <ListGroup.Item>Profile</ListGroup.Item>\n        <ListGroup.Item>Notifications</ListGroup.Item>\n    </ListGroup>\n</Panel>';

var EXAMPLE_TABLE = '<Panel>\n    <Panel.Heading title="Title" />\n    <Table>\n        <thead>\n            <tr>\n                <th>Title</th>\n                <th>Updated</th>\n            </tr>\n        </thead>\n        <tbody>\n            <tr>\n                <td>PHP</td>\n                <td>1 month ago</td>\n            </tr>\n            <tr>\n                <td>JS</td>\n                <td>1 month ago</td>\n            </tr>\n        </tbody>\n    </Table>\n</Panel>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Panels', active: 'panels' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Panel' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement('p', null),
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Example', source: EXAMPLE_DEFAULT, scope: SCOPE }),
        React.createElement(Example, { title: 'Styles', source: EXAMPLE_STYLES, scope: SCOPE }),
        React.createElement(Example, { title: 'With a table', source: EXAMPLE_TABLE, scope: SCOPE }),
        React.createElement(Example, { title: 'With a list group', source: EXAMPLE_LISTGROUP, scope: SCOPE })
    );
};
//# sourceMappingURL=data:application/json;base64,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