'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Tooltip = require('../src/Tooltip');
var Button = require('../src/Button');

var SCOPE = { React: React, Tooltip: Tooltip, Button: Button };

var EXAMPLE_IMPORT = 'const Tooltip = require(\'gitbook-styleguide/lib/Tooltip\');';

var EXAMPLE_DEFAULT = '<Tooltip title="Hello World">\n     There is a tooltip\n</Tooltip>\n<Tooltip title="Hello World">\n     , hover this text.\n</Tooltip>\n<Tooltip title="Hello World" open>\n     This one is open\n</Tooltip>';

var EXAMPLE_POSITIONS = '<Tooltip title="Bottom right" open position={Tooltip.POSITIONS.BOTTOM_RIGHT}>\n    <code>Bottom right</code>\n</Tooltip>\n<Tooltip title="Top right" open position={Tooltip.POSITIONS.TOP_RIGHT}>\n    <code>Top right</code>\n</Tooltip>\n<Tooltip title="Bottom" open position={Tooltip.POSITIONS.BOTTOM}>\n    <code>Bottom</code>\n</Tooltip>\n<Tooltip title="Bottom left" open position={Tooltip.POSITIONS.BOTTOM_LEFT}>\n    <code>Bottom left</code>\n</Tooltip>\n<Tooltip title="Top" open position={Tooltip.POSITIONS.TOP}>\n    <code>Top</code>\n</Tooltip>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Tooltips', active: 'tooltips' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Tooltips' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Example', source: EXAMPLE_DEFAULT, scope: SCOPE }),
        React.createElement(Example, { title: 'Positions', source: EXAMPLE_POSITIONS, scope: SCOPE })
    );
};
//# sourceMappingURL=data:application/json;base64,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