'use strict';

var React = require('react');
var ReactDOM = require('react-dom');

// left: 37, up: 38, right: 39, down: 40,
// spacebar: 32, pageup: 33, pagedown: 34, end: 35, home: 36
var SCROLLING_KEYS = {
    37: 1,
    38: 1,
    39: 1,
    40: 1
};

/**
 * Backdrop for modals, dropdown, popover.
 *
 *
 * For example:
 *
 * <Backdrop onClose={onClosePopover}>
 *      <Popover>...</Popover>
 * </Backdrop>
 */
var Backdrop = React.createClass({
    displayName: 'Backdrop',

    propTypes: {
        // Scroll is enabled ?
        scroll: React.PropTypes.bool,
        // Close on escape
        escape: React.PropTypes.bool,
        // Z-index for the backdrop
        zIndex: React.PropTypes.number,
        // Callback when backdrop is closed
        onClose: React.PropTypes.func.isRequired,
        children: React.PropTypes.node.isRequired,
        wrapper: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            scroll: false,
            escape: true,
            zIndex: 200,
            wrapper: React.createElement('div', null)
        };
    },
    onClose: function onClose() {
        var onClose = this.props.onClose;

        onClose();
    },


    /**
     * Clicking should close the backdrop.
     */
    onClick: function onClick(event) {
        event.stopPropagation();
        event.preventDefault();
        this.onClose();
    },


    /**
     * Escape should close the backdrop
     */
    onKeyDown: function onKeyDown(event) {
        var escape = this.props.escape;


        if (event.keyCode === 27 && escape) {
            this.onClose();
        }

        if (SCROLLING_KEYS[event.keyCode]) {
            event.preventDefault();
            return false;
        }
    },


    /**
     * Prevent scroll on wrapper itself.
     */
    onScroll: function onScroll(event) {
        var scroll = this.props.scroll;

        if (scroll) {
            return;
        }

        var container = ReactDOM.findDOMNode(this.refs.wrapper);
        var backdrop = ReactDOM.findDOMNode(this.refs.backdrop);

        if (event.target == container || event.target == backdrop) {
            event.preventDefault();
            event.stopPropagation();
        }
    },
    bindEvents: function bindEvents() {
        var container = ReactDOM.findDOMNode(this.refs.wrapper);

        window.addEventListener('keydown', this.onKeyDown);
        container.addEventListener('scroll', this.onScroll);
        container.addEventListener('wheel', this.onScroll);
    },
    unbindEvents: function unbindEvents() {
        var container = ReactDOM.findDOMNode(this.refs.wrapper);

        window.removeEventListener('keydown', this.onKeyDown);
        container.removeEventListener('scroll', this.onScroll);
        container.removeEventListener('wheel', this.onScroll);
    },
    componentDidMount: function componentDidMount() {
        this.bindEvents();
    },
    componentWillUpdate: function componentWillUpdate() {
        this.unbindEvents();
    },
    componentDidUpdate: function componentDidUpdate() {
        this.bindEvents();
    },
    componentWillUnmount: function componentWillUnmount() {
        this.unbindEvents();
    },
    render: function render() {
        var _props = this.props,
            zIndex = _props.zIndex,
            wrapper = _props.wrapper,
            children = _props.children;

        var style = {
            zIndex: zIndex,
            position: 'fixed',
            top: 0,
            right: 0,
            width: '100%',
            height: '100%'
        };

        return React.cloneElement(wrapper, { ref: 'wrapper' }, React.createElement('div', {
            className: 'Backdrop',
            ref: 'backdrop',
            style: style,
            onClick: this.onClick
        }), wrapper.props.children, children);
    }
});

module.exports = Backdrop;
//# sourceMappingURL=data:application/json;base64,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