'use strict';

var React = require('react');
var classNames = require('classnames');

var Icon = require('./Icon');

/**
 * Blankslate represent an emptycontent
 *
 * <Blankslate icon="book">
 *      <h3>No books</h3>
 *      <p>Create a book to get started</p>
 * </Blankslate>
 */

var Blankslate = React.createClass({
    displayName: 'Blankslate',

    propTypes: {
        icon: React.PropTypes.string,
        background: React.PropTypes.bool,
        full: React.PropTypes.bool,
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            background: false,
            full: true
        };
    },
    render: function render() {
        var inner = void 0;
        var icon = this.props.icon;
        var className = classNames('blankslate', {
            'with-background': this.props.background,
            'full-width': this.props.full
        });

        if (icon) {
            inner = React.createElement(
                BlankslateIcon,
                null,
                React.createElement(Icon, { id: icon })
            );
        }

        return React.createElement(
            'div',
            { className: className },
            inner,
            this.props.children
        );
    }
});

var BlankslateIcon = React.createClass({
    displayName: 'BlankslateIcon',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'icon' },
            this.props.children
        );
    }
});

/*
 * A full space layout with a blanksate
 */
var BlankslateLayout = React.createClass({
    displayName: 'BlankslateLayout',

    propTypes: {
        background: React.PropTypes.bool,
        children: React.PropTypes.node
    },

    render: function render() {
        var _props = this.props,
            children = _props.children,
            background = _props.background;

        var className = classNames('blankslate-layout', {
            'with-background': background
        });

        return React.createElement(
            'div',
            { className: className },
            children
        );
    }
});

module.exports = Blankslate;
module.exports.Layout = BlankslateLayout;
module.exports.Icon = BlankslateIcon;
//# sourceMappingURL=data:application/json;base64,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