'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var React = require('react');
var classNames = require('classnames');

var SIZES = require('./SIZES');
var DIRECTIONS = ['left', 'right'];

var Checkbox = React.createClass({
    displayName: 'Checkbox',


    propTypes: {
        children: React.PropTypes.node,
        checked: React.PropTypes.bool,
        defaultChecked: React.PropTypes.bool,
        onChange: React.PropTypes.func,
        name: React.PropTypes.string,
        disabled: React.PropTypes.bool,
        displaySwitch: React.PropTypes.bool,
        size: React.PropTypes.oneOf(SIZES),
        direction: React.PropTypes.oneOf(DIRECTIONS)
    },

    getDefaultProps: function getDefaultProps() {
        return {
            displaySwitch: true,
            size: SIZES[0],
            direction: DIRECTIONS[0]
        };
    },
    onSwitchClick: function onSwitchClick(event) {
        event.stopPropagation();
        this.refs.checkbox.click();
    },
    render: function render() {
        var _props = this.props,
            size = _props.size,
            displaySwitch = _props.displaySwitch,
            direction = _props.direction,
            children = _props.children,
            props = _objectWithoutProperties(_props, ['size', 'displaySwitch', 'direction', 'children']);

        var className = classNames('checkbox', 'switch-' + size, 'switch-' + direction, {
            'checkbox-switch': displaySwitch
        });

        return React.createElement(
            'div',
            { className: className },
            React.createElement(
                'label',
                { htmlFor: this.props.name },
                React.createElement('input', _extends({
                    ref: 'checkbox',
                    type: 'checkbox'
                }, props)),
                displaySwitch ? React.createElement('span', { onClick: this.onSwitchClick }) : null,
                React.createElement(
                    'div',
                    { className: 'checkbox-inline-label', onClick: this.onSwitchClick },
                    children
                )
            )
        );
    }
});

module.exports = Checkbox;
//# sourceMappingURL=data:application/json;base64,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