'use strict';

var React = require('react');
var classNames = require('classnames');

var OCTICONS = ['alert', 'arrow-down', 'arrow-left', 'arrow-right', 'arrow-small-down', 'arrow-small-left', 'arrow-small-right', 'arrow-small-up', 'arrow-up', 'beaker', 'bell', 'bold', 'book', 'bookmark', 'briefcase', 'broadcast', 'browser', 'bug', 'calendar', 'check', 'checklist', 'chevron-down', 'chevron-left', 'chevron-right', 'chevron-up', 'circle-slash', 'circuit-board', 'clippy', 'clock', 'cloud-download', 'cloud-upload', 'code', 'comment-discussion', 'comment', 'credit-card', 'dash', 'dashboard', 'database', 'desktop-download', 'device-camera-video', 'device-camera', 'device-desktop', 'device-mobile', 'diff-added', 'diff-ignored', 'diff-modified', 'diff-removed', 'diff-renamed', 'diff', 'ellipsis', 'eye', 'file-binary', 'file-code', 'file-directory', 'file-media', 'file-pdf', 'file-submodule', 'file-symlink-directory', 'file-symlink-file', 'file-text', 'file-zip', 'flame', 'fold', 'gear', 'gift', 'gist-secret', 'gist', 'git-branch', 'git-commit', 'git-compare', 'git-merge', 'git-pull-request', 'globe', 'graph', 'heart', 'history', 'home', 'horizontal-rule', 'hubot', 'inbox', 'info', 'issue-closed', 'issue-opened', 'issue-reopened', 'italic', 'jersey', 'key', 'keyboard', 'law', 'light-bulb', 'link-external', 'link', 'list-ordered', 'list-unordered', 'location', 'lock', 'logo-gist', 'logo-github', 'mail-read', 'mail-reply', 'mail', 'mark-github', 'markdown', 'megaphone', 'mention', 'milestone', 'mirror', 'mortar-board', 'mute', 'no-newline', 'octoface', 'organization', 'package', 'paintcan', 'pencil', 'person', 'pin', 'plug', 'plus', 'primitive-dot', 'primitive-square', 'pulse', 'question', 'quote', 'radio-tower', 'repo-clone', 'repo-force-push', 'repo-forked', 'repo-pull', 'repo-push', 'repo', 'rocket', 'rss', 'ruby', 'search', 'server', 'settings', 'shield', 'sign-in', 'sign-out', 'smiley', 'squirrel', 'star', 'stop', 'sync', 'tag', 'tasklist', 'telescope', 'terminal', 'text-size', 'three-bars', 'thumbsdown', 'thumbsup', 'tools', 'trashcan', 'triangle-down', 'triangle-left', 'triangle-right', 'triangle-up', 'unfold', 'unmute', 'verified', 'versions', 'watch', 'x', 'zap'];

/**
 * Render an icon from octicon or font-awesome
 * @type {ReactClass}
 */
var Icon = React.createClass({
    displayName: 'Icon',

    statics: {
        OCTICONS: OCTICONS
    },

    propTypes: {
        // Icon of the icon in the collection
        id: React.PropTypes.string,
        // Type of collection
        type: React.PropTypes.string,
        // Extra className
        className: React.PropTypes.string,
        // Is the icon spinning?
        spin: React.PropTypes.bool
    },

    getDefaultProps: function getDefaultProps() {
        return {
            type: 'octicon',
            spin: false
        };
    },
    render: function render() {
        var _props = this.props,
            type = _props.type,
            id = _props.id,
            className = _props.className,
            spin = _props.spin;


        className = classNames('Icon', type + ' ' + type + '-' + id, className, {
            'icon-spin': spin
        });

        return React.createElement('i', { className: className });
    }
});

module.exports = Icon;
//# sourceMappingURL=data:application/json;base64,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