'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var React = require('react');
var classNames = require('classnames');

var Link = React.createClass({
    displayName: 'Link',

    propTypes: {
        href: React.PropTypes.string,
        className: React.PropTypes.string,
        children: React.PropTypes.node,
        muted: React.PropTypes.bool,
        underlined: React.PropTypes.bool,
        onClick: React.PropTypes.func
    },

    getDefaultProps: function getDefaultProps() {
        return {
            href: '#'
        };
    },
    onClick: function onClick(e) {
        var onClick = this.props.onClick;


        if (onClick) {
            e.preventDefault();
            onClick(e);
        }
    },
    render: function render() {
        var _props = this.props,
            href = _props.href,
            className = _props.className,
            children = _props.children,
            muted = _props.muted,
            underlined = _props.underlined,
            onClick = _props.onClick,
            props = _objectWithoutProperties(_props, ['href', 'className', 'children', 'muted', 'underlined', 'onClick']);

        className = classNames(className, {
            'muted-link': muted,
            'underlined-link': underlined
        });

        return React.createElement(
            'a',
            _extends({ className: className,
                href: href,
                onClick: this.onClick
            }, props),
            children
        );
    }
});

module.exports = Link;
//# sourceMappingURL=data:application/json;base64,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