'use strict';

var React = require('react');
var classNames = require('classnames');

var SIZES = require('./SIZES');

var Modal = React.createClass({
    displayName: 'Modal',

    propTypes: {
        size: React.PropTypes.oneOf(SIZES),
        backdrop: React.PropTypes.bool,
        animated: React.PropTypes.bool,
        children: React.PropTypes.node,
        className: React.PropTypes.string
    },

    getDefaultProps: function getDefaultProps() {
        return {
            size: 'md',
            backdrop: true,
            animated: true
        };
    },
    render: function render() {
        var _props = this.props,
            size = _props.size,
            backdrop = _props.backdrop,
            animated = _props.animated,
            children = _props.children;


        var className = classNames('modal', 'modal-' + size, this.props.className, {
            animated: animated,
            'without-backdrop': !backdrop
        });

        return React.createElement(
            'div',
            { className: className },
            children
        );
    }
});

var ModalBackdrop = React.createClass({
    displayName: 'ModalBackdrop',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'modal-backdrop' },
            this.props.children
        );
    }
});

var ModalBody = React.createClass({
    displayName: 'ModalBody',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'modal-body' },
            this.props.children
        );
    }
});

var ModalFooter = React.createClass({
    displayName: 'ModalFooter',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'modal-footer ' },
            this.props.children
        );
    }
});

var ModalHeading = React.createClass({
    displayName: 'ModalHeading',

    propTypes: {
        children: React.PropTypes.node,
        onClose: React.PropTypes.func,
        title: React.PropTypes.string
    },

    onClose: function onClose(e) {
        e.preventDefault();
        this.props.onClose();
    },
    render: function render() {
        if (this.props.title) {
            return React.createElement(
                'div',
                { className: 'modal-heading' },
                React.createElement(
                    'h4',
                    null,
                    this.props.title
                ),
                this.props.onClose ? React.createElement(
                    'a',
                    { href: '#', onClick: this.onClose, className: 'modal-close' },
                    '\xD7'
                ) : ''
            );
        }

        return React.createElement(
            'div',
            { className: 'modal-heading' },
            this.props.children
        );
    }
});

module.exports = Modal;
module.exports.Backdrop = ModalBackdrop;
module.exports.Body = ModalBody;
module.exports.Footer = ModalFooter;
module.exports.Heading = ModalHeading;
//# sourceMappingURL=data:application/json;base64,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