'use strict';

var React = require('react');
var classNames = require('classnames');
var Icon = require('./Icon');

/**
 * Component to create overviews/intros with a title, description,
 * metas info (links), and a picture.
 */
var Overview = React.createClass({
    displayName: 'Overview',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'overview' },
            this.props.children
        );
    }
});

Overview.Title = React.createClass({
    displayName: 'Title',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'h1',
            { className: 'overview-title' },
            this.props.children
        );
    }
});

Overview.StepTitle = React.createClass({
    displayName: 'StepTitle',

    propTypes: {
        children: React.PropTypes.node,
        primary: React.PropTypes.bool,
        href: React.PropTypes.string
    },

    render: function render() {
        var _props = this.props,
            children = _props.children,
            primary = _props.primary,
            href = _props.href;

        var className = classNames('overview-steptitle', {
            primary: primary
        });

        if (href) {
            return React.createElement(
                'a',
                { href: href, className: className },
                children
            );
        }

        return React.createElement(
            'div',
            { className: className },
            children
        );
    }
});

Overview.StepDivider = React.createClass({
    displayName: 'StepDivider',
    render: function render() {
        return React.createElement(
            'div',
            { className: 'overview-stepdivider' },
            React.createElement(Icon, { id: 'chevron-right' })
        );
    }
});

Overview.Note = React.createClass({
    displayName: 'Note',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'p',
            { className: 'overview-note' },
            this.props.children
        );
    }
});

Overview.Description = React.createClass({
    displayName: 'Description',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'p',
            { className: 'overview-description' },
            this.props.children
        );
    }
});

Overview.Meta = React.createClass({
    displayName: 'Meta',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'overview-meta' },
            this.props.children
        );
    }
});

module.exports = Overview;
//# sourceMappingURL=data:application/json;base64,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