'use strict';

var React = require('react');
var classNames = require('classnames');

var Pagination = React.createClass({
    displayName: 'Pagination',

    propTypes: {
        // Index of current page
        page: React.PropTypes.number.isRequired,

        // Total count of pages
        pages: React.PropTypes.number.isRequired,

        // Minimum number of pages to list
        pagesToList: React.PropTypes.number,

        // Callback when page changed (optional)
        onChange: React.PropTypes.func,

        // Current uri
        getURL: React.PropTypes.func
    },

    getDefaultProps: function getDefaultProps() {
        return {
            getURL: function getURL(page) {
                return '?page=' + page;
            },
            pagesToList: 5
        };
    },


    /**
     * Clicked to select a page
     * @param  {Number} i
     */
    onSelectPage: function onSelectPage(i, e) {
        if (this.props.onChange) {
            e.preventDefault();
            return this.props.onChange(i);
        }
    },


    /**
     * Render a page selector
     * @param {Number} i
     * @param {String} text
     * @return {React.Element}
     */
    renderPageItem: function renderPageItem(i, text) {
        var page = this.props.page;
        var isActive = i === page;
        var className = classNames({
            active: isActive
        });
        var uri = this.props.getURL(i);

        return React.createElement(
            'li',
            { key: i, className: className },
            React.createElement(
                'a',
                { href: uri, onClick: this.onSelectPage.bind(this, i) },
                text || i + 1
            )
        );
    },
    render: function render() {
        var page = this.props.page;
        var pages = this.props.pages;
        var pagesToList = this.props.pagesToList;

        if (pages < 2) {
            return React.createElement('div', null);
        }

        var maxPage = pages - 1;
        if (page < 0) page = 0;
        if (page > maxPage) page = maxPage;

        // startRange, inclusive
        var startRange = Math.max(0, page - pagesToList);
        // endRange, inclusive
        var endRange = Math.min(maxPage, page + pagesToList);
        // All the displayed page numbers
        var pagesRange = Array.from(Array(pages)).map(Number.call, Number).slice(startRange, endRange + 1);

        return React.createElement(
            'div',
            { className: 'pagination' },
            React.createElement(
                'ul',
                { className: 'pagination-pages' },
                startRange === 0 ? '' : this.renderPageItem(0),
                startRange === 0 ? '' : React.createElement(
                    'li',
                    null,
                    React.createElement(
                        'span',
                        { className: 'separator' },
                        '...'
                    )
                ),
                pagesRange.map(function (i) {
                    return this.renderPageItem(i);
                }, this),
                endRange === maxPage ? '' : React.createElement(
                    'li',
                    null,
                    React.createElement(
                        'span',
                        { className: 'separator' },
                        '...'
                    )
                ),
                endRange === maxPage ? '' : this.renderPageItem(maxPage)
            ),
            React.createElement(
                'ul',
                { className: 'pagination-nav' },
                page < 1 ? '' : this.renderPageItem(page - 1, '« previous page'),
                page >= maxPage - 1 ? '' : this.renderPageItem(page + 1, 'next page »')
            )
        );
    }
});

module.exports = Pagination;
//# sourceMappingURL=data:application/json;base64,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