'use strict';

var React = require('react');
var classNames = require('classnames');
var SIZES = require('./SIZES');

var Row = React.createClass({
    displayName: 'Row',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'row' },
            this.props.children
        );
    }
});

var Container = require('./Container');

var Column = React.createClass({
    displayName: 'Column',

    propTypes: {
        children: React.PropTypes.node,
        className: React.PropTypes.string
    },

    render: function render() {
        var _this = this;

        var _props = this.props,
            children = _props.children,
            className = _props.className;


        var cl = classNames(className, SIZES.reduce(function (list, size) {
            var col = _this.props[size];
            var offset = _this.props[size + 'Offset'];

            if (col) {
                list.push(['col', size, col].join('-'));
            }
            if (offset) {
                list.push(['col', size, 'offset', offset].join('-'));
            }

            return list;
        }, []));

        return React.createElement(
            'div',
            { className: cl },
            children
        );
    }
});

module.exports = Row;
module.exports.Container = Container;
module.exports.Col = Column;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9Sb3cuanMiXSwibmFtZXMiOlsiUmVhY3QiLCJyZXF1aXJlIiwiY2xhc3NOYW1lcyIsIlNJWkVTIiwiUm93IiwiY3JlYXRlQ2xhc3MiLCJwcm9wVHlwZXMiLCJjaGlsZHJlbiIsIlByb3BUeXBlcyIsIm5vZGUiLCJyZW5kZXIiLCJwcm9wcyIsIkNvbnRhaW5lciIsIkNvbHVtbiIsImNsYXNzTmFtZSIsInN0cmluZyIsImNsIiwicmVkdWNlIiwibGlzdCIsInNpemUiLCJjb2wiLCJvZmZzZXQiLCJwdXNoIiwiam9pbiIsIm1vZHVsZSIsImV4cG9ydHMiLCJDb2wiXSwibWFwcGluZ3MiOiI7O0FBQUEsSUFBTUEsUUFBUUMsUUFBUSxPQUFSLENBQWQ7QUFDQSxJQUFNQyxhQUFhRCxRQUFRLFlBQVIsQ0FBbkI7QUFDQSxJQUFNRSxRQUFRRixRQUFRLFNBQVIsQ0FBZDs7QUFFQSxJQUFNRyxNQUFNSixNQUFNSyxXQUFOLENBQWtCO0FBQUE7O0FBQzFCQyxlQUFXO0FBQ1BDLGtCQUFVUCxNQUFNUSxTQUFOLENBQWdCQztBQURuQixLQURlOztBQUsxQkMsVUFMMEIsb0JBS2pCO0FBQ0wsZUFBTztBQUFBO0FBQUEsY0FBSyxXQUFVLEtBQWY7QUFDRixpQkFBS0MsS0FBTCxDQUFXSjtBQURULFNBQVA7QUFHSDtBQVR5QixDQUFsQixDQUFaOztBQVlBLElBQU1LLFlBQVlYLFFBQVEsYUFBUixDQUFsQjs7QUFFQSxJQUFNWSxTQUFTYixNQUFNSyxXQUFOLENBQWtCO0FBQUE7O0FBQzdCQyxlQUFXO0FBQ1BDLGtCQUFXUCxNQUFNUSxTQUFOLENBQWdCQyxJQURwQjtBQUVQSyxtQkFBV2QsTUFBTVEsU0FBTixDQUFnQk87QUFGcEIsS0FEa0I7O0FBTTdCTCxVQU42QixvQkFNcEI7QUFBQTs7QUFBQSxxQkFDMkIsS0FBS0MsS0FEaEM7QUFBQSxZQUNHSixRQURILFVBQ0dBLFFBREg7QUFBQSxZQUNhTyxTQURiLFVBQ2FBLFNBRGI7OztBQUdMLFlBQU1FLEtBQUtkLFdBQVdZLFNBQVgsRUFBc0JYLE1BQU1jLE1BQU4sQ0FBYSxVQUFDQyxJQUFELEVBQU9DLElBQVAsRUFBZ0I7QUFDMUQsZ0JBQU1DLE1BQU0sTUFBS1QsS0FBTCxDQUFXUSxJQUFYLENBQVo7QUFDQSxnQkFBTUUsU0FBUyxNQUFLVixLQUFMLENBQWNRLElBQWQsWUFBZjs7QUFFQSxnQkFBSUMsR0FBSixFQUFTO0FBQ0xGLHFCQUFLSSxJQUFMLENBQVUsQ0FBQyxLQUFELEVBQVFILElBQVIsRUFBY0MsR0FBZCxFQUFtQkcsSUFBbkIsQ0FBd0IsR0FBeEIsQ0FBVjtBQUNIO0FBQ0QsZ0JBQUlGLE1BQUosRUFBWTtBQUNSSCxxQkFBS0ksSUFBTCxDQUFVLENBQUMsS0FBRCxFQUFRSCxJQUFSLEVBQWMsUUFBZCxFQUF3QkUsTUFBeEIsRUFBZ0NFLElBQWhDLENBQXFDLEdBQXJDLENBQVY7QUFDSDs7QUFFRCxtQkFBT0wsSUFBUDtBQUNILFNBWmdDLEVBWTlCLEVBWjhCLENBQXRCLENBQVg7O0FBY0EsZUFDSTtBQUFBO0FBQUEsY0FBSyxXQUFXRixFQUFoQjtBQUNNVDtBQUROLFNBREo7QUFLSDtBQTVCNEIsQ0FBbEIsQ0FBZjs7QUFnQ0FpQixPQUFPQyxPQUFQLEdBQTJCckIsR0FBM0I7QUFDQW9CLE9BQU9DLE9BQVAsQ0FBZWIsU0FBZixHQUEyQkEsU0FBM0I7QUFDQVksT0FBT0MsT0FBUCxDQUFlQyxHQUFmLEdBQTJCYixNQUEzQiIsImZpbGUiOiJSb3cuanMiLCJzb3VyY2VSb290IjoiL1VzZXJzL2pwcmV5bmF0L0dpdEJvb2svc3R5bGVndWlkZSIsInNvdXJjZXNDb250ZW50IjpbImNvbnN0IFJlYWN0ID0gcmVxdWlyZSgncmVhY3QnKTtcbmNvbnN0IGNsYXNzTmFtZXMgPSByZXF1aXJlKCdjbGFzc25hbWVzJyk7XG5jb25zdCBTSVpFUyA9IHJlcXVpcmUoJy4vU0laRVMnKTtcblxuY29uc3QgUm93ID0gUmVhY3QuY3JlYXRlQ2xhc3Moe1xuICAgIHByb3BUeXBlczoge1xuICAgICAgICBjaGlsZHJlbjogUmVhY3QuUHJvcFR5cGVzLm5vZGVcbiAgICB9LFxuXG4gICAgcmVuZGVyKCkge1xuICAgICAgICByZXR1cm4gPGRpdiBjbGFzc05hbWU9XCJyb3dcIj5cbiAgICAgICAgICAgIHt0aGlzLnByb3BzLmNoaWxkcmVufVxuICAgICAgICA8L2Rpdj47XG4gICAgfVxufSk7XG5cbmNvbnN0IENvbnRhaW5lciA9IHJlcXVpcmUoJy4vQ29udGFpbmVyJyk7XG5cbmNvbnN0IENvbHVtbiA9IFJlYWN0LmNyZWF0ZUNsYXNzKHtcbiAgICBwcm9wVHlwZXM6IHtcbiAgICAgICAgY2hpbGRyZW46ICBSZWFjdC5Qcm9wVHlwZXMubm9kZSxcbiAgICAgICAgY2xhc3NOYW1lOiBSZWFjdC5Qcm9wVHlwZXMuc3RyaW5nXG4gICAgfSxcblxuICAgIHJlbmRlcigpIHtcbiAgICAgICAgY29uc3QgeyBjaGlsZHJlbiwgY2xhc3NOYW1lIH0gPSB0aGlzLnByb3BzO1xuXG4gICAgICAgIGNvbnN0IGNsID0gY2xhc3NOYW1lcyhjbGFzc05hbWUsIFNJWkVTLnJlZHVjZSgobGlzdCwgc2l6ZSkgPT4ge1xuICAgICAgICAgICAgY29uc3QgY29sID0gdGhpcy5wcm9wc1tzaXplXTtcbiAgICAgICAgICAgIGNvbnN0IG9mZnNldCA9IHRoaXMucHJvcHNbYCR7c2l6ZX1PZmZzZXRgXTtcblxuICAgICAgICAgICAgaWYgKGNvbCkge1xuICAgICAgICAgICAgICAgIGxpc3QucHVzaChbJ2NvbCcsIHNpemUsIGNvbF0uam9pbignLScpKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGlmIChvZmZzZXQpIHtcbiAgICAgICAgICAgICAgICBsaXN0LnB1c2goWydjb2wnLCBzaXplLCAnb2Zmc2V0Jywgb2Zmc2V0XS5qb2luKCctJykpO1xuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICByZXR1cm4gbGlzdDtcbiAgICAgICAgfSwgW10pKTtcblxuICAgICAgICByZXR1cm4gKFxuICAgICAgICAgICAgPGRpdiBjbGFzc05hbWU9e2NsfT5cbiAgICAgICAgICAgICAgICB7IGNoaWxkcmVuIH1cbiAgICAgICAgICAgIDwvZGl2PlxuICAgICAgICApO1xuICAgIH1cbn0pO1xuXG5cbm1vZHVsZS5leHBvcnRzICAgICAgICAgICA9IFJvdztcbm1vZHVsZS5leHBvcnRzLkNvbnRhaW5lciA9IENvbnRhaW5lcjtcbm1vZHVsZS5leHBvcnRzLkNvbCAgICAgICA9IENvbHVtbjtcbiJdfQ==