'use strict';

var React = require('react');
var classNames = require('classnames');

var Table = React.createClass({
    displayName: 'Table',

    propTypes: {
        bordered: React.PropTypes.bool,
        className: React.PropTypes.string,
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            bordered: false,
            className: ''
        };
    },
    render: function render() {
        var className = classNames('table', { 'table-bordered': this.props.bordered }, this.props.className);

        return React.createElement(
            'table',
            { className: className },
            this.props.children
        );
    }
});

/**
 * ExpendableBody creates a <tbody> element displaying only `display` elements by default
 * If the number of elements is larger than the original `display` prop, a `Show More`
 * button is appended as the last row of the <tbody>. Clicking on it will display `step`
 * more elements each time, until every element is renderded.
 *
 * The elements to display are passed through the `data` prop as an array.
 * Each item of the array can either be:
 *     - a value: the default is to render a single cell with the value for this row
 *     - an array of values: the default is to render each value in a cell for this row
 *     - an object
 *
 * To render an object or customize the display of value(s), the `renderRow` prop accepts
 * a function to which is passed the current row item (value, array or object) and the row index.
 * It must return the corresponding row <tr key={index}> element.
 *
 * Finally, the `cols` prop is used to correctly display the `Show More` button in the table when
 * passing an array of objects to `data`.
 *
 * The `center` props allows for centering all values rendered by default.
 */

var ExpendableBody = React.createClass({
    displayName: 'ExpendableBody',

    propTypes: {
        data: React.PropTypes.array.isRequired,
        display: React.PropTypes.number,
        step: React.PropTypes.number,
        cols: React.PropTypes.string,
        renderRow: React.PropTypes.func,
        center: React.PropTypes.bool
    },

    getDefaultProps: function getDefaultProps() {
        return {
            display: 5,
            step: 5,
            cols: 1,
            center: false
        };
    },
    getInitialState: function getInitialState() {
        return {
            limit: this.props.display
        };
    },
    isArray: function isArray(o) {
        return Object.prototype.toString.call(o) == '[object Array]';
    },
    defaultRenderRow: function defaultRenderRow(item, i) {
        var className = classNames({
            'text-center': this.props.center
        });

        // Array of values per row
        if (this.isArray(item)) {
            return React.createElement(
                'tr',
                { key: i },
                item.map(function (value, j) {
                    return React.createElement(
                        'td',
                        { className: className, key: j },
                        value
                    );
                })
            );
        } else {
            // Single value
            return React.createElement(
                'tr',
                { key: i },
                React.createElement(
                    'td',
                    { className: className },
                    item
                )
            );
        }
    },
    showMore: function showMore() {
        var step = this.props.step;
        var limit = this.state.limit;


        this.setState({
            limit: limit + step
        });
    },
    renderShowMore: function renderShowMore() {
        var _props = this.props,
            data = _props.data,
            cols = _props.cols,
            step = _props.step;
        var limit = this.state.limit;

        var length = data.length;

        // Don't display when everything's on the screen
        if (limit >= length) {
            return null;
        }

        // Try to get colSpan from data if array
        if (Boolean(length) && this.isArray(data[0])) {
            cols = data[0].length.toString();
        }

        return React.createElement(
            'tr',
            null,
            React.createElement(
                'td',
                { className: 'text-center', colSpan: cols },
                React.createElement(
                    'div',
                    { className: 'show-more', onClick: this.showMore },
                    'Show ',
                    step,
                    ' more (',
                    length - limit,
                    ')'
                )
            )
        );
    },
    renderRow: function renderRow(item, i) {
        var renderRow = this.props.renderRow || this.defaultRenderRow;
        return renderRow(item, i);
    },
    render: function render() {
        var data = this.props.data;
        var limit = this.state.limit;


        return React.createElement(
            'tbody',
            { className: 'table-body-expendable' },
            data.slice(0, limit).map(this.renderRow, this),
            this.renderShowMore()
        );
    }
});

module.exports = Table;
module.exports.ExpendableBody = ExpendableBody;
//# sourceMappingURL=data:application/json;base64,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