'use strict';

var React = require('react');
var classNames = require('classnames');

var SIZES = require('./SIZES');

var Textarea = React.createClass({
    displayName: 'Textarea',

    propTypes: {
        onChange: React.PropTypes.func,
        name: React.PropTypes.string,
        className: React.PropTypes.string,
        placeholder: React.PropTypes.string,
        disabled: React.PropTypes.bool,
        autoFocus: React.PropTypes.bool,
        size: React.PropTypes.oneOf(SIZES),
        rows: React.PropTypes.number,
        maxLength: React.PropTypes.number,
        defaultValue: React.PropTypes.string,
        value: React.PropTypes.oneOfType([React.PropTypes.string, React.PropTypes.bool])
    },

    /*
        APIs for parent component
     */
    focus: function focus() {
        this.refs.textarea.focus();
    },
    blur: function blur() {
        this.refs.textarea.blur();
    },
    getDefaultProps: function getDefaultProps() {
        return {
            size: SIZES[0],
            rows: 3
        };
    },
    onChange: function onChange(e) {
        if (this.props.onChange) {
            this.props.onChange(e);
        }
    },
    render: function render() {
        var _props = this.props,
            disabled = _props.disabled,
            name = _props.name,
            placeholder = _props.placeholder,
            size = _props.size,
            rows = _props.rows,
            autoFocus = _props.autoFocus,
            value = _props.value,
            defaultValue = _props.defaultValue,
            maxLength = _props.maxLength;


        var className = classNames('form-control', 'input-' + size, this.props.className);

        return React.createElement('textarea', { ref: 'textarea',
            className: className, rows: rows, maxLength: maxLength,
            autoFocus: autoFocus, disabled: disabled,
            name: name, value: value, defaultValue: defaultValue,
            placeholder: placeholder, onChange: this.onChange });
    }
});

module.exports = Textarea;
//# sourceMappingURL=data:application/json;base64,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