'use strict';

var React = require('react');
var classNames = require('classnames');

var POSITIONS = {
    BOTTOM_RIGHT: 'e',
    BOTTOM_LEFT: 'w',
    TOP_LEFT: 'nw',
    TOP_RIGHT: 'ne',
    BOTTOM: '',
    TOP: 'n'
};

var Tooltip = React.createClass({
    displayName: 'Tooltip',

    propTypes: {
        title: React.PropTypes.string.isRequired,
        position: React.PropTypes.string,
        open: React.PropTypes.bool,
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            open: false,
            position: POSITIONS.BOTTOM
        };
    },
    render: function render() {
        var className = classNames('tooltipped-overlay', 'tooltipped-' + this.props.position, 'tooltipped', {
            'tooltipped-o': this.props.open
        });

        return React.createElement(
            'div',
            { className: className, 'aria-label': this.props.title },
            this.props.children
        );
    }
});

module.exports = Tooltip;
module.exports.POSITIONS = POSITIONS;
//# sourceMappingURL=data:application/json;base64,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