'use strict';

var IS_DEV = require('./is-dev');

/**
 * Log a development warning.
 * @param {String} message
 */

module.exports = function warning(message) {
    if (!IS_DEV) {
        return;
    }

    if (typeof console !== 'undefined') {
        var _console;

        for (var _len = arguments.length, more = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
            more[_key - 1] = arguments[_key];
        }

        (_console = console).error.apply(_console, ['Warning: ' + message].concat(more)); // eslint-disable-line no-console
    }

    try {
        // --- Welcome to debugging Slate ---
        // This error was thrown as a convenience so that you can use this stack
        // to find the callsite that caused this warning to fire.
        throw new Error(message);
    } catch (x) {
        // This error is only for debugging
    }
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy91dGlscy93YXJuaW5nLmpzIl0sIm5hbWVzIjpbIklTX0RFViIsInJlcXVpcmUiLCJtb2R1bGUiLCJleHBvcnRzIiwid2FybmluZyIsIm1lc3NhZ2UiLCJjb25zb2xlIiwibW9yZSIsImVycm9yIiwiRXJyb3IiLCJ4Il0sIm1hcHBpbmdzIjoiOztBQUFBLElBQU1BLFNBQVNDLFFBQVEsVUFBUixDQUFmOztBQUVBOzs7OztBQUtBQyxPQUFPQyxPQUFQLEdBQWlCLFNBQVNDLE9BQVQsQ0FBaUJDLE9BQWpCLEVBQW1DO0FBQ2hELFFBQUksQ0FBQ0wsTUFBTCxFQUFhO0FBQ1Q7QUFDSDs7QUFFRCxRQUFJLE9BQU9NLE9BQVAsS0FBbUIsV0FBdkIsRUFBb0M7QUFBQTs7QUFBQSwwQ0FMTUMsSUFLTjtBQUxNQSxnQkFLTjtBQUFBOztBQUNoQyw2QkFBUUMsS0FBUixnQ0FBMEJILE9BQTFCLFNBQXdDRSxJQUF4QyxHQURnQyxDQUNlO0FBQ2xEOztBQUVELFFBQUk7QUFDSjtBQUNBO0FBQ0E7QUFDSSxjQUFNLElBQUlFLEtBQUosQ0FBVUosT0FBVixDQUFOO0FBQ0gsS0FMRCxDQUtFLE9BQU9LLENBQVAsRUFBVTtBQUNaO0FBQ0M7QUFDSixDQWpCRCIsImZpbGUiOiJ3YXJuaW5nLmpzIiwic291cmNlUm9vdCI6Ii9Vc2Vycy9qcHJleW5hdC9HaXRCb29rL3N0eWxlZ3VpZGUiLCJzb3VyY2VzQ29udGVudCI6WyJjb25zdCBJU19ERVYgPSByZXF1aXJlKCcuL2lzLWRldicpO1xuXG4vKipcbiAqIExvZyBhIGRldmVsb3BtZW50IHdhcm5pbmcuXG4gKiBAcGFyYW0ge1N0cmluZ30gbWVzc2FnZVxuICovXG5cbm1vZHVsZS5leHBvcnRzID0gZnVuY3Rpb24gd2FybmluZyhtZXNzYWdlLCAuLi5tb3JlKSB7XG4gICAgaWYgKCFJU19ERVYpIHtcbiAgICAgICAgcmV0dXJuO1xuICAgIH1cblxuICAgIGlmICh0eXBlb2YgY29uc29sZSAhPT0gJ3VuZGVmaW5lZCcpIHtcbiAgICAgICAgY29uc29sZS5lcnJvcihgV2FybmluZzogJHttZXNzYWdlfWAsIC4uLm1vcmUpOyAvLyBlc2xpbnQtZGlzYWJsZS1saW5lIG5vLWNvbnNvbGVcbiAgICB9XG5cbiAgICB0cnkge1xuICAgIC8vIC0tLSBXZWxjb21lIHRvIGRlYnVnZ2luZyBTbGF0ZSAtLS1cbiAgICAvLyBUaGlzIGVycm9yIHdhcyB0aHJvd24gYXMgYSBjb252ZW5pZW5jZSBzbyB0aGF0IHlvdSBjYW4gdXNlIHRoaXMgc3RhY2tcbiAgICAvLyB0byBmaW5kIHRoZSBjYWxsc2l0ZSB0aGF0IGNhdXNlZCB0aGlzIHdhcm5pbmcgdG8gZmlyZS5cbiAgICAgICAgdGhyb3cgbmV3IEVycm9yKG1lc3NhZ2UpO1xuICAgIH0gY2F0Y2ggKHgpIHtcbiAgICAvLyBUaGlzIGVycm9yIGlzIG9ubHkgZm9yIGRlYnVnZ2luZ1xuICAgIH1cbn07XG4iXX0=