'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var React = require('react');
var classNames = require('classnames');

var Link = React.createClass({
    displayName: 'Link',

    propTypes: {
        href: React.PropTypes.string,
        className: React.PropTypes.string,
        children: React.PropTypes.node,
        muted: React.PropTypes.bool,
        underlined: React.PropTypes.bool,
        onClick: React.PropTypes.func
    },

    getDefaultProps: function getDefaultProps() {
        return {
            href: '#'
        };
    },
    onClick: function onClick(e) {
        var onClick = this.props.onClick;


        if (onClick) {
            e.preventDefault();
            onClick(e);
        }
    },
    render: function render() {
        var _props = this.props,
            href = _props.href,
            className = _props.className,
            children = _props.children,
            muted = _props.muted,
            underlined = _props.underlined,
            onClick = _props.onClick,
            props = _objectWithoutProperties(_props, ['href', 'className', 'children', 'muted', 'underlined', 'onClick']);

        className = classNames(className, {
            'muted-link': muted,
            'underlined-link': underlined
        });

        return React.createElement(
            'a',
            _extends({ className: className,
                href: href,
                onClick: this.onClick
            }, props),
            children
        );
    }
});

module.exports = Link;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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