'use strict';

var React = require('react');
var classNames = require('classnames');

var SIZES = require('./SIZES');

var Spinner = React.createClass({
    displayName: 'Spinner',

    propTypes: {
        centered: React.PropTypes.bool,
        inverse: React.PropTypes.bool,
        size: React.PropTypes.oneOf(SIZES)
    },

    getDefaultProps: function getDefaultProps() {
        return {
            centered: true,
            size: 'md'
        };
    },
    render: function render() {
        var className = classNames('gb-spinner', 'spinner-' + this.props.size, {
            'spinner-inverse': this.props.inverse,
            'spinner-centered': this.props.centered
        });

        return React.createElement('span', { className: className });
    }
});

/**
 * Block div representing a loading area
 */
var SpinnerSlate = React.createClass({
    displayName: 'SpinnerSlate',
    render: function render() {
        return React.createElement(
            'div',
            { className: 'gb-spinner-slate' },
            React.createElement(Spinner, this.props)
        );
    }
});

module.exports = Spinner;
module.exports.Slate = SpinnerSlate;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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