/*
 * Copyright (C) 2007-2016 Hypertable, Inc.
 *
 * This file is part of Hypertable.
 *
 * Hypertable is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 3
 * of the License.
 *
 * Hypertable is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

/** @file
 * Definitions for CommAddress.
 * This file contains method definitions for CommAddress, an abstraction class
 * for holding an arbitrary address type.
 */

#include "Common/Compat.h"

#include "CommAddress.h"

using namespace Hypertable;

String CommAddress::to_str() const {
  if (m_type == PROXY)
    return proxy;
  else if (m_type == INET)
    return InetAddr::format(inet);
  return "[NULL]";
}
