<?php
namespace Hypertable_ThriftGen2;
/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
use Thrift\Base\TBase;
use Thrift\Type\TType;
use Thrift\Type\TMessageType;
use Thrift\Exception\TException;
use Thrift\Exception\TProtocolException;
use Thrift\Protocol\TProtocol;
use Thrift\Protocol\TBinaryProtocolAccelerated;
use Thrift\Exception\TApplicationException;


/**
 * HQL service is a superset of Client service
 * 
 * It adds capability to execute HQL queries to the service
 */
interface HqlServiceIf extends \Hypertable_ThriftGen\ClientServiceIf {
  /**
   * Execute an HQL command
   * 
   * @param ns - Namespace id
   * 
   * @param command - HQL command
   * 
   * @param noflush - Do not auto commit any modifications (return a mutator)
   * 
   * @param unbuffered - return a scanner instead of buffered results
   * 
   * @param int $ns
   * @param string $command
   * @param bool $noflush
   * @param bool $unbuffered
   * @return \Hypertable_ThriftGen2\HqlResult Result type of HQL queries
   * 
   * <dl>
   *   <dt>results</dt>
   *   <dd>String results from metadata queries</dd>
   * 
   *   <dt>cells</dt>
   *   <dd>Resulting table cells of for buffered queries</dd>
   * 
   *   <dt>scanner</dt>
   *   <dd>Resulting scanner ID for unbuffered queries</dd>
   * 
   *   <dt>mutator</dt>
   *   <dd>Resulting mutator ID for unflushed modifying queries</dd>
   * </dl>
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function hql_exec($ns, $command, $noflush, $unbuffered);
  /**
   * Convenience method for executing an buffered and flushed query
   * 
   * because thrift doesn't (and probably won't) support default argument values
   * 
   * @param ns - Namespace
   * 
   * @param command - HQL command
   * 
   * @param int $ns
   * @param string $command
   * @return \Hypertable_ThriftGen2\HqlResult Result type of HQL queries
   * 
   * <dl>
   *   <dt>results</dt>
   *   <dd>String results from metadata queries</dd>
   * 
   *   <dt>cells</dt>
   *   <dd>Resulting table cells of for buffered queries</dd>
   * 
   *   <dt>scanner</dt>
   *   <dd>Resulting scanner ID for unbuffered queries</dd>
   * 
   *   <dt>mutator</dt>
   *   <dd>Resulting mutator ID for unflushed modifying queries</dd>
   * </dl>
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function hql_query($ns, $command);
  /**
   * @see hql_exec
   * 
   * @param int $ns
   * @param string $command
   * @param bool $noflush
   * @param bool $unbuffered
   * @return \Hypertable_ThriftGen2\HqlResultAsArrays Same as HqlResult except with cell as array
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function hql_exec_as_arrays($ns, $command, $noflush, $unbuffered);
  /**
   * @param int $ns
   * @param string $command
   * @param bool $noflush
   * @param bool $unbuffered
   * @return \Hypertable_ThriftGen2\HqlResult2 Same as HqlResult except with cell as array
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function hql_exec2($ns, $command, $noflush, $unbuffered);
  /**
   * @see hql_query
   * 
   * @param int $ns
   * @param string $command
   * @return \Hypertable_ThriftGen2\HqlResultAsArrays Same as HqlResult except with cell as array
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function hql_query_as_arrays($ns, $command);
  /**
   * @param int $ns
   * @param string $command
   * @return \Hypertable_ThriftGen2\HqlResult2 Same as HqlResult except with cell as array
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function hql_query2($ns, $command);
}

class HqlServiceClient extends \Hypertable_ThriftGen\ClientServiceClient implements \Hypertable_ThriftGen2\HqlServiceIf {
  public function __construct($input, $output=null) {
    parent::__construct($input, $output);
  }

  public function hql_exec($ns, $command, $noflush, $unbuffered)
  {
    $this->send_hql_exec($ns, $command, $noflush, $unbuffered);
    return $this->recv_hql_exec();
  }

  public function send_hql_exec($ns, $command, $noflush, $unbuffered)
  {
    $args = new \Hypertable_ThriftGen2\HqlService_hql_exec_args();
    $args->ns = $ns;
    $args->command = $command;
    $args->noflush = $noflush;
    $args->unbuffered = $unbuffered;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'hql_exec', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('hql_exec', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_hql_exec()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen2\HqlService_hql_exec_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen2\HqlService_hql_exec_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("hql_exec failed: unknown result");
  }

  public function hql_query($ns, $command)
  {
    $this->send_hql_query($ns, $command);
    return $this->recv_hql_query();
  }

  public function send_hql_query($ns, $command)
  {
    $args = new \Hypertable_ThriftGen2\HqlService_hql_query_args();
    $args->ns = $ns;
    $args->command = $command;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'hql_query', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('hql_query', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_hql_query()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen2\HqlService_hql_query_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen2\HqlService_hql_query_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("hql_query failed: unknown result");
  }

  public function hql_exec_as_arrays($ns, $command, $noflush, $unbuffered)
  {
    $this->send_hql_exec_as_arrays($ns, $command, $noflush, $unbuffered);
    return $this->recv_hql_exec_as_arrays();
  }

  public function send_hql_exec_as_arrays($ns, $command, $noflush, $unbuffered)
  {
    $args = new \Hypertable_ThriftGen2\HqlService_hql_exec_as_arrays_args();
    $args->ns = $ns;
    $args->command = $command;
    $args->noflush = $noflush;
    $args->unbuffered = $unbuffered;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'hql_exec_as_arrays', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('hql_exec_as_arrays', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_hql_exec_as_arrays()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen2\HqlService_hql_exec_as_arrays_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen2\HqlService_hql_exec_as_arrays_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("hql_exec_as_arrays failed: unknown result");
  }

  public function hql_exec2($ns, $command, $noflush, $unbuffered)
  {
    $this->send_hql_exec2($ns, $command, $noflush, $unbuffered);
    return $this->recv_hql_exec2();
  }

  public function send_hql_exec2($ns, $command, $noflush, $unbuffered)
  {
    $args = new \Hypertable_ThriftGen2\HqlService_hql_exec2_args();
    $args->ns = $ns;
    $args->command = $command;
    $args->noflush = $noflush;
    $args->unbuffered = $unbuffered;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'hql_exec2', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('hql_exec2', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_hql_exec2()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen2\HqlService_hql_exec2_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen2\HqlService_hql_exec2_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("hql_exec2 failed: unknown result");
  }

  public function hql_query_as_arrays($ns, $command)
  {
    $this->send_hql_query_as_arrays($ns, $command);
    return $this->recv_hql_query_as_arrays();
  }

  public function send_hql_query_as_arrays($ns, $command)
  {
    $args = new \Hypertable_ThriftGen2\HqlService_hql_query_as_arrays_args();
    $args->ns = $ns;
    $args->command = $command;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'hql_query_as_arrays', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('hql_query_as_arrays', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_hql_query_as_arrays()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen2\HqlService_hql_query_as_arrays_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen2\HqlService_hql_query_as_arrays_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("hql_query_as_arrays failed: unknown result");
  }

  public function hql_query2($ns, $command)
  {
    $this->send_hql_query2($ns, $command);
    return $this->recv_hql_query2();
  }

  public function send_hql_query2($ns, $command)
  {
    $args = new \Hypertable_ThriftGen2\HqlService_hql_query2_args();
    $args->ns = $ns;
    $args->command = $command;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'hql_query2', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('hql_query2', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_hql_query2()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen2\HqlService_hql_query2_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen2\HqlService_hql_query2_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("hql_query2 failed: unknown result");
  }

}

// HELPER FUNCTIONS AND STRUCTURES

class HqlService_hql_exec_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $command = null;
  /**
   * @var bool
   */
  public $noflush = false;
  /**
   * @var bool
   */
  public $unbuffered = false;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'command',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'noflush',
          'type' => TType::BOOL,
          ),
        4 => array(
          'var' => 'unbuffered',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['command'])) {
        $this->command = $vals['command'];
      }
      if (isset($vals['noflush'])) {
        $this->noflush = $vals['noflush'];
      }
      if (isset($vals['unbuffered'])) {
        $this->unbuffered = $vals['unbuffered'];
      }
    }
  }

  public function getName() {
    return 'HqlService_hql_exec_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->command);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->noflush);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->unbuffered);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('HqlService_hql_exec_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->command !== null) {
      $xfer += $output->writeFieldBegin('command', TType::STRING, 2);
      $xfer += $output->writeString($this->command);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->noflush !== null) {
      $xfer += $output->writeFieldBegin('noflush', TType::BOOL, 3);
      $xfer += $output->writeBool($this->noflush);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->unbuffered !== null) {
      $xfer += $output->writeFieldBegin('unbuffered', TType::BOOL, 4);
      $xfer += $output->writeBool($this->unbuffered);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class HqlService_hql_exec_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen2\HqlResult
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen2\HqlResult',
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'HqlService_hql_exec_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Hypertable_ThriftGen2\HqlResult();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('HqlService_hql_exec_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class HqlService_hql_query_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $command = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'command',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['command'])) {
        $this->command = $vals['command'];
      }
    }
  }

  public function getName() {
    return 'HqlService_hql_query_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->command);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('HqlService_hql_query_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->command !== null) {
      $xfer += $output->writeFieldBegin('command', TType::STRING, 2);
      $xfer += $output->writeString($this->command);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class HqlService_hql_query_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen2\HqlResult
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen2\HqlResult',
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'HqlService_hql_query_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Hypertable_ThriftGen2\HqlResult();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('HqlService_hql_query_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class HqlService_hql_exec_as_arrays_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $command = null;
  /**
   * @var bool
   */
  public $noflush = false;
  /**
   * @var bool
   */
  public $unbuffered = false;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'command',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'noflush',
          'type' => TType::BOOL,
          ),
        4 => array(
          'var' => 'unbuffered',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['command'])) {
        $this->command = $vals['command'];
      }
      if (isset($vals['noflush'])) {
        $this->noflush = $vals['noflush'];
      }
      if (isset($vals['unbuffered'])) {
        $this->unbuffered = $vals['unbuffered'];
      }
    }
  }

  public function getName() {
    return 'HqlService_hql_exec_as_arrays_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->command);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->noflush);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->unbuffered);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('HqlService_hql_exec_as_arrays_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->command !== null) {
      $xfer += $output->writeFieldBegin('command', TType::STRING, 2);
      $xfer += $output->writeString($this->command);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->noflush !== null) {
      $xfer += $output->writeFieldBegin('noflush', TType::BOOL, 3);
      $xfer += $output->writeBool($this->noflush);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->unbuffered !== null) {
      $xfer += $output->writeFieldBegin('unbuffered', TType::BOOL, 4);
      $xfer += $output->writeBool($this->unbuffered);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class HqlService_hql_exec_as_arrays_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen2\HqlResultAsArrays
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen2\HqlResultAsArrays',
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'HqlService_hql_exec_as_arrays_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Hypertable_ThriftGen2\HqlResultAsArrays();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('HqlService_hql_exec_as_arrays_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class HqlService_hql_exec2_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $command = null;
  /**
   * @var bool
   */
  public $noflush = false;
  /**
   * @var bool
   */
  public $unbuffered = false;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'command',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'noflush',
          'type' => TType::BOOL,
          ),
        4 => array(
          'var' => 'unbuffered',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['command'])) {
        $this->command = $vals['command'];
      }
      if (isset($vals['noflush'])) {
        $this->noflush = $vals['noflush'];
      }
      if (isset($vals['unbuffered'])) {
        $this->unbuffered = $vals['unbuffered'];
      }
    }
  }

  public function getName() {
    return 'HqlService_hql_exec2_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->command);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->noflush);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->unbuffered);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('HqlService_hql_exec2_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->command !== null) {
      $xfer += $output->writeFieldBegin('command', TType::STRING, 2);
      $xfer += $output->writeString($this->command);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->noflush !== null) {
      $xfer += $output->writeFieldBegin('noflush', TType::BOOL, 3);
      $xfer += $output->writeBool($this->noflush);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->unbuffered !== null) {
      $xfer += $output->writeFieldBegin('unbuffered', TType::BOOL, 4);
      $xfer += $output->writeBool($this->unbuffered);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class HqlService_hql_exec2_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen2\HqlResult2
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen2\HqlResult2',
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'HqlService_hql_exec2_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Hypertable_ThriftGen2\HqlResult2();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('HqlService_hql_exec2_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class HqlService_hql_query_as_arrays_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $command = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'command',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['command'])) {
        $this->command = $vals['command'];
      }
    }
  }

  public function getName() {
    return 'HqlService_hql_query_as_arrays_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->command);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('HqlService_hql_query_as_arrays_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->command !== null) {
      $xfer += $output->writeFieldBegin('command', TType::STRING, 2);
      $xfer += $output->writeString($this->command);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class HqlService_hql_query_as_arrays_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen2\HqlResultAsArrays
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen2\HqlResultAsArrays',
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'HqlService_hql_query_as_arrays_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Hypertable_ThriftGen2\HqlResultAsArrays();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('HqlService_hql_query_as_arrays_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class HqlService_hql_query2_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $command = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'command',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['command'])) {
        $this->command = $vals['command'];
      }
    }
  }

  public function getName() {
    return 'HqlService_hql_query2_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->command);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('HqlService_hql_query2_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->command !== null) {
      $xfer += $output->writeFieldBegin('command', TType::STRING, 2);
      $xfer += $output->writeString($this->command);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class HqlService_hql_query2_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen2\HqlResult2
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen2\HqlResult2',
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'HqlService_hql_query2_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Hypertable_ThriftGen2\HqlResult2();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('HqlService_hql_query2_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}


