#!/bin/bash

usage() {
  echo
  echo "usage: generate-doc.sh <output-directory>"
  echo
  echo "Generates Javascript documentation for Hypertable client.  Documentation is"
  echo "generated with JSdoc using the following command:"
  echo
  echo "  jsdoc -P package.json -d <output-directory> -c jsdoc-conf.json -r lib"
  echo
}

if [ $# -eq 0 ]; then
    usage
    exit 0
else
  case $1 in
    -h|--help)
      usage
      exit 0
      ;;
    *)
      ;;
  esac
fi

cd `pwd`

jsdoc --verbose -P package.json -d $1 -c jsdoc-conf.json -r lib
sed -i 's/>module:hypertable.ColumnFamilyOptions</>ColumnFamilyOptions</g' $1/hypertable/0.9.8/*.html
sed -i 's/>module:hypertable.AccessGroupOptions</>AccessGroupOptions</g' $1/hypertable/0.9.8/*.html
sed -i 's/>module:hypertable.Key</>Key</g' $1/hypertable/0.9.8/*.html
sed -i 's/>module:hypertable.Cell</>Cell</g' $1/hypertable/0.9.8/*.html
