'use strict'
var util = require('util');
var thrift = require('thrift');
var HqlService = require('./HqlService');
var assert = require('assert');

/**
 * Hypertable Thrift client.
 * @example
 * var client = new hypertable.ThriftClient("localhost", 15867);
 * @param {String} host Hostname of ThriftBroker
 * @param {Number} port Port number of ThriftBroker
 * @param {Number} [timeout] Connection timeout
 * @class
 * @classdesc Hypertable thrift client interface
 * @memberof module:hypertable
 */
var ThriftClient = module.exports = function(host, port, timeout) {
  var transport = thrift.TFramedTransport;
  var protocol = thrift.TBinaryProtocol;

  this.connection = thrift.createConnection(host, port, {
      transport : transport,
      protocol : protocol,
      connect_timeout : timeout,
      timeout : timeout
    });

  this.connection.on('error', function(err) {
      assert(false, err);
    });

  var client = thrift.createClient(HqlService, this.connection);

  // Copy properties from client (manually)
  this.output = client.output;
  this.pClass = client.pClass;
  this._seqid = client._seqid;
  this._reqs = client._reqs;
}

util.inherits(ThriftClient, HqlService.Client);

/**
 * Closes connection to ThriftBroker.
 */
ThriftClient.prototype.closeConnection = function() {
  this.connection.end();  
}