CREATE NAMESPACE create_test;
USE create_test;
DROP TABLE IF EXISTS Test1;
CREATE TABLE Test1 (
  'refer-url',
  Green,
  Yellow,
  Orange,
  Red,
  ACCESS GROUP ag1 ('refer-url'),
  ACCESS GROUP ag2 (),
  ACCESS GROUP ag3 (),
  ACCESS GROUP ag4 (Green, Yellow),
  ACCESS GROUP default (Orange, Red)
);
SHOW CREATE TABLE Test1;
DROP TABLE IF EXISTS Test2;
CREATE TABLE Test2 (
  INDEX a,
  ACCESS GROUP ag1 (a),
  ACCESS GROUP ag2 (b),
  a,
  b
);
SHOW CREATE TABLE Test2;
DROP TABLE IF EXISTS Test3;
CREATE TABLE Test3 (
  a TIME_ORDER desc,
  b,
  ACCESS GROUP ag (a, b) MAX_VERSIONS 3
);
SHOW CREATE TABLE Test3;
DROP TABLE IF EXISTS Test4;
CREATE TABLE Test4 (
  a,
  b,
  ACCESS GROUP ag (a, b) MAX_VERSIONS 3
) TIME_ORDER desc;
SHOW CREATE TABLE Test4;
DROP TABLE IF EXISTS Test5;
CREATE TABLE Test5 (
  a,
  b,
  ACCESS GROUP ag1 (a) MAX_VERSIONS 1 REPLICATION 3,
  ACCESS GROUP ag2 (b) COMPRESSOR "none"
) TIME_ORDER desc BLOCKSIZE 32000;
SHOW CREATE TABLE Test5;
DROP TABLE IF EXISTS Test6;
CREATE TABLE Test6 (
  a,
  b,
  ACCESS GROUP ag1 (a) REPLICATION 3,
  ACCESS GROUP ag2 (b) COMPRESSOR "none"
) BLOOMFILTER "rows+cols --false-positive 0.02" COUNTER BLOCKSIZE 32000;
SHOW CREATE TABLE Test6;
DROP TABLE IF EXISTS Foo;
CREATE TABLE Foo (a);
ALTER TABLE Foo ADD (b);
SHOW CREATE TABLE Foo;
ALTER TABLE Foo ADD (c, d);
SHOW CREATE TABLE Foo;
ALTER TABLE Foo MODIFY (a COUNTER);
ALTER TABLE Foo MODIFY (a TIME_ORDER desc);
#ALTER TABLE Foo MODIFY (INDEX a);
#SHOW CREATE TABLE Foo;
#ALTER TABLE Foo MODIFY (QUALIFIER INDEX b);
#SHOW CREATE TABLE Foo;
#ALTER TABLE Foo DROP INDEX a;
#SHOW CREATE TABLE Foo;
#ALTER TABLE Foo DROP QUALIFIER INDEX b;
#SHOW CREATE TABLE Foo;
ALTER TABLE Foo MODIFY (a MAX_VERSIONS 3);
SHOW CREATE TABLE Foo;
ALTER TABLE Foo MODIFY (a TTL 86400);
SHOW CREATE TABLE Foo;
ALTER TABLE Foo MODIFY (ACCESS GROUP default (a, b, c, d) BLOCKSIZE 128000) MODIFY (a MAX_VERSIONS 1);
SHOW CREATE TABLE Foo;
ALTER TABLE Foo MODIFY (a MAX_VERSIONS 2) MODIFY (ACCESS GROUP default (a, b, c, d) BLOCKSIZE 129000);
SHOW CREATE TABLE Foo;
ALTER TABLE Foo DROP (c) MODIFY (ACCESS GROUP default (a, b, d) BLOCKSIZE 130000);
SHOW CREATE TABLE Foo;
ALTER TABLE Foo MODIFY (ACCESS GROUP default (a, b, d) BLOCKSIZE 131000) DROP (b);
SHOW CREATE TABLE Foo;
ALTER TABLE Foo MODIFY (ACCESS GROUP default (a, d) BLOCKSIZE 132000) DROP (a);
SHOW CREATE TABLE Foo;
DESCRIBE TABLE Foo;
DROP TABLE IF EXISTS Bar;
CREATE TABLE Bar (
  a COUNTER false,
  b
) COUNTER;
SHOW CREATE TABLE Bar;
DROP TABLE IF EXISTS Baz;
CREATE TABLE Baz (
  a,
  b,
  ACCESS GROUP meta (a) IN_MEMORY false
) IN_MEMORY true;
SHOW CREATE TABLE Baz;
# Add and drop indices
CREATE NAMESPACE AlterIndex;
USE AlterIndex;
DROP TABLE IF EXISTS foo;
CREATE TABLE foo (
  a,
  b,
  c,
  d,
  e
);
GET LISTING;
ALTER TABLE foo ADD (INDEX a, INDEX b, INDEX c);
SHOW CREATE TABLE foo;
GET LISTING;
ALTER TABLE foo ADD (QUALIFIER INDEX b, QUALIFIER INDEX c, QUALIFIER INDEX d);
SHOW CREATE TABLE foo;
GET LISTING;
ALTER TABLE foo DROP INDEX (a, b);
SHOW CREATE TABLE foo;
GET LISTING;
ALTER TABLE foo DROP INDEX (c);
SHOW CREATE TABLE foo;
GET LISTING;
ALTER TABLE foo DROP QUALIFIER INDEX (b, c);
SHOW CREATE TABLE foo;
GET LISTING;
ALTER TABLE foo DROP QUALIFIER INDEX (d);
SHOW CREATE TABLE foo;
GET LISTING;
ALTER TABLE foo ADD (INDEX d, QUALIFIER INDEX e);
SHOW CREATE TABLE foo;
GET LISTING;
ALTER TABLE foo DROP (e);
SHOW CREATE TABLE foo;
GET LISTING;
ALTER TABLE foo DROP (d);
SHOW CREATE TABLE foo;
GET LISTING;
