# Copyright (C) 2007-2016 Hypertable, Inc.
#
# This file is part of Hypertable.
#
# Hypertable is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 3
# of the License, or any later version.
#
# Hypertable is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Hypertable. If not, see <http://www.gnu.org/licenses/>
#
# figure out version info from the repository

if (VERSION_ADD_COMMIT_SUFFIX)
  exec_program(${HYPERTABLE_SOURCE_DIR}/bin/src-utils/ver ${HYPERTABLE_SOURCE_DIR}
               ARGS "--commit-only" OUTPUT_VARIABLE HT_COMMIT_STRING)
  if (VERSION_MISC_SUFFIX)
    set(VERSION ${VERSION_MAJOR}.${VERSION_MINOR}.${VERSION_MICRO}.${VERSION_PATCH}.${VERSION_MISC_SUFFIX}.${HT_COMMIT_STRING})
  else ()
    set(VERSION ${VERSION_MAJOR}.${VERSION_MINOR}.${VERSION_MICRO}.${VERSION_PATCH}.${HT_COMMIT_STRING})
  endif ()
else ()
  if (VERSION_MISC_SUFFIX)
    set(VERSION ${VERSION_MAJOR}.${VERSION_MINOR}.${VERSION_MICRO}.${VERSION_PATCH}.${VERSION_MISC_SUFFIX})
  else ()
    set(VERSION ${VERSION_MAJOR}.${VERSION_MINOR}.${VERSION_MICRO}.${VERSION_PATCH})
  endif ()
endif ()


exec_program(${HYPERTABLE_SOURCE_DIR}/bin/src-utils/ver ${HYPERTABLE_SOURCE_DIR}
             OUTPUT_VARIABLE HT_GIT_VERSION RETURN_VALUE GIT_RETURN)

if (GIT_RETURN STREQUAL "0")
  set(HT_VCS_STRING ${HT_GIT_VERSION})
else ()
  set(HT_VCS_STRING "exported")
endif ()

set(VERSION_STRING "${VERSION} (${HT_VCS_STRING})")
