/*
 * Copyright (C) 2007-2016 Hypertable, Inc.
 *
 * This file is part of Hypertable.
 *
 * Hypertable is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or any later version.
 *
 * Hypertable is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include "Common/Compat.h"
#include "Common/Error.h"
#include "Common/Logger.h"

#include "AsyncComm/CommBuf.h"

#include "Hyperspace/Protocol.h"
#include "Hyperspace/Master.h"
#include "RequestHandlerDestroySession.h"
#include "Hyperspace/SessionData.h"

using namespace Hyperspace;
using namespace Hypertable;

/*
 *
 */
void RequestHandlerDestroySession::run() {

  try {
    HT_INFOF("Destroying session %llu", (Llu)m_session_id);
    m_master->destroy_session(m_session_id);
  }
  catch (Exception &e) {
    HT_ERROR_OUT << e << HT_END;
  }
}
