/* -*- c++ -*-
 * Copyright (C) 2007-2016 Hypertable, Inc.
 *
 * This file is part of Hypertable.
 *
 * Hypertable is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 3 of the
 * License, or any later version.
 *
 * Hypertable is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include "Common/Compat.h"
#include "Common/Error.h"

#include "OperationWaitForServers.h"

using namespace Hypertable;

OperationWaitForServers::OperationWaitForServers(ContextPtr &context)
  : OperationEphemeral(context, MetaLog::EntityType::OPERATION_WAIT_FOR_SERVERS) {
  m_obstructions.insert(Dependency::SERVERS);
}

void OperationWaitForServers::execute() {

  HT_INFOF("Entering WaitForServers-%lld (state=%s)",
           (Lld)header.id, OperationState::get_text(get_state()));

  if (m_context->rsc_manager->connection_count() == 0) {
    block();
    return;
  }

  complete_ok();

  HT_INFOF("Leaving WaitForServers-%lld (state=%s)",
           (Lld)header.id, OperationState::get_text(get_state()));
}

const String OperationWaitForServers::name() {
  return "OperationWaitForServers";
}

const String OperationWaitForServers::label() {
  return String("WaitForServers");
}

