// This autogenerated skeleton file illustrates how to build a server.
// You should copy it to another filename to avoid overwriting it.

#include "ClientService.h"
#include <thrift/protocol/TBinaryProtocol.h>
#include <thrift/server/TSimpleServer.h>
#include <thrift/transport/TServerSocket.h>
#include <thrift/transport/TBufferTransports.h>

using namespace ::apache::thrift;
using namespace ::apache::thrift::protocol;
using namespace ::apache::thrift::transport;
using namespace ::apache::thrift::server;

using boost::shared_ptr;

using namespace  ::Hypertable::ThriftGen;

class ClientServiceHandler : virtual public ClientServiceIf {
 public:
  ClientServiceHandler() {
    // Your initialization goes here
  }

  /**
   * Create a namespace
   * 
   * @param ns - namespace name
   * 
   * @param ns
   */
  void namespace_create(const std::string& ns) {
    // Your implementation goes here
    printf("namespace_create\n");
  }

  void create_namespace(const std::string& ns) {
    // Your implementation goes here
    printf("create_namespace\n");
  }

  /**
   * Create a table
   * 
   * @param ns - namespace id
   * @param table_name - table name
   * @param schema - schema of the table
   * 
   * @param ns
   * @param table_name
   * @param schema
   */
  void table_create(const Namespace ns, const std::string& table_name, const Schema& schema) {
    // Your implementation goes here
    printf("table_create\n");
  }

  /**
   * Alter a table
   * 
   * @param ns - namespace id
   * @param table_name - table name
   * @param schema - schema of the table
   * 
   * @param ns
   * @param table_name
   * @param schema
   */
  void table_alter(const Namespace ns, const std::string& table_name, const Schema& schema) {
    // Your implementation goes here
    printf("table_alter\n");
  }

  /**
   * Refreshes the cached table information
   * 
   * @param ns - namespace
   * @param table_name - name of the table
   * 
   * @param ns
   * @param table_name
   */
  void refresh_table(const Namespace ns, const std::string& table_name) {
    // Your implementation goes here
    printf("refresh_table\n");
  }

  /**
   * Open a namespace
   * 
   * @param ns - namespace
   * @return value is guaranteed to be non-zero and unique
   * 
   * @param ns
   */
  Namespace namespace_open(const std::string& ns) {
    // Your implementation goes here
    printf("namespace_open\n");
  }

  Namespace open_namespace(const std::string& ns) {
    // Your implementation goes here
    printf("open_namespace\n");
  }

  /**
   * Close a namespace
   * 
   * @param ns - namespace
   * 
   * @param ns
   */
  void namespace_close(const Namespace ns) {
    // Your implementation goes here
    printf("namespace_close\n");
  }

  void close_namespace(const Namespace ns) {
    // Your implementation goes here
    printf("close_namespace\n");
  }

  /**
   * Open a future object
   * @param capacity - Amount of result data the future object can enqueue without blocking threads
   * 
   * @param capacity
   */
  Future future_open(const int32_t capacity) {
    // Your implementation goes here
    printf("future_open\n");
  }

  Future open_future(const int32_t capacity) {
    // Your implementation goes here
    printf("open_future\n");
  }

  /**
   * Cancel tasks outstanding in a future object
   * @param ff - Future object
   * 
   * @param ff
   */
  void future_cancel(const Future ff) {
    // Your implementation goes here
    printf("future_cancel\n");
  }

  void cancel_future(const Future ff) {
    // Your implementation goes here
    printf("cancel_future\n");
  }

  /**
   * Fetch asynchronous results
   * @param ff - Future object which has the asynchronous results
   * @return - result from async scanner/mutator
   * 
   * @param ff
   * @param timeout_millis
   */
  void future_get_result(Result& _return, const Future ff, const int32_t timeout_millis) {
    // Your implementation goes here
    printf("future_get_result\n");
  }

  void get_future_result(Result& _return, const Future ff, const int32_t timeout_millis) {
    // Your implementation goes here
    printf("get_future_result\n");
  }

  /**
   * Fetch asynchronous results
   * @param ff - Future object which has the asynchronous results
   * @return - result from async scanner/mutator
   * 
   * @param ff
   * @param timeout_millis
   */
  void future_get_result_as_arrays(ResultAsArrays& _return, const Future ff, const int32_t timeout_millis) {
    // Your implementation goes here
    printf("future_get_result_as_arrays\n");
  }

  void get_future_result_as_arrays(ResultAsArrays& _return, const Future ff, const int32_t timeout_millis) {
    // Your implementation goes here
    printf("get_future_result_as_arrays\n");
  }

  /**
   * Fetch asynchronous results
   * @param ff - Future object which has the asynchronous results
   * @return - result from async scanner/mutator
   * 
   * @param ff
   * @param timeout_millis
   */
  void future_get_result_serialized(ResultSerialized& _return, const Future ff, const int32_t timeout_millis) {
    // Your implementation goes here
    printf("future_get_result_serialized\n");
  }

  void get_future_result_serialized(ResultSerialized& _return, const Future ff, const int32_t timeout_millis) {
    // Your implementation goes here
    printf("get_future_result_serialized\n");
  }

  /**
   * Check if future object's queue is empty
   * 
   * @param ff
   */
  bool future_is_empty(const Future ff) {
    // Your implementation goes here
    printf("future_is_empty\n");
  }

  /**
   * Check if future object's queue is full
   * 
   * @param ff
   */
  bool future_is_full(const Future ff) {
    // Your implementation goes here
    printf("future_is_full\n");
  }

  /**
   * Check if future object has been cancelled
   * 
   * @param ff
   */
  bool future_is_cancelled(const Future ff) {
    // Your implementation goes here
    printf("future_is_cancelled\n");
  }

  /**
   * Check if future object has outstanding operations
   * 
   * @param ff
   */
  bool future_has_outstanding(const Future ff) {
    // Your implementation goes here
    printf("future_has_outstanding\n");
  }

  /**
   * Close a future object
   * @param ff - the future object to be closed
   * 
   * @param ff
   */
  void future_close(const Future ff) {
    // Your implementation goes here
    printf("future_close\n");
  }

  void close_future(const Future ff) {
    // Your implementation goes here
    printf("close_future\n");
  }

  /**
   * Open a table scanner
   * @param ns - namespace id
   * @param table_name - table name
   * @param scan_spec - scan specification
   * 
   * @param ns
   * @param table_name
   * @param scan_spec
   */
  Scanner scanner_open(const Namespace ns, const std::string& table_name, const ScanSpec& scan_spec) {
    // Your implementation goes here
    printf("scanner_open\n");
  }

  Scanner open_scanner(const Namespace ns, const std::string& table_name, const ScanSpec& scan_spec) {
    // Your implementation goes here
    printf("open_scanner\n");
  }

  /**
   * Open an asynchronous table scanner
   * @param ns - namespace id
   * @param table_name - table name
   * @param future - callback object
   * @param scan_spec - scan specification
   * 
   * @param ns
   * @param table_name
   * @param future
   * @param scan_spec
   */
  ScannerAsync async_scanner_open(const Namespace ns, const std::string& table_name, const Future future, const ScanSpec& scan_spec) {
    // Your implementation goes here
    printf("async_scanner_open\n");
  }

  ScannerAsync open_scanner_async(const Namespace ns, const std::string& table_name, const Future future, const ScanSpec& scan_spec) {
    // Your implementation goes here
    printf("open_scanner_async\n");
  }

  /**
   * Close a table scanner
   * 
   * @param scanner - scanner id to close
   * 
   * @param scanner
   */
  void scanner_close(const Scanner scanner) {
    // Your implementation goes here
    printf("scanner_close\n");
  }

  void close_scanner(const Scanner scanner) {
    // Your implementation goes here
    printf("close_scanner\n");
  }

  /**
   * Cancel a table scanner
   * 
   * @param scanner - scanner id to close
   * 
   * @param scanner
   */
  void async_scanner_cancel(const ScannerAsync scanner) {
    // Your implementation goes here
    printf("async_scanner_cancel\n");
  }

  void cancel_scanner_async(const ScannerAsync scanner) {
    // Your implementation goes here
    printf("cancel_scanner_async\n");
  }

  /**
   * Close a table scanner
   * 
   * @param scanner - scanner id to close
   * 
   * @param scanner
   */
  void async_scanner_close(const ScannerAsync scanner) {
    // Your implementation goes here
    printf("async_scanner_close\n");
  }

  void close_scanner_async(const ScannerAsync scanner) {
    // Your implementation goes here
    printf("close_scanner_async\n");
  }

  /**
   * Iterate over cells of a scanner
   * 
   * @param scanner - scanner id
   * 
   * @param scanner
   */
  void scanner_get_cells(std::vector<Cell> & _return, const Scanner scanner) {
    // Your implementation goes here
    printf("scanner_get_cells\n");
  }

  void next_cells(std::vector<Cell> & _return, const Scanner scanner) {
    // Your implementation goes here
    printf("next_cells\n");
  }

  void scanner_get_cells_as_arrays(std::vector<CellAsArray> & _return, const Scanner scanner) {
    // Your implementation goes here
    printf("scanner_get_cells_as_arrays\n");
  }

  void next_cells_as_arrays(std::vector<CellAsArray> & _return, const Scanner scanner) {
    // Your implementation goes here
    printf("next_cells_as_arrays\n");
  }

  /**
   * Alternative interface returning buffer of serialized cells
   * 
   * @param scanner
   */
  void scanner_get_cells_serialized(CellsSerialized& _return, const Scanner scanner) {
    // Your implementation goes here
    printf("scanner_get_cells_serialized\n");
  }

  void next_cells_serialized(CellsSerialized& _return, const Scanner scanner) {
    // Your implementation goes here
    printf("next_cells_serialized\n");
  }

  /**
   * Iterate over rows of a scanner
   * 
   * @param scanner - scanner id
   * 
   * @param scanner
   */
  void scanner_get_row(std::vector<Cell> & _return, const Scanner scanner) {
    // Your implementation goes here
    printf("scanner_get_row\n");
  }

  void next_row(std::vector<Cell> & _return, const Scanner scanner) {
    // Your implementation goes here
    printf("next_row\n");
  }

  /**
   * Alternative interface using array as cell
   * 
   * @param scanner
   */
  void scanner_get_row_as_arrays(std::vector<CellAsArray> & _return, const Scanner scanner) {
    // Your implementation goes here
    printf("scanner_get_row_as_arrays\n");
  }

  void next_row_as_arrays(std::vector<CellAsArray> & _return, const Scanner scanner) {
    // Your implementation goes here
    printf("next_row_as_arrays\n");
  }

  /**
   * Alternate interface returning a buffer of serialized cells for iterating by row
   * for a given scanner
   * 
   * @param scanner - scanner id
   * 
   * @param scanner
   */
  void scanner_get_row_serialized(CellsSerialized& _return, const Scanner scanner) {
    // Your implementation goes here
    printf("scanner_get_row_serialized\n");
  }

  void next_row_serialized(CellsSerialized& _return, const Scanner scanner) {
    // Your implementation goes here
    printf("next_row_serialized\n");
  }

  /**
   * Get a row (convenience method for random access a row)
   * 
   * @param ns - namespace id
   * 
   * @param table_name - table name
   * 
   * @param row - row key
   * 
   * @return a list of cells (with row_keys unset)
   * 
   * @param ns
   * @param table_name
   * @param row
   */
  void get_row(std::vector<Cell> & _return, const Namespace ns, const std::string& table_name, const std::string& row) {
    // Your implementation goes here
    printf("get_row\n");
  }

  /**
   * Alternative interface using array as cell
   * 
   * @param ns
   * @param name
   * @param row
   */
  void get_row_as_arrays(std::vector<CellAsArray> & _return, const Namespace ns, const std::string& name, const std::string& row) {
    // Your implementation goes here
    printf("get_row_as_arrays\n");
  }

  /**
   * Alternative interface returning buffer of serialized cells
   * 
   * @param ns
   * @param table_name
   * @param row
   */
  void get_row_serialized(CellsSerialized& _return, const Namespace ns, const std::string& table_name, const std::string& row) {
    // Your implementation goes here
    printf("get_row_serialized\n");
  }

  /**
   * Get a cell (convenience method for random access a cell)
   * 
   * @param ns - namespace id
   * 
   * @param table_name - table name
   * 
   * @param row - row key
   * 
   * @param column - column name
   * 
   * @return value (byte sequence)
   * 
   * @param ns
   * @param table_name
   * @param row
   * @param column
   */
  void get_cell(Value& _return, const Namespace ns, const std::string& table_name, const std::string& row, const std::string& column) {
    // Your implementation goes here
    printf("get_cell\n");
  }

  /**
   * Get cells (convenience method for access small amount of cells)
   * 
   * @param ns - namespace id
   *  
   * @param table_name - table name
   * 
   * @param scan_spec - scan specification
   * 
   * @return a list of cells (a cell with no row key set is assumed to have
   *         the same row key as the previous cell)
   * 
   * @param ns
   * @param table_name
   * @param scan_spec
   */
  void get_cells(std::vector<Cell> & _return, const Namespace ns, const std::string& table_name, const ScanSpec& scan_spec) {
    // Your implementation goes here
    printf("get_cells\n");
  }

  /**
   * Alternative interface using array as cell
   * 
   * @param ns
   * @param name
   * @param scan_spec
   */
  void get_cells_as_arrays(std::vector<CellAsArray> & _return, const Namespace ns, const std::string& name, const ScanSpec& scan_spec) {
    // Your implementation goes here
    printf("get_cells_as_arrays\n");
  }

  /**
   * Alternative interface returning buffer of serialized cells
   * 
   * @param ns
   * @param name
   * @param scan_spec
   */
  void get_cells_serialized(CellsSerialized& _return, const Namespace ns, const std::string& name, const ScanSpec& scan_spec) {
    // Your implementation goes here
    printf("get_cells_serialized\n");
  }

  /**
   * Create a shared mutator with specified MutateSpec.
   * Delete and recreate it if the mutator exists.
   * 
   * @param ns - namespace id
   *  
   * @param table_name - table name
   * 
   * @param mutate_spec - mutator specification
   * 
   * 
   * @param ns
   * @param table_name
   * @param mutate_spec
   */
  void shared_mutator_refresh(const Namespace ns, const std::string& table_name, const MutateSpec& mutate_spec) {
    // Your implementation goes here
    printf("shared_mutator_refresh\n");
  }

  void refresh_shared_mutator(const Namespace ns, const std::string& table_name, const MutateSpec& mutate_spec) {
    // Your implementation goes here
    printf("refresh_shared_mutator\n");
  }

  /**
   * Open a shared periodic mutator which causes cells to be written asyncronously.
   * Users beware: calling this method merely writes
   * cells to a local buffer and does not guarantee that the cells have been persisted.
   * If you want guaranteed durability, use the open_mutator+set_cells* interface instead.
   * 
   * @param ns - namespace id
   * 
   * @param table_name - table name
   * 
   * @param mutate_spec - mutator specification
   * 
   * @param cells - set of cells to be written
   * 
   * @param ns
   * @param table_name
   * @param mutate_spec
   * @param cells
   */
  void shared_mutator_set_cells(const Namespace ns, const std::string& table_name, const MutateSpec& mutate_spec, const std::vector<Cell> & cells) {
    // Your implementation goes here
    printf("shared_mutator_set_cells\n");
  }

  void offer_cells(const Namespace ns, const std::string& table_name, const MutateSpec& mutate_spec, const std::vector<Cell> & cells) {
    // Your implementation goes here
    printf("offer_cells\n");
  }

  /**
   * Alternative to offer_cell interface using array as cell
   * 
   * @param ns
   * @param table_name
   * @param mutate_spec
   * @param cells
   */
  void shared_mutator_set_cells_as_arrays(const Namespace ns, const std::string& table_name, const MutateSpec& mutate_spec, const std::vector<CellAsArray> & cells) {
    // Your implementation goes here
    printf("shared_mutator_set_cells_as_arrays\n");
  }

  void offer_cells_as_arrays(const Namespace ns, const std::string& table_name, const MutateSpec& mutate_spec, const std::vector<CellAsArray> & cells) {
    // Your implementation goes here
    printf("offer_cells_as_arrays\n");
  }

  /**
   * Open a shared periodic mutator which causes cells to be written asyncronously.
   * Users beware: calling this method merely writes
   * cells to a local buffer and does not guarantee that the cells have been persisted.
   * If you want guaranteed durability, use the open_mutator+set_cells* interface instead.
   * 
   * @param ns - namespace id
   * 
   * @param table_name - table name
   * 
   * @param mutate_spec - mutator specification
   * 
   * @param cell - cell to be written
   * 
   * @param ns
   * @param table_name
   * @param mutate_spec
   * @param cell
   */
  void shared_mutator_set_cell(const Namespace ns, const std::string& table_name, const MutateSpec& mutate_spec, const Cell& cell) {
    // Your implementation goes here
    printf("shared_mutator_set_cell\n");
  }

  void offer_cell(const Namespace ns, const std::string& table_name, const MutateSpec& mutate_spec, const Cell& cell) {
    // Your implementation goes here
    printf("offer_cell\n");
  }

  /**
   * Alternative to offer_cell interface using array as cell
   * 
   * @param ns
   * @param table_name
   * @param mutate_spec
   * @param cell
   */
  void shared_mutator_set_cell_as_array(const Namespace ns, const std::string& table_name, const MutateSpec& mutate_spec, const CellAsArray& cell) {
    // Your implementation goes here
    printf("shared_mutator_set_cell_as_array\n");
  }

  void offer_cell_as_array(const Namespace ns, const std::string& table_name, const MutateSpec& mutate_spec, const CellAsArray& cell) {
    // Your implementation goes here
    printf("offer_cell_as_array\n");
  }

  /**
   * Open a table mutator
   * 
   * @param ns - namespace id
   * 
   * @param table_name - table name
   * 
   * @param flags - mutator flags
   * 
   * @param flush_interval - auto-flush interval in milliseconds; 0 disables it.
   * 
   * @return mutator id
   * 
   * @param ns
   * @param table_name
   * @param flags
   * @param flush_interval
   */
  Mutator mutator_open(const Namespace ns, const std::string& table_name, const int32_t flags, const int32_t flush_interval) {
    // Your implementation goes here
    printf("mutator_open\n");
  }

  Mutator open_mutator(const Namespace ns, const std::string& table_name, const int32_t flags, const int32_t flush_interval) {
    // Your implementation goes here
    printf("open_mutator\n");
  }

  /**
   * Open an asynchronous table mutator
   * 
   * @param ns - namespace id
   * @param table_name - table name
   * @param future - callback object
   * @param flags - mutator flags
   * 
   * @return mutator id
   * 
   * @param ns
   * @param table_name
   * @param future
   * @param flags
   */
  MutatorAsync async_mutator_open(const Namespace ns, const std::string& table_name, const Future future, const int32_t flags) {
    // Your implementation goes here
    printf("async_mutator_open\n");
  }

  MutatorAsync open_mutator_async(const Namespace ns, const std::string& table_name, const Future future, const int32_t flags) {
    // Your implementation goes here
    printf("open_mutator_async\n");
  }

  /**
   * Close a table mutator
   * 
   * @param mutator - mutator id to close
   * 
   * @param mutator
   */
  void mutator_close(const Mutator mutator) {
    // Your implementation goes here
    printf("mutator_close\n");
  }

  void close_mutator(const Mutator mutator) {
    // Your implementation goes here
    printf("close_mutator\n");
  }

  /**
   * Cancel an asynchronous table mutator
   * 
   * @param mutator -  mutator id to cancel
   * 
   * @param mutator
   */
  void async_mutator_cancel(const MutatorAsync mutator) {
    // Your implementation goes here
    printf("async_mutator_cancel\n");
  }

  void cancel_mutator_async(const MutatorAsync mutator) {
    // Your implementation goes here
    printf("cancel_mutator_async\n");
  }

  /**
   * Close an asynchronous table mutator
   * 
   * @param mutator - mutator id to close
   * 
   * @param mutator
   */
  void async_mutator_close(const MutatorAsync mutator) {
    // Your implementation goes here
    printf("async_mutator_close\n");
  }

  void close_mutator_async(const MutatorAsync mutator) {
    // Your implementation goes here
    printf("close_mutator_async\n");
  }

  /**
   * Set a cell via mutator
   * 
   * @param mutator - mutator id
   * 
   * @param cell - the cell to set
   * 
   * @param mutator
   * @param cell
   */
  void mutator_set_cell(const Mutator mutator, const Cell& cell) {
    // Your implementation goes here
    printf("mutator_set_cell\n");
  }

  /**
   * Set a cell in the table
   * 
   * @param ns - namespace id
   * 
   * @param table_name - table name
   * 
   * @param cell - the cell to set
   * 
   * @param ns
   * @param table_name
   * @param cell
   */
  void set_cell(const Namespace ns, const std::string& table_name, const Cell& cell) {
    // Your implementation goes here
    printf("set_cell\n");
  }

  /**
   * Alternative interface using array as cell
   * 
   * @param mutator
   * @param cell
   */
  void mutator_set_cell_as_array(const Mutator mutator, const CellAsArray& cell) {
    // Your implementation goes here
    printf("mutator_set_cell_as_array\n");
  }

  /**
   * Alternative interface using array as cell
   * 
   * @param ns
   * @param table_name
   * @param cell
   */
  void set_cell_as_array(const Namespace ns, const std::string& table_name, const CellAsArray& cell) {
    // Your implementation goes here
    printf("set_cell_as_array\n");
  }

  /**
   * Put a list of cells into a table via mutator
   * 
   * @param mutator - mutator id
   * 
   * @param cells - a list of cells (a cell with no row key set is assumed
   *        to have the same row key as the previous cell)
   * 
   * @param mutator
   * @param cells
   */
  void mutator_set_cells(const Mutator mutator, const std::vector<Cell> & cells) {
    // Your implementation goes here
    printf("mutator_set_cells\n");
  }

  /**
   * Put a list of cells into a table
   * 
   * @param ns - namespace id
   * 
   * @param table_name - table name
   * 
   * @param cells - a list of cells (a cell with no row key set is assumed
   *        to have the same row key as the previous cell)
   * 
   * @param ns
   * @param table_name
   * @param cells
   */
  void set_cells(const Namespace ns, const std::string& table_name, const std::vector<Cell> & cells) {
    // Your implementation goes here
    printf("set_cells\n");
  }

  /**
   * Alternative interface using array as cell
   * 
   * @param mutator
   * @param cells
   */
  void mutator_set_cells_as_arrays(const Mutator mutator, const std::vector<CellAsArray> & cells) {
    // Your implementation goes here
    printf("mutator_set_cells_as_arrays\n");
  }

  /**
   * Alternative interface using array as cell
   * 
   * @param ns
   * @param table_name
   * @param cells
   */
  void set_cells_as_arrays(const Namespace ns, const std::string& table_name, const std::vector<CellAsArray> & cells) {
    // Your implementation goes here
    printf("set_cells_as_arrays\n");
  }

  /**
   * Alternative interface using buffer of serialized cells
   * 
   * @param mutator
   * @param cells
   * @param flush
   */
  void mutator_set_cells_serialized(const Mutator mutator, const CellsSerialized& cells, const bool flush) {
    // Your implementation goes here
    printf("mutator_set_cells_serialized\n");
  }

  /**
   * Alternative interface using buffer of serialized cells
   * 
   * @param ns
   * @param table_name
   * @param cells
   */
  void set_cells_serialized(const Namespace ns, const std::string& table_name, const CellsSerialized& cells) {
    // Your implementation goes here
    printf("set_cells_serialized\n");
  }

  /**
   * Flush mutator buffers
   * 
   * @param mutator
   */
  void mutator_flush(const Mutator mutator) {
    // Your implementation goes here
    printf("mutator_flush\n");
  }

  void flush_mutator(const Mutator mutator) {
    // Your implementation goes here
    printf("flush_mutator\n");
  }

  /**
   * Set a cell in the table using an asynchonous mutator
   * 
   * @param mutator - mutator id
   * 
   * @param cell - the cell to set
   * 
   * @param mutator
   * @param cell
   */
  void async_mutator_set_cell(const MutatorAsync mutator, const Cell& cell) {
    // Your implementation goes here
    printf("async_mutator_set_cell\n");
  }

  void set_cell_async(const MutatorAsync mutator, const Cell& cell) {
    // Your implementation goes here
    printf("set_cell_async\n");
  }

  /**
   * Alternative interface using array as cell using an asynchonous mutator
   * 
   * @param mutator
   * @param cell
   */
  void async_mutator_set_cell_as_array(const MutatorAsync mutator, const CellAsArray& cell) {
    // Your implementation goes here
    printf("async_mutator_set_cell_as_array\n");
  }

  void set_cell_as_array_async(const MutatorAsync mutator, const CellAsArray& cell) {
    // Your implementation goes here
    printf("set_cell_as_array_async\n");
  }

  /**
   * Put a list of cells into a table using asynchonous mutator
   * 
   * @param mutator - mutator id
   * 
   * @param cells - a list of cells (a cell with no row key set is assumed
   *        to have the same row key as the previous cell)
   * 
   * @param mutator
   * @param cells
   */
  void async_mutator_set_cells(const MutatorAsync mutator, const std::vector<Cell> & cells) {
    // Your implementation goes here
    printf("async_mutator_set_cells\n");
  }

  void set_cells_async(const MutatorAsync mutator, const std::vector<Cell> & cells) {
    // Your implementation goes here
    printf("set_cells_async\n");
  }

  /**
   * Alternative interface using array as cell
   * 
   * @param mutator
   * @param cells
   */
  void async_mutator_set_cells_as_arrays(const MutatorAsync mutator, const std::vector<CellAsArray> & cells) {
    // Your implementation goes here
    printf("async_mutator_set_cells_as_arrays\n");
  }

  void set_cells_as_arrays_async(const MutatorAsync mutator, const std::vector<CellAsArray> & cells) {
    // Your implementation goes here
    printf("set_cells_as_arrays_async\n");
  }

  /**
   * Alternative interface using buffer of serialized cells
   * 
   * @param mutator
   * @param cells
   * @param flush
   */
  void async_mutator_set_cells_serialized(const MutatorAsync mutator, const CellsSerialized& cells, const bool flush) {
    // Your implementation goes here
    printf("async_mutator_set_cells_serialized\n");
  }

  void set_cells_serialized_async(const MutatorAsync mutator, const CellsSerialized& cells, const bool flush) {
    // Your implementation goes here
    printf("set_cells_serialized_async\n");
  }

  /**
   * Flush mutator buffers
   * 
   * @param mutator
   */
  void async_mutator_flush(const MutatorAsync mutator) {
    // Your implementation goes here
    printf("async_mutator_flush\n");
  }

  void flush_mutator_async(const MutatorAsync mutator) {
    // Your implementation goes here
    printf("flush_mutator_async\n");
  }

  /**
   * Check if the namespace exists
   * 
   * @param ns - namespace name
   * 
   * @return true if ns exists, false ow
   * 
   * @param ns
   */
  bool namespace_exists(const std::string& ns) {
    // Your implementation goes here
    printf("namespace_exists\n");
  }

  bool exists_namespace(const std::string& ns) {
    // Your implementation goes here
    printf("exists_namespace\n");
  }

  /**
   * Check if the table exists
   * 
   * @param ns - namespace id
   * 
   * @param name - table name
   * 
   * @return true if table exists, false ow
   * 
   * @param ns
   * @param name
   */
  bool exists_table(const Namespace ns, const std::string& name) {
    // Your implementation goes here
    printf("exists_table\n");
  }

  bool table_exists(const Namespace ns, const std::string& name) {
    // Your implementation goes here
    printf("table_exists\n");
  }

  /**
   * Get the id of a table
   * 
   * @param ns - namespace id
   * 
   * @param table_name - table name
   * 
   * @return table id string
   * 
   * @param ns
   * @param table_name
   */
  void table_get_id(std::string& _return, const Namespace ns, const std::string& table_name) {
    // Your implementation goes here
    printf("table_get_id\n");
  }

  void get_table_id(std::string& _return, const Namespace ns, const std::string& table_name) {
    // Your implementation goes here
    printf("get_table_id\n");
  }

  /**
   * Get the schema of a table as a string (that can be used with create_table)
   * 
   * @param ns - namespace id
   * 
   * @param table_name - table name
   * 
   * @return schema string (in xml)
   * 
   * @param ns
   * @param table_name
   */
  void table_get_schema_str(std::string& _return, const Namespace ns, const std::string& table_name) {
    // Your implementation goes here
    printf("table_get_schema_str\n");
  }

  void get_schema_str(std::string& _return, const Namespace ns, const std::string& table_name) {
    // Your implementation goes here
    printf("get_schema_str\n");
  }

  /**
   * Get the schema of a table as a string along with column family ids
   * 
   * @param ns - namespace id
   * 
   * @param table_name - table name
   * 
   * @return schema string (in xml)
   * 
   * @param ns
   * @param table_name
   */
  void table_get_schema_str_with_ids(std::string& _return, const Namespace ns, const std::string& table_name) {
    // Your implementation goes here
    printf("table_get_schema_str_with_ids\n");
  }

  void get_schema_str_with_ids(std::string& _return, const Namespace ns, const std::string& table_name) {
    // Your implementation goes here
    printf("get_schema_str_with_ids\n");
  }

  /**
   * Get the schema of a table as a string (that can be used with create_table)
   *   
   * @param ns - namespace id
   * 
   * @param table_name - table name
   * 
   * @return schema object describing a table
   * 
   * @param ns
   * @param table_name
   */
  void table_get_schema(Schema& _return, const Namespace ns, const std::string& table_name) {
    // Your implementation goes here
    printf("table_get_schema\n");
  }

  void get_schema(Schema& _return, const Namespace ns, const std::string& table_name) {
    // Your implementation goes here
    printf("get_schema\n");
  }

  /**
   * Get a list of table names in the namespace
   * 
   * @param ns - namespace id
   * 
   * @return a list of table names
   * 
   * @param ns
   */
  void get_tables(std::vector<std::string> & _return, const Namespace ns) {
    // Your implementation goes here
    printf("get_tables\n");
  }

  /**
   * Get a list of namespaces and table names table names in the namespace
   * 
   * @param ns - namespace
   * 
   * @return a list of table names
   * 
   * @param ns
   */
  void namespace_get_listing(std::vector<NamespaceListing> & _return, const Namespace ns) {
    // Your implementation goes here
    printf("namespace_get_listing\n");
  }

  void get_listing(std::vector<NamespaceListing> & _return, const Namespace ns) {
    // Your implementation goes here
    printf("get_listing\n");
  }

  /**
   * Get a list of table splits
   * 
   * @param ns - namespace id
   * 
   * @param table_name - table name
   * 
   * @return a list of table names
   * 
   * @param ns
   * @param table_name
   */
  void table_get_splits(std::vector<TableSplit> & _return, const Namespace ns, const std::string& table_name) {
    // Your implementation goes here
    printf("table_get_splits\n");
  }

  void get_table_splits(std::vector<TableSplit> & _return, const Namespace ns, const std::string& table_name) {
    // Your implementation goes here
    printf("get_table_splits\n");
  }

  /**
   * Drop a namespace
   * 
   * @param ns - namespace name
   * 
   * @param if_exists - if true, don't barf if the table doesn't exist
   * 
   * @param ns
   * @param if_exists
   */
  void namespace_drop(const std::string& ns, const bool if_exists) {
    // Your implementation goes here
    printf("namespace_drop\n");
  }

  void drop_namespace(const std::string& ns, const bool if_exists) {
    // Your implementation goes here
    printf("drop_namespace\n");
  }

  /**
   * Rename a table
   * 
   * @param ns - namespace id
   * 
   * @param name - current table name
   * 
   * @param new_name - new table name
   * 
   * @param ns
   * @param name
   * @param new_name
   */
  void rename_table(const Namespace ns, const std::string& name, const std::string& new_name) {
    // Your implementation goes here
    printf("rename_table\n");
  }

  void table_rename(const Namespace ns, const std::string& name, const std::string& new_name) {
    // Your implementation goes here
    printf("table_rename\n");
  }

  /**
   * Drop a table
   * 
   * @param ns - namespace id
   * 
   * @param name - table name
   * 
   * @param if_exists - if true, don't barf if the table doesn't exist
   * 
   * @param ns
   * @param name
   * @param if_exists
   */
  void drop_table(const Namespace ns, const std::string& name, const bool if_exists) {
    // Your implementation goes here
    printf("drop_table\n");
  }

  void table_drop(const Namespace ns, const std::string& name, const bool if_exists) {
    // Your implementation goes here
    printf("table_drop\n");
  }

  /**
   * Generate a GUID
   * 
   * GUIDs are globally unique. The generated string is 36 bytes long and
   * has a format similar to "9cf7da31-307a-4bef-b65e-19fb05aa57d8".
   */
  void generate_guid(std::string& _return) {
    // Your implementation goes here
    printf("generate_guid\n");
  }

  /**
   * Inserts a unique value into a table
   * 
   * This function inserts a unique value into a table. The table must be
   * created with TIME_ORDER DESC, MAX_VERSIONS 1 (although the latter is
   * optional).
   * 
   * If the value is empty then a new GUID will be assigned
   * (using @a generate_guid).
   * 
   * @param ns - namespace id
   * @param table_name - table name
   * @param key - the Key of the value
   * @param value - the unique value. Can be empty; in this case a new
   *    guid will be generated internally
   * 
   * @return the inserted unique value (which is identical to the @a value
   *    parameter or a new guid, if value is empty)
   * 
   * @param ns
   * @param table_name
   * @param key
   * @param value
   */
  void create_cell_unique(std::string& _return, const Namespace ns, const std::string& table_name, const Key& key, const std::string& value) {
    // Your implementation goes here
    printf("create_cell_unique\n");
  }

  /**
   * Retrieves a descriptive error string from an error code
   * 
   * @param error_code - the numeric error code
   * 
   * @return the descriptive string, or "ERROR NOT REGISTERED" if the error
   *    code is unknown
   * 
   * @param error_code
   */
  void error_get_text(std::string& _return, const int32_t error_code) {
    // Your implementation goes here
    printf("error_get_text\n");
  }

  /**
   * Status check.
   * @return Status information
   */
  void status(Status& _return) {
    // Your implementation goes here
    printf("status\n");
  }

  /**
   * Shutdown broker.
   */
  void shutdown() {
    // Your implementation goes here
    printf("shutdown\n");
  }

};

int main(int argc, char **argv) {
  int port = 9090;
  shared_ptr<ClientServiceHandler> handler(new ClientServiceHandler());
  shared_ptr<TProcessor> processor(new ClientServiceProcessor(handler));
  shared_ptr<TServerTransport> serverTransport(new TServerSocket(port));
  shared_ptr<TTransportFactory> transportFactory(new TBufferedTransportFactory());
  shared_ptr<TProtocolFactory> protocolFactory(new TBinaryProtocolFactory());

  TSimpleServer server(processor, serverTransport, transportFactory, protocolFactory);
  server.serve();
  return 0;
}

