<?php
namespace Hypertable_ThriftGen;
/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
use Thrift\Base\TBase;
use Thrift\Type\TType;
use Thrift\Type\TMessageType;
use Thrift\Exception\TException;
use Thrift\Exception\TProtocolException;
use Thrift\Protocol\TProtocol;
use Thrift\Protocol\TBinaryProtocolAccelerated;
use Thrift\Exception\TApplicationException;


/**
 * The client service mimics the C++ client API, with table, scanner and
 * mutator interface flattened.
 */
interface ClientServiceIf {
  /**
   * Create a namespace
   * 
   * @param ns - namespace name
   * 
   * @param string $ns
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function namespace_create($ns);
  /**
   * @param string $ns
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function create_namespace($ns);
  /**
   * Create a table
   * 
   * @param ns - namespace id
   * @param table_name - table name
   * @param schema - schema of the table
   * 
   * @param int $ns
   * @param string $table_name
   * @param \Hypertable_ThriftGen\Schema $schema
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function table_create($ns, $table_name, \Hypertable_ThriftGen\Schema $schema);
  /**
   * Alter a table
   * 
   * @param ns - namespace id
   * @param table_name - table name
   * @param schema - schema of the table
   * 
   * @param int $ns
   * @param string $table_name
   * @param \Hypertable_ThriftGen\Schema $schema
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function table_alter($ns, $table_name, \Hypertable_ThriftGen\Schema $schema);
  /**
   * Refreshes the cached table information
   * 
   * @param ns - namespace
   * @param table_name - name of the table
   * 
   * @param int $ns
   * @param string $table_name
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function refresh_table($ns, $table_name);
  /**
   * Open a namespace
   * 
   * @param ns - namespace
   * @return value is guaranteed to be non-zero and unique
   * 
   * @param string $ns
   * @return int Opaque ID for a Namespace
   * 
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function namespace_open($ns);
  /**
   * @param string $ns
   * @return int Opaque ID for a Namespace
   * 
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function open_namespace($ns);
  /**
   * Close a namespace
   * 
   * @param ns - namespace
   * 
   * @param int $ns
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function namespace_close($ns);
  /**
   * @param int $ns
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function close_namespace($ns);
  /**
   * Open a future object
   * @param capacity - Amount of result data the future object can enqueue without blocking threads
   * 
   * @param int $capacity
   * @return int Opaque ID for a Future object
   * 
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function future_open($capacity);
  /**
   * @param int $capacity
   * @return int Opaque ID for a Future object
   * 
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function open_future($capacity);
  /**
   * Cancel tasks outstanding in a future object
   * @param ff - Future object
   * 
   * @param int $ff
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function future_cancel($ff);
  /**
   * @param int $ff
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function cancel_future($ff);
  /**
   * Fetch asynchronous results
   * @param ff - Future object which has the asynchronous results
   * @return - result from async scanner/mutator
   * 
   * @param int $ff
   * @param int $timeout_millis
   * @return \Hypertable_ThriftGen\Result Specifies a result object for asynchronous requests.
   * TODO: add support for update results
   * 
   * <dl>
   *   <dt>is_empty</dt>
   *   <dd>Indicates whether this object contains a result or not</dd>
   * 
   *   <dt>id</dt>
   *   <dd>Scanner/mutator id for which these results pertain to</dd>
   *   
   *   <dt>is_scan</dt>
   *   <dd>Indicates whether these are scan results or update results</dd>
   *   
   *   <dt>is_error</dt>
   *   <dd>Indicates whether the async request was successful or not</dd>
   *   
   *   <dt>error</dt>
   *   <dd>Error code</dd>
   * 
   *   <dt>error_msg</dt>
   *   <dd>Error message</dd>
   * 
   *   <dt>cells</dt>
   *   <dd>Cells returned by asynchronous scanner</dd>
   * </dl>
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function future_get_result($ff, $timeout_millis);
  /**
   * @param int $ff
   * @param int $timeout_millis
   * @return \Hypertable_ThriftGen\Result Specifies a result object for asynchronous requests.
   * TODO: add support for update results
   * 
   * <dl>
   *   <dt>is_empty</dt>
   *   <dd>Indicates whether this object contains a result or not</dd>
   * 
   *   <dt>id</dt>
   *   <dd>Scanner/mutator id for which these results pertain to</dd>
   *   
   *   <dt>is_scan</dt>
   *   <dd>Indicates whether these are scan results or update results</dd>
   *   
   *   <dt>is_error</dt>
   *   <dd>Indicates whether the async request was successful or not</dd>
   *   
   *   <dt>error</dt>
   *   <dd>Error code</dd>
   * 
   *   <dt>error_msg</dt>
   *   <dd>Error message</dd>
   * 
   *   <dt>cells</dt>
   *   <dd>Cells returned by asynchronous scanner</dd>
   * </dl>
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function get_future_result($ff, $timeout_millis);
  /**
   * Fetch asynchronous results
   * @param ff - Future object which has the asynchronous results
   * @return - result from async scanner/mutator
   * 
   * @param int $ff
   * @param int $timeout_millis
   * @return \Hypertable_ThriftGen\ResultAsArrays Specifies a result object for asynchronous requests.
   * TODO: add support for update results
   * 
   * <dl>
   *   <dt>is_empty</dt>
   *   <dd>Indicates whether this object contains a result or not</dd>
   * 
   *   <dt>id</dt>
   *   <dd>Scanner/mutator id for which these results pertain to</dd>
   *   
   *   <dt>is_scan</dt>
   *   <dd>Indicates whether these are scan results or update results</dd>
   *   
   *   <dt>is_error</dt>
   *   <dd>Indicates whether the async request was successful or not</dd>
   *   
   *   <dt>error</dt>
   *   <dd>Error code</dd>
   * 
   *   <dt>error_msg</dt>
   *   <dd>Error message</dd>
   * 
   *   <dt>cells</dt>
   *   <dd>Cells returned by asynchronous scanner</dd>
   * </dl>
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function future_get_result_as_arrays($ff, $timeout_millis);
  /**
   * @param int $ff
   * @param int $timeout_millis
   * @return \Hypertable_ThriftGen\ResultAsArrays Specifies a result object for asynchronous requests.
   * TODO: add support for update results
   * 
   * <dl>
   *   <dt>is_empty</dt>
   *   <dd>Indicates whether this object contains a result or not</dd>
   * 
   *   <dt>id</dt>
   *   <dd>Scanner/mutator id for which these results pertain to</dd>
   *   
   *   <dt>is_scan</dt>
   *   <dd>Indicates whether these are scan results or update results</dd>
   *   
   *   <dt>is_error</dt>
   *   <dd>Indicates whether the async request was successful or not</dd>
   *   
   *   <dt>error</dt>
   *   <dd>Error code</dd>
   * 
   *   <dt>error_msg</dt>
   *   <dd>Error message</dd>
   * 
   *   <dt>cells</dt>
   *   <dd>Cells returned by asynchronous scanner</dd>
   * </dl>
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function get_future_result_as_arrays($ff, $timeout_millis);
  /**
   * Fetch asynchronous results
   * @param ff - Future object which has the asynchronous results
   * @return - result from async scanner/mutator
   * 
   * @param int $ff
   * @param int $timeout_millis
   * @return \Hypertable_ThriftGen\ResultSerialized Specifies a serialized result object for asynchronous requests.
   * TODO: add support for update results
   * 
   * <dl>
   *   <dt>is_empty</dt>
   *   <dd>Indicates whether this object contains a result or not</dd>
   * 
   *   <dt>id</dt>
   *   <dd>Scanner/mutator id for which these results pertain to</dd>
   *   
   *   <dt>is_scan</dt>
   *   <dd>Indicates whether these are scan results or update results</dd>
   *   
   *   <dt>is_error</dt>
   *   <dd>Indicates whether the async request was successful or not</dd>
   *   
   *   <dt>error</dt>
   *   <dd>Error code</dd>
   * 
   *   <dt>error_msg</dt>
   *   <dd>Error message</dd>
   * 
   *   <dt>cells</dt>
   *   <dd>Cells returned by asynchronous scanner</dd>
   * </dl>
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function future_get_result_serialized($ff, $timeout_millis);
  /**
   * @param int $ff
   * @param int $timeout_millis
   * @return \Hypertable_ThriftGen\ResultSerialized Specifies a serialized result object for asynchronous requests.
   * TODO: add support for update results
   * 
   * <dl>
   *   <dt>is_empty</dt>
   *   <dd>Indicates whether this object contains a result or not</dd>
   * 
   *   <dt>id</dt>
   *   <dd>Scanner/mutator id for which these results pertain to</dd>
   *   
   *   <dt>is_scan</dt>
   *   <dd>Indicates whether these are scan results or update results</dd>
   *   
   *   <dt>is_error</dt>
   *   <dd>Indicates whether the async request was successful or not</dd>
   *   
   *   <dt>error</dt>
   *   <dd>Error code</dd>
   * 
   *   <dt>error_msg</dt>
   *   <dd>Error message</dd>
   * 
   *   <dt>cells</dt>
   *   <dd>Cells returned by asynchronous scanner</dd>
   * </dl>
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function get_future_result_serialized($ff, $timeout_millis);
  /**
   * Check if future object's queue is empty
   * 
   * @param int $ff
   * @return bool
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function future_is_empty($ff);
  /**
   * Check if future object's queue is full
   * 
   * @param int $ff
   * @return bool
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function future_is_full($ff);
  /**
   * Check if future object has been cancelled
   * 
   * @param int $ff
   * @return bool
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function future_is_cancelled($ff);
  /**
   * Check if future object has outstanding operations
   * 
   * @param int $ff
   * @return bool
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function future_has_outstanding($ff);
  /**
   * Close a future object
   * @param ff - the future object to be closed
   * 
   * @param int $ff
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function future_close($ff);
  /**
   * @param int $ff
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function close_future($ff);
  /**
   * Open a table scanner
   * @param ns - namespace id
   * @param table_name - table name
   * @param scan_spec - scan specification
   * 
   * @param int $ns
   * @param string $table_name
   * @param \Hypertable_ThriftGen\ScanSpec $scan_spec
   * @return int Opaque ID for a table scanner
   * 
   * A scanner is recommended for returning large amount of data, say a full
   * table dump.
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function scanner_open($ns, $table_name, \Hypertable_ThriftGen\ScanSpec $scan_spec);
  /**
   * @param int $ns
   * @param string $table_name
   * @param \Hypertable_ThriftGen\ScanSpec $scan_spec
   * @return int Opaque ID for a table scanner
   * 
   * A scanner is recommended for returning large amount of data, say a full
   * table dump.
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function open_scanner($ns, $table_name, \Hypertable_ThriftGen\ScanSpec $scan_spec);
  /**
   * Open an asynchronous table scanner
   * @param ns - namespace id
   * @param table_name - table name
   * @param future - callback object
   * @param scan_spec - scan specification
   * 
   * @param int $ns
   * @param string $table_name
   * @param int $future
   * @param \Hypertable_ThriftGen\ScanSpec $scan_spec
   * @return int Opaque ID for a asynchronous table scanner
   * 
   * A scanner is recommended for returning large amount of data, say a full
   * table dump.
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function async_scanner_open($ns, $table_name, $future, \Hypertable_ThriftGen\ScanSpec $scan_spec);
  /**
   * @param int $ns
   * @param string $table_name
   * @param int $future
   * @param \Hypertable_ThriftGen\ScanSpec $scan_spec
   * @return int Opaque ID for a asynchronous table scanner
   * 
   * A scanner is recommended for returning large amount of data, say a full
   * table dump.
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function open_scanner_async($ns, $table_name, $future, \Hypertable_ThriftGen\ScanSpec $scan_spec);
  /**
   * Close a table scanner
   * 
   * @param scanner - scanner id to close
   * 
   * @param int $scanner
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function scanner_close($scanner);
  /**
   * @param int $scanner
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function close_scanner($scanner);
  /**
   * Cancel a table scanner
   * 
   * @param scanner - scanner id to close
   * 
   * @param int $scanner
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function async_scanner_cancel($scanner);
  /**
   * @param int $scanner
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function cancel_scanner_async($scanner);
  /**
   * Close a table scanner
   * 
   * @param scanner - scanner id to close
   * 
   * @param int $scanner
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function async_scanner_close($scanner);
  /**
   * @param int $scanner
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function close_scanner_async($scanner);
  /**
   * Iterate over cells of a scanner
   * 
   * @param scanner - scanner id
   * 
   * @param int $scanner
   * @return \Hypertable_ThriftGen\Cell[]
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function scanner_get_cells($scanner);
  /**
   * @param int $scanner
   * @return \Hypertable_ThriftGen\Cell[]
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function next_cells($scanner);
  /**
   * @param int $scanner
   * @return string[][]
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function scanner_get_cells_as_arrays($scanner);
  /**
   * @param int $scanner
   * @return string[][]
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function next_cells_as_arrays($scanner);
  /**
   * Alternative interface returning buffer of serialized cells
   * 
   * @param int $scanner
   * @return string Binary buffer holding serialized sequence of cells
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function scanner_get_cells_serialized($scanner);
  /**
   * @param int $scanner
   * @return string Binary buffer holding serialized sequence of cells
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function next_cells_serialized($scanner);
  /**
   * Iterate over rows of a scanner
   * 
   * @param scanner - scanner id
   * 
   * @param int $scanner
   * @return \Hypertable_ThriftGen\Cell[]
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function scanner_get_row($scanner);
  /**
   * @param int $scanner
   * @return \Hypertable_ThriftGen\Cell[]
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function next_row($scanner);
  /**
   * Alternative interface using array as cell
   * 
   * @param int $scanner
   * @return string[][]
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function scanner_get_row_as_arrays($scanner);
  /**
   * @param int $scanner
   * @return string[][]
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function next_row_as_arrays($scanner);
  /**
   * Alternate interface returning a buffer of serialized cells for iterating by row
   * for a given scanner
   * 
   * @param scanner - scanner id
   * 
   * @param int $scanner
   * @return string Binary buffer holding serialized sequence of cells
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function scanner_get_row_serialized($scanner);
  /**
   * @param int $scanner
   * @return string Binary buffer holding serialized sequence of cells
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function next_row_serialized($scanner);
  /**
   * Get a row (convenience method for random access a row)
   * 
   * @param ns - namespace id
   * 
   * @param table_name - table name
   * 
   * @param row - row key
   * 
   * @return a list of cells (with row_keys unset)
   * 
   * @param int $ns
   * @param string $table_name
   * @param string $row
   * @return \Hypertable_ThriftGen\Cell[]
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function get_row($ns, $table_name, $row);
  /**
   * Alternative interface using array as cell
   * 
   * @param int $ns
   * @param string $name
   * @param string $row
   * @return string[][]
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function get_row_as_arrays($ns, $name, $row);
  /**
   * Alternative interface returning buffer of serialized cells
   * 
   * @param int $ns
   * @param string $table_name
   * @param string $row
   * @return string Binary buffer holding serialized sequence of cells
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function get_row_serialized($ns, $table_name, $row);
  /**
   * Get a cell (convenience method for random access a cell)
   * 
   * @param ns - namespace id
   * 
   * @param table_name - table name
   * 
   * @param row - row key
   * 
   * @param column - column name
   * 
   * @return value (byte sequence)
   * 
   * @param int $ns
   * @param string $table_name
   * @param string $row
   * @param string $column
   * @return string Value for table cell
   * 
   * Use binary instead of string to generate efficient type for Java.
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function get_cell($ns, $table_name, $row, $column);
  /**
   * Get cells (convenience method for access small amount of cells)
   * 
   * @param ns - namespace id
   *  
   * @param table_name - table name
   * 
   * @param scan_spec - scan specification
   * 
   * @return a list of cells (a cell with no row key set is assumed to have
   *         the same row key as the previous cell)
   * 
   * @param int $ns
   * @param string $table_name
   * @param \Hypertable_ThriftGen\ScanSpec $scan_spec
   * @return \Hypertable_ThriftGen\Cell[]
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function get_cells($ns, $table_name, \Hypertable_ThriftGen\ScanSpec $scan_spec);
  /**
   * Alternative interface using array as cell
   * 
   * @param int $ns
   * @param string $name
   * @param \Hypertable_ThriftGen\ScanSpec $scan_spec
   * @return string[][]
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function get_cells_as_arrays($ns, $name, \Hypertable_ThriftGen\ScanSpec $scan_spec);
  /**
   * Alternative interface returning buffer of serialized cells
   * 
   * @param int $ns
   * @param string $name
   * @param \Hypertable_ThriftGen\ScanSpec $scan_spec
   * @return string Binary buffer holding serialized sequence of cells
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function get_cells_serialized($ns, $name, \Hypertable_ThriftGen\ScanSpec $scan_spec);
  /**
   * Create a shared mutator with specified MutateSpec.
   * Delete and recreate it if the mutator exists.
   * 
   * @param ns - namespace id
   *  
   * @param table_name - table name
   * 
   * @param mutate_spec - mutator specification
   * 
   * 
   * @param int $ns
   * @param string $table_name
   * @param \Hypertable_ThriftGen\MutateSpec $mutate_spec
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function shared_mutator_refresh($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec);
  /**
   * @param int $ns
   * @param string $table_name
   * @param \Hypertable_ThriftGen\MutateSpec $mutate_spec
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function refresh_shared_mutator($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec);
  /**
   * Open a shared periodic mutator which causes cells to be written asyncronously.
   * Users beware: calling this method merely writes
   * cells to a local buffer and does not guarantee that the cells have been persisted.
   * If you want guaranteed durability, use the open_mutator+set_cells* interface instead.
   * 
   * @param ns - namespace id
   * 
   * @param table_name - table name
   * 
   * @param mutate_spec - mutator specification
   * 
   * @param cells - set of cells to be written
   * 
   * @param int $ns
   * @param string $table_name
   * @param \Hypertable_ThriftGen\MutateSpec $mutate_spec
   * @param \Hypertable_ThriftGen\Cell[] $cells
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function shared_mutator_set_cells($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec, array $cells);
  /**
   * @param int $ns
   * @param string $table_name
   * @param \Hypertable_ThriftGen\MutateSpec $mutate_spec
   * @param \Hypertable_ThriftGen\Cell[] $cells
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function offer_cells($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec, array $cells);
  /**
   * Alternative to offer_cell interface using array as cell
   * 
   * @param int $ns
   * @param string $table_name
   * @param \Hypertable_ThriftGen\MutateSpec $mutate_spec
   * @param string[][] $cells
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function shared_mutator_set_cells_as_arrays($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec, array $cells);
  /**
   * @param int $ns
   * @param string $table_name
   * @param \Hypertable_ThriftGen\MutateSpec $mutate_spec
   * @param string[][] $cells
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function offer_cells_as_arrays($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec, array $cells);
  /**
   * Open a shared periodic mutator which causes cells to be written asyncronously.
   * Users beware: calling this method merely writes
   * cells to a local buffer and does not guarantee that the cells have been persisted.
   * If you want guaranteed durability, use the open_mutator+set_cells* interface instead.
   * 
   * @param ns - namespace id
   * 
   * @param table_name - table name
   * 
   * @param mutate_spec - mutator specification
   * 
   * @param cell - cell to be written
   * 
   * @param int $ns
   * @param string $table_name
   * @param \Hypertable_ThriftGen\MutateSpec $mutate_spec
   * @param \Hypertable_ThriftGen\Cell $cell
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function shared_mutator_set_cell($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec, \Hypertable_ThriftGen\Cell $cell);
  /**
   * @param int $ns
   * @param string $table_name
   * @param \Hypertable_ThriftGen\MutateSpec $mutate_spec
   * @param \Hypertable_ThriftGen\Cell $cell
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function offer_cell($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec, \Hypertable_ThriftGen\Cell $cell);
  /**
   * Alternative to offer_cell interface using array as cell
   * 
   * @param int $ns
   * @param string $table_name
   * @param \Hypertable_ThriftGen\MutateSpec $mutate_spec
   * @param string[] $cell
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function shared_mutator_set_cell_as_array($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec, $cell);
  /**
   * @param int $ns
   * @param string $table_name
   * @param \Hypertable_ThriftGen\MutateSpec $mutate_spec
   * @param string[] $cell
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function offer_cell_as_array($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec, $cell);
  /**
   * Open a table mutator
   * 
   * @param ns - namespace id
   * 
   * @param table_name - table name
   * 
   * @param flags - mutator flags
   * 
   * @param flush_interval - auto-flush interval in milliseconds; 0 disables it.
   * 
   * @return mutator id
   * 
   * @param int $ns
   * @param string $table_name
   * @param int $flags
   * @param int $flush_interval
   * @return int Opaque ID for a table mutator
   * 
   * A mutator is recommended for injecting large amount of data (across
   * many calls to mutator methods)
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function mutator_open($ns, $table_name, $flags, $flush_interval);
  /**
   * @param int $ns
   * @param string $table_name
   * @param int $flags
   * @param int $flush_interval
   * @return int Opaque ID for a table mutator
   * 
   * A mutator is recommended for injecting large amount of data (across
   * many calls to mutator methods)
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function open_mutator($ns, $table_name, $flags, $flush_interval);
  /**
   * Open an asynchronous table mutator
   * 
   * @param ns - namespace id
   * @param table_name - table name
   * @param future - callback object
   * @param flags - mutator flags
   * 
   * @return mutator id
   * 
   * @param int $ns
   * @param string $table_name
   * @param int $future
   * @param int $flags
   * @return int Opaque ID for a asynchronous table mutator
   * 
   * A mutator is recommended for injecting large amount of data (across
   * many calls to mutator methods)
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function async_mutator_open($ns, $table_name, $future, $flags);
  /**
   * @param int $ns
   * @param string $table_name
   * @param int $future
   * @param int $flags
   * @return int Opaque ID for a asynchronous table mutator
   * 
   * A mutator is recommended for injecting large amount of data (across
   * many calls to mutator methods)
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function open_mutator_async($ns, $table_name, $future, $flags);
  /**
   * Close a table mutator
   * 
   * @param mutator - mutator id to close
   * 
   * @param int $mutator
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function mutator_close($mutator);
  /**
   * @param int $mutator
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function close_mutator($mutator);
  /**
   * Cancel an asynchronous table mutator
   * 
   * @param mutator -  mutator id to cancel
   * 
   * @param int $mutator
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function async_mutator_cancel($mutator);
  /**
   * @param int $mutator
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function cancel_mutator_async($mutator);
  /**
   * Close an asynchronous table mutator
   * 
   * @param mutator - mutator id to close
   * 
   * @param int $mutator
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function async_mutator_close($mutator);
  /**
   * @param int $mutator
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function close_mutator_async($mutator);
  /**
   * Set a cell via mutator
   * 
   * @param mutator - mutator id
   * 
   * @param cell - the cell to set
   * 
   * @param int $mutator
   * @param \Hypertable_ThriftGen\Cell $cell
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function mutator_set_cell($mutator, \Hypertable_ThriftGen\Cell $cell);
  /**
   * Set a cell in the table
   * 
   * @param ns - namespace id
   * 
   * @param table_name - table name
   * 
   * @param cell - the cell to set
   * 
   * @param int $ns
   * @param string $table_name
   * @param \Hypertable_ThriftGen\Cell $cell
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function set_cell($ns, $table_name, \Hypertable_ThriftGen\Cell $cell);
  /**
   * Alternative interface using array as cell
   * 
   * @param int $mutator
   * @param string[] $cell
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function mutator_set_cell_as_array($mutator, $cell);
  /**
   * Alternative interface using array as cell
   * 
   * @param int $ns
   * @param string $table_name
   * @param string[] $cell
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function set_cell_as_array($ns, $table_name, $cell);
  /**
   * Put a list of cells into a table via mutator
   * 
   * @param mutator - mutator id
   * 
   * @param cells - a list of cells (a cell with no row key set is assumed
   *        to have the same row key as the previous cell)
   * 
   * @param int $mutator
   * @param \Hypertable_ThriftGen\Cell[] $cells
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function mutator_set_cells($mutator, array $cells);
  /**
   * Put a list of cells into a table
   * 
   * @param ns - namespace id
   * 
   * @param table_name - table name
   * 
   * @param cells - a list of cells (a cell with no row key set is assumed
   *        to have the same row key as the previous cell)
   * 
   * @param int $ns
   * @param string $table_name
   * @param \Hypertable_ThriftGen\Cell[] $cells
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function set_cells($ns, $table_name, array $cells);
  /**
   * Alternative interface using array as cell
   * 
   * @param int $mutator
   * @param string[][] $cells
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function mutator_set_cells_as_arrays($mutator, array $cells);
  /**
   * Alternative interface using array as cell
   * 
   * @param int $ns
   * @param string $table_name
   * @param string[][] $cells
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function set_cells_as_arrays($ns, $table_name, array $cells);
  /**
   * Alternative interface using buffer of serialized cells
   * 
   * @param int $mutator
   * @param string $cells
   * @param bool $flush
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function mutator_set_cells_serialized($mutator, $cells, $flush);
  /**
   * Alternative interface using buffer of serialized cells
   * 
   * @param int $ns
   * @param string $table_name
   * @param string $cells
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function set_cells_serialized($ns, $table_name, $cells);
  /**
   * Flush mutator buffers
   * 
   * @param int $mutator
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function mutator_flush($mutator);
  /**
   * @param int $mutator
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function flush_mutator($mutator);
  /**
   * Set a cell in the table using an asynchonous mutator
   * 
   * @param mutator - mutator id
   * 
   * @param cell - the cell to set
   * 
   * @param int $mutator
   * @param \Hypertable_ThriftGen\Cell $cell
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function async_mutator_set_cell($mutator, \Hypertable_ThriftGen\Cell $cell);
  /**
   * @param int $mutator
   * @param \Hypertable_ThriftGen\Cell $cell
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function set_cell_async($mutator, \Hypertable_ThriftGen\Cell $cell);
  /**
   * Alternative interface using array as cell using an asynchonous mutator
   * 
   * @param int $mutator
   * @param string[] $cell
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function async_mutator_set_cell_as_array($mutator, $cell);
  /**
   * @param int $mutator
   * @param string[] $cell
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function set_cell_as_array_async($mutator, $cell);
  /**
   * Put a list of cells into a table using asynchonous mutator
   * 
   * @param mutator - mutator id
   * 
   * @param cells - a list of cells (a cell with no row key set is assumed
   *        to have the same row key as the previous cell)
   * 
   * @param int $mutator
   * @param \Hypertable_ThriftGen\Cell[] $cells
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function async_mutator_set_cells($mutator, array $cells);
  /**
   * @param int $mutator
   * @param \Hypertable_ThriftGen\Cell[] $cells
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function set_cells_async($mutator, array $cells);
  /**
   * Alternative interface using array as cell
   * 
   * @param int $mutator
   * @param string[][] $cells
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function async_mutator_set_cells_as_arrays($mutator, array $cells);
  /**
   * @param int $mutator
   * @param string[][] $cells
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function set_cells_as_arrays_async($mutator, array $cells);
  /**
   * Alternative interface using buffer of serialized cells
   * 
   * @param int $mutator
   * @param string $cells
   * @param bool $flush
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function async_mutator_set_cells_serialized($mutator, $cells, $flush);
  /**
   * @param int $mutator
   * @param string $cells
   * @param bool $flush
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function set_cells_serialized_async($mutator, $cells, $flush);
  /**
   * Flush mutator buffers
   * 
   * @param int $mutator
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function async_mutator_flush($mutator);
  /**
   * @param int $mutator
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function flush_mutator_async($mutator);
  /**
   * Check if the namespace exists
   * 
   * @param ns - namespace name
   * 
   * @return true if ns exists, false ow
   * 
   * @param string $ns
   * @return bool
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function namespace_exists($ns);
  /**
   * @param string $ns
   * @return bool
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function exists_namespace($ns);
  /**
   * Check if the table exists
   * 
   * @param ns - namespace id
   * 
   * @param name - table name
   * 
   * @return true if table exists, false ow
   * 
   * @param int $ns
   * @param string $name
   * @return bool
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function exists_table($ns, $name);
  /**
   * @param int $ns
   * @param string $name
   * @return bool
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function table_exists($ns, $name);
  /**
   * Get the id of a table
   * 
   * @param ns - namespace id
   * 
   * @param table_name - table name
   * 
   * @return table id string
   * 
   * @param int $ns
   * @param string $table_name
   * @return string
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function table_get_id($ns, $table_name);
  /**
   * @param int $ns
   * @param string $table_name
   * @return string
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function get_table_id($ns, $table_name);
  /**
   * Get the schema of a table as a string (that can be used with create_table)
   * 
   * @param ns - namespace id
   * 
   * @param table_name - table name
   * 
   * @return schema string (in xml)
   * 
   * @param int $ns
   * @param string $table_name
   * @return string
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function table_get_schema_str($ns, $table_name);
  /**
   * @param int $ns
   * @param string $table_name
   * @return string
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function get_schema_str($ns, $table_name);
  /**
   * Get the schema of a table as a string along with column family ids
   * 
   * @param ns - namespace id
   * 
   * @param table_name - table name
   * 
   * @return schema string (in xml)
   * 
   * @param int $ns
   * @param string $table_name
   * @return string
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function table_get_schema_str_with_ids($ns, $table_name);
  /**
   * @param int $ns
   * @param string $table_name
   * @return string
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function get_schema_str_with_ids($ns, $table_name);
  /**
   * Get the schema of a table as a string (that can be used with create_table)
   *   
   * @param ns - namespace id
   * 
   * @param table_name - table name
   * 
   * @return schema object describing a table
   * 
   * @param int $ns
   * @param string $table_name
   * @return \Hypertable_ThriftGen\Schema Describes a schema.
   * <dl>
   *   <dt>access_groups</dt>
   *   <dd>Map of access groups</dd>
   * 
   *   <dt>column_families</dt>
   *   <dd>Map of column families</dd>
   * </dl>
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function table_get_schema($ns, $table_name);
  /**
   * @param int $ns
   * @param string $table_name
   * @return \Hypertable_ThriftGen\Schema Describes a schema.
   * <dl>
   *   <dt>access_groups</dt>
   *   <dd>Map of access groups</dd>
   * 
   *   <dt>column_families</dt>
   *   <dd>Map of column families</dd>
   * </dl>
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function get_schema($ns, $table_name);
  /**
   * Get a list of table names in the namespace
   * 
   * @param ns - namespace id
   * 
   * @return a list of table names
   * 
   * @param int $ns
   * @return string[]
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function get_tables($ns);
  /**
   * Get a list of namespaces and table names table names in the namespace
   * 
   * @param ns - namespace
   * 
   * @return a list of table names
   * 
   * @param int $ns
   * @return \Hypertable_ThriftGen\NamespaceListing[]
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function namespace_get_listing($ns);
  /**
   * @param int $ns
   * @return \Hypertable_ThriftGen\NamespaceListing[]
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function get_listing($ns);
  /**
   * Get a list of table splits
   * 
   * @param ns - namespace id
   * 
   * @param table_name - table name
   * 
   * @return a list of table names
   * 
   * @param int $ns
   * @param string $table_name
   * @return \Hypertable_ThriftGen\TableSplit[]
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function table_get_splits($ns, $table_name);
  /**
   * @param int $ns
   * @param string $table_name
   * @return \Hypertable_ThriftGen\TableSplit[]
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function get_table_splits($ns, $table_name);
  /**
   * Drop a namespace
   * 
   * @param ns - namespace name
   * 
   * @param if_exists - if true, don't barf if the table doesn't exist
   * 
   * @param string $ns
   * @param bool $if_exists
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function namespace_drop($ns, $if_exists);
  /**
   * @param string $ns
   * @param bool $if_exists
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function drop_namespace($ns, $if_exists);
  /**
   * Rename a table
   * 
   * @param ns - namespace id
   * 
   * @param name - current table name
   * 
   * @param new_name - new table name
   * 
   * @param int $ns
   * @param string $name
   * @param string $new_name
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function rename_table($ns, $name, $new_name);
  /**
   * @param int $ns
   * @param string $name
   * @param string $new_name
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function table_rename($ns, $name, $new_name);
  /**
   * Drop a table
   * 
   * @param ns - namespace id
   * 
   * @param name - table name
   * 
   * @param if_exists - if true, don't barf if the table doesn't exist
   * 
   * @param int $ns
   * @param string $name
   * @param bool $if_exists
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function drop_table($ns, $name, $if_exists);
  /**
   * @param int $ns
   * @param string $name
   * @param bool $if_exists
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function table_drop($ns, $name, $if_exists);
  /**
   * Generate a GUID
   * 
   * GUIDs are globally unique. The generated string is 36 bytes long and
   * has a format similar to "9cf7da31-307a-4bef-b65e-19fb05aa57d8".
   * 
   * @return string
   */
  public function generate_guid();
  /**
   * Inserts a unique value into a table
   * 
   * This function inserts a unique value into a table. The table must be
   * created with TIME_ORDER DESC, MAX_VERSIONS 1 (although the latter is
   * optional).
   * 
   * If the value is empty then a new GUID will be assigned
   * (using @a generate_guid).
   * 
   * @param ns - namespace id
   * @param table_name - table name
   * @param key - the Key of the value
   * @param value - the unique value. Can be empty; in this case a new
   *    guid will be generated internally
   * 
   * @return the inserted unique value (which is identical to the @a value
   *    parameter or a new guid, if value is empty)
   * 
   * @param int $ns
   * @param string $table_name
   * @param \Hypertable_ThriftGen\Key $key
   * @param string $value
   * @return string
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function create_cell_unique($ns, $table_name, \Hypertable_ThriftGen\Key $key, $value);
  /**
   * Retrieves a descriptive error string from an error code
   * 
   * @param error_code - the numeric error code
   * 
   * @return the descriptive string, or "ERROR NOT REGISTERED" if the error
   *    code is unknown
   * 
   * @param int $error_code
   * @return string
   */
  public function error_get_text($error_code);
  /**
   * Status check.
   * @return Status information
   * 
   * @return \Hypertable_ThriftGen\Status Status information.
   * 
   * <dl>
   *   <dt>code</dt>
   *   <dd>Status code</dd>
   * 
   *   <dt>text</dt>
   *   <dd>Status text</dd>
   * </dl>
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function status();
  /**
   * Shutdown broker.
   * 
   * @throws \Hypertable_ThriftGen\ClientException
   */
  public function shutdown();
}

class ClientServiceClient implements \Hypertable_ThriftGen\ClientServiceIf {
  protected $input_ = null;
  protected $output_ = null;

  protected $seqid_ = 0;

  public function __construct($input, $output=null) {
    $this->input_ = $input;
    $this->output_ = $output ? $output : $input;
  }

  public function namespace_create($ns)
  {
    $this->send_namespace_create($ns);
    $this->recv_namespace_create();
  }

  public function send_namespace_create($ns)
  {
    $args = new \Hypertable_ThriftGen\ClientService_namespace_create_args();
    $args->ns = $ns;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'namespace_create', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('namespace_create', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_namespace_create()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_namespace_create_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_namespace_create_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function create_namespace($ns)
  {
    $this->send_create_namespace($ns);
    $this->recv_create_namespace();
  }

  public function send_create_namespace($ns)
  {
    $args = new \Hypertable_ThriftGen\ClientService_create_namespace_args();
    $args->ns = $ns;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'create_namespace', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('create_namespace', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_create_namespace()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_create_namespace_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_create_namespace_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function table_create($ns, $table_name, \Hypertable_ThriftGen\Schema $schema)
  {
    $this->send_table_create($ns, $table_name, $schema);
    $this->recv_table_create();
  }

  public function send_table_create($ns, $table_name, \Hypertable_ThriftGen\Schema $schema)
  {
    $args = new \Hypertable_ThriftGen\ClientService_table_create_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->schema = $schema;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'table_create', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('table_create', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_table_create()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_table_create_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_table_create_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function table_alter($ns, $table_name, \Hypertable_ThriftGen\Schema $schema)
  {
    $this->send_table_alter($ns, $table_name, $schema);
    $this->recv_table_alter();
  }

  public function send_table_alter($ns, $table_name, \Hypertable_ThriftGen\Schema $schema)
  {
    $args = new \Hypertable_ThriftGen\ClientService_table_alter_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->schema = $schema;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'table_alter', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('table_alter', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_table_alter()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_table_alter_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_table_alter_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function refresh_table($ns, $table_name)
  {
    $this->send_refresh_table($ns, $table_name);
    $this->recv_refresh_table();
  }

  public function send_refresh_table($ns, $table_name)
  {
    $args = new \Hypertable_ThriftGen\ClientService_refresh_table_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'refresh_table', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('refresh_table', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_refresh_table()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_refresh_table_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_refresh_table_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function namespace_open($ns)
  {
    $this->send_namespace_open($ns);
    return $this->recv_namespace_open();
  }

  public function send_namespace_open($ns)
  {
    $args = new \Hypertable_ThriftGen\ClientService_namespace_open_args();
    $args->ns = $ns;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'namespace_open', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('namespace_open', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_namespace_open()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_namespace_open_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_namespace_open_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("namespace_open failed: unknown result");
  }

  public function open_namespace($ns)
  {
    $this->send_open_namespace($ns);
    return $this->recv_open_namespace();
  }

  public function send_open_namespace($ns)
  {
    $args = new \Hypertable_ThriftGen\ClientService_open_namespace_args();
    $args->ns = $ns;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'open_namespace', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('open_namespace', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_open_namespace()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_open_namespace_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_open_namespace_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("open_namespace failed: unknown result");
  }

  public function namespace_close($ns)
  {
    $this->send_namespace_close($ns);
    $this->recv_namespace_close();
  }

  public function send_namespace_close($ns)
  {
    $args = new \Hypertable_ThriftGen\ClientService_namespace_close_args();
    $args->ns = $ns;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'namespace_close', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('namespace_close', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_namespace_close()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_namespace_close_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_namespace_close_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function close_namespace($ns)
  {
    $this->send_close_namespace($ns);
    $this->recv_close_namespace();
  }

  public function send_close_namespace($ns)
  {
    $args = new \Hypertable_ThriftGen\ClientService_close_namespace_args();
    $args->ns = $ns;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'close_namespace', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('close_namespace', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_close_namespace()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_close_namespace_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_close_namespace_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function future_open($capacity)
  {
    $this->send_future_open($capacity);
    return $this->recv_future_open();
  }

  public function send_future_open($capacity)
  {
    $args = new \Hypertable_ThriftGen\ClientService_future_open_args();
    $args->capacity = $capacity;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'future_open', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('future_open', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_future_open()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_future_open_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_future_open_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("future_open failed: unknown result");
  }

  public function open_future($capacity)
  {
    $this->send_open_future($capacity);
    return $this->recv_open_future();
  }

  public function send_open_future($capacity)
  {
    $args = new \Hypertable_ThriftGen\ClientService_open_future_args();
    $args->capacity = $capacity;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'open_future', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('open_future', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_open_future()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_open_future_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_open_future_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("open_future failed: unknown result");
  }

  public function future_cancel($ff)
  {
    $this->send_future_cancel($ff);
    $this->recv_future_cancel();
  }

  public function send_future_cancel($ff)
  {
    $args = new \Hypertable_ThriftGen\ClientService_future_cancel_args();
    $args->ff = $ff;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'future_cancel', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('future_cancel', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_future_cancel()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_future_cancel_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_future_cancel_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function cancel_future($ff)
  {
    $this->send_cancel_future($ff);
    $this->recv_cancel_future();
  }

  public function send_cancel_future($ff)
  {
    $args = new \Hypertable_ThriftGen\ClientService_cancel_future_args();
    $args->ff = $ff;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'cancel_future', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('cancel_future', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_cancel_future()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_cancel_future_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_cancel_future_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function future_get_result($ff, $timeout_millis)
  {
    $this->send_future_get_result($ff, $timeout_millis);
    return $this->recv_future_get_result();
  }

  public function send_future_get_result($ff, $timeout_millis)
  {
    $args = new \Hypertable_ThriftGen\ClientService_future_get_result_args();
    $args->ff = $ff;
    $args->timeout_millis = $timeout_millis;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'future_get_result', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('future_get_result', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_future_get_result()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_future_get_result_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_future_get_result_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("future_get_result failed: unknown result");
  }

  public function get_future_result($ff, $timeout_millis)
  {
    $this->send_get_future_result($ff, $timeout_millis);
    return $this->recv_get_future_result();
  }

  public function send_get_future_result($ff, $timeout_millis)
  {
    $args = new \Hypertable_ThriftGen\ClientService_get_future_result_args();
    $args->ff = $ff;
    $args->timeout_millis = $timeout_millis;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_future_result', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_future_result', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_future_result()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_get_future_result_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_get_future_result_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("get_future_result failed: unknown result");
  }

  public function future_get_result_as_arrays($ff, $timeout_millis)
  {
    $this->send_future_get_result_as_arrays($ff, $timeout_millis);
    return $this->recv_future_get_result_as_arrays();
  }

  public function send_future_get_result_as_arrays($ff, $timeout_millis)
  {
    $args = new \Hypertable_ThriftGen\ClientService_future_get_result_as_arrays_args();
    $args->ff = $ff;
    $args->timeout_millis = $timeout_millis;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'future_get_result_as_arrays', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('future_get_result_as_arrays', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_future_get_result_as_arrays()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_future_get_result_as_arrays_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_future_get_result_as_arrays_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("future_get_result_as_arrays failed: unknown result");
  }

  public function get_future_result_as_arrays($ff, $timeout_millis)
  {
    $this->send_get_future_result_as_arrays($ff, $timeout_millis);
    return $this->recv_get_future_result_as_arrays();
  }

  public function send_get_future_result_as_arrays($ff, $timeout_millis)
  {
    $args = new \Hypertable_ThriftGen\ClientService_get_future_result_as_arrays_args();
    $args->ff = $ff;
    $args->timeout_millis = $timeout_millis;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_future_result_as_arrays', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_future_result_as_arrays', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_future_result_as_arrays()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_get_future_result_as_arrays_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_get_future_result_as_arrays_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("get_future_result_as_arrays failed: unknown result");
  }

  public function future_get_result_serialized($ff, $timeout_millis)
  {
    $this->send_future_get_result_serialized($ff, $timeout_millis);
    return $this->recv_future_get_result_serialized();
  }

  public function send_future_get_result_serialized($ff, $timeout_millis)
  {
    $args = new \Hypertable_ThriftGen\ClientService_future_get_result_serialized_args();
    $args->ff = $ff;
    $args->timeout_millis = $timeout_millis;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'future_get_result_serialized', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('future_get_result_serialized', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_future_get_result_serialized()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_future_get_result_serialized_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_future_get_result_serialized_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("future_get_result_serialized failed: unknown result");
  }

  public function get_future_result_serialized($ff, $timeout_millis)
  {
    $this->send_get_future_result_serialized($ff, $timeout_millis);
    return $this->recv_get_future_result_serialized();
  }

  public function send_get_future_result_serialized($ff, $timeout_millis)
  {
    $args = new \Hypertable_ThriftGen\ClientService_get_future_result_serialized_args();
    $args->ff = $ff;
    $args->timeout_millis = $timeout_millis;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_future_result_serialized', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_future_result_serialized', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_future_result_serialized()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_get_future_result_serialized_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_get_future_result_serialized_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("get_future_result_serialized failed: unknown result");
  }

  public function future_is_empty($ff)
  {
    $this->send_future_is_empty($ff);
    return $this->recv_future_is_empty();
  }

  public function send_future_is_empty($ff)
  {
    $args = new \Hypertable_ThriftGen\ClientService_future_is_empty_args();
    $args->ff = $ff;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'future_is_empty', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('future_is_empty', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_future_is_empty()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_future_is_empty_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_future_is_empty_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("future_is_empty failed: unknown result");
  }

  public function future_is_full($ff)
  {
    $this->send_future_is_full($ff);
    return $this->recv_future_is_full();
  }

  public function send_future_is_full($ff)
  {
    $args = new \Hypertable_ThriftGen\ClientService_future_is_full_args();
    $args->ff = $ff;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'future_is_full', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('future_is_full', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_future_is_full()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_future_is_full_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_future_is_full_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("future_is_full failed: unknown result");
  }

  public function future_is_cancelled($ff)
  {
    $this->send_future_is_cancelled($ff);
    return $this->recv_future_is_cancelled();
  }

  public function send_future_is_cancelled($ff)
  {
    $args = new \Hypertable_ThriftGen\ClientService_future_is_cancelled_args();
    $args->ff = $ff;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'future_is_cancelled', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('future_is_cancelled', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_future_is_cancelled()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_future_is_cancelled_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_future_is_cancelled_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("future_is_cancelled failed: unknown result");
  }

  public function future_has_outstanding($ff)
  {
    $this->send_future_has_outstanding($ff);
    return $this->recv_future_has_outstanding();
  }

  public function send_future_has_outstanding($ff)
  {
    $args = new \Hypertable_ThriftGen\ClientService_future_has_outstanding_args();
    $args->ff = $ff;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'future_has_outstanding', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('future_has_outstanding', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_future_has_outstanding()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_future_has_outstanding_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_future_has_outstanding_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("future_has_outstanding failed: unknown result");
  }

  public function future_close($ff)
  {
    $this->send_future_close($ff);
    $this->recv_future_close();
  }

  public function send_future_close($ff)
  {
    $args = new \Hypertable_ThriftGen\ClientService_future_close_args();
    $args->ff = $ff;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'future_close', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('future_close', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_future_close()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_future_close_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_future_close_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function close_future($ff)
  {
    $this->send_close_future($ff);
    $this->recv_close_future();
  }

  public function send_close_future($ff)
  {
    $args = new \Hypertable_ThriftGen\ClientService_close_future_args();
    $args->ff = $ff;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'close_future', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('close_future', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_close_future()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_close_future_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_close_future_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function scanner_open($ns, $table_name, \Hypertable_ThriftGen\ScanSpec $scan_spec)
  {
    $this->send_scanner_open($ns, $table_name, $scan_spec);
    return $this->recv_scanner_open();
  }

  public function send_scanner_open($ns, $table_name, \Hypertable_ThriftGen\ScanSpec $scan_spec)
  {
    $args = new \Hypertable_ThriftGen\ClientService_scanner_open_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->scan_spec = $scan_spec;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'scanner_open', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('scanner_open', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_scanner_open()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_scanner_open_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_scanner_open_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("scanner_open failed: unknown result");
  }

  public function open_scanner($ns, $table_name, \Hypertable_ThriftGen\ScanSpec $scan_spec)
  {
    $this->send_open_scanner($ns, $table_name, $scan_spec);
    return $this->recv_open_scanner();
  }

  public function send_open_scanner($ns, $table_name, \Hypertable_ThriftGen\ScanSpec $scan_spec)
  {
    $args = new \Hypertable_ThriftGen\ClientService_open_scanner_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->scan_spec = $scan_spec;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'open_scanner', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('open_scanner', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_open_scanner()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_open_scanner_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_open_scanner_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("open_scanner failed: unknown result");
  }

  public function async_scanner_open($ns, $table_name, $future, \Hypertable_ThriftGen\ScanSpec $scan_spec)
  {
    $this->send_async_scanner_open($ns, $table_name, $future, $scan_spec);
    return $this->recv_async_scanner_open();
  }

  public function send_async_scanner_open($ns, $table_name, $future, \Hypertable_ThriftGen\ScanSpec $scan_spec)
  {
    $args = new \Hypertable_ThriftGen\ClientService_async_scanner_open_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->future = $future;
    $args->scan_spec = $scan_spec;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'async_scanner_open', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('async_scanner_open', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_async_scanner_open()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_async_scanner_open_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_async_scanner_open_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("async_scanner_open failed: unknown result");
  }

  public function open_scanner_async($ns, $table_name, $future, \Hypertable_ThriftGen\ScanSpec $scan_spec)
  {
    $this->send_open_scanner_async($ns, $table_name, $future, $scan_spec);
    return $this->recv_open_scanner_async();
  }

  public function send_open_scanner_async($ns, $table_name, $future, \Hypertable_ThriftGen\ScanSpec $scan_spec)
  {
    $args = new \Hypertable_ThriftGen\ClientService_open_scanner_async_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->future = $future;
    $args->scan_spec = $scan_spec;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'open_scanner_async', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('open_scanner_async', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_open_scanner_async()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_open_scanner_async_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_open_scanner_async_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("open_scanner_async failed: unknown result");
  }

  public function scanner_close($scanner)
  {
    $this->send_scanner_close($scanner);
    $this->recv_scanner_close();
  }

  public function send_scanner_close($scanner)
  {
    $args = new \Hypertable_ThriftGen\ClientService_scanner_close_args();
    $args->scanner = $scanner;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'scanner_close', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('scanner_close', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_scanner_close()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_scanner_close_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_scanner_close_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function close_scanner($scanner)
  {
    $this->send_close_scanner($scanner);
    $this->recv_close_scanner();
  }

  public function send_close_scanner($scanner)
  {
    $args = new \Hypertable_ThriftGen\ClientService_close_scanner_args();
    $args->scanner = $scanner;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'close_scanner', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('close_scanner', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_close_scanner()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_close_scanner_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_close_scanner_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function async_scanner_cancel($scanner)
  {
    $this->send_async_scanner_cancel($scanner);
    $this->recv_async_scanner_cancel();
  }

  public function send_async_scanner_cancel($scanner)
  {
    $args = new \Hypertable_ThriftGen\ClientService_async_scanner_cancel_args();
    $args->scanner = $scanner;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'async_scanner_cancel', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('async_scanner_cancel', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_async_scanner_cancel()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_async_scanner_cancel_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_async_scanner_cancel_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function cancel_scanner_async($scanner)
  {
    $this->send_cancel_scanner_async($scanner);
    $this->recv_cancel_scanner_async();
  }

  public function send_cancel_scanner_async($scanner)
  {
    $args = new \Hypertable_ThriftGen\ClientService_cancel_scanner_async_args();
    $args->scanner = $scanner;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'cancel_scanner_async', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('cancel_scanner_async', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_cancel_scanner_async()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_cancel_scanner_async_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_cancel_scanner_async_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function async_scanner_close($scanner)
  {
    $this->send_async_scanner_close($scanner);
    $this->recv_async_scanner_close();
  }

  public function send_async_scanner_close($scanner)
  {
    $args = new \Hypertable_ThriftGen\ClientService_async_scanner_close_args();
    $args->scanner = $scanner;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'async_scanner_close', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('async_scanner_close', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_async_scanner_close()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_async_scanner_close_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_async_scanner_close_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function close_scanner_async($scanner)
  {
    $this->send_close_scanner_async($scanner);
    $this->recv_close_scanner_async();
  }

  public function send_close_scanner_async($scanner)
  {
    $args = new \Hypertable_ThriftGen\ClientService_close_scanner_async_args();
    $args->scanner = $scanner;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'close_scanner_async', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('close_scanner_async', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_close_scanner_async()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_close_scanner_async_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_close_scanner_async_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function scanner_get_cells($scanner)
  {
    $this->send_scanner_get_cells($scanner);
    return $this->recv_scanner_get_cells();
  }

  public function send_scanner_get_cells($scanner)
  {
    $args = new \Hypertable_ThriftGen\ClientService_scanner_get_cells_args();
    $args->scanner = $scanner;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'scanner_get_cells', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('scanner_get_cells', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_scanner_get_cells()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_scanner_get_cells_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_scanner_get_cells_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("scanner_get_cells failed: unknown result");
  }

  public function next_cells($scanner)
  {
    $this->send_next_cells($scanner);
    return $this->recv_next_cells();
  }

  public function send_next_cells($scanner)
  {
    $args = new \Hypertable_ThriftGen\ClientService_next_cells_args();
    $args->scanner = $scanner;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'next_cells', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('next_cells', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_next_cells()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_next_cells_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_next_cells_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("next_cells failed: unknown result");
  }

  public function scanner_get_cells_as_arrays($scanner)
  {
    $this->send_scanner_get_cells_as_arrays($scanner);
    return $this->recv_scanner_get_cells_as_arrays();
  }

  public function send_scanner_get_cells_as_arrays($scanner)
  {
    $args = new \Hypertable_ThriftGen\ClientService_scanner_get_cells_as_arrays_args();
    $args->scanner = $scanner;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'scanner_get_cells_as_arrays', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('scanner_get_cells_as_arrays', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_scanner_get_cells_as_arrays()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_scanner_get_cells_as_arrays_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_scanner_get_cells_as_arrays_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("scanner_get_cells_as_arrays failed: unknown result");
  }

  public function next_cells_as_arrays($scanner)
  {
    $this->send_next_cells_as_arrays($scanner);
    return $this->recv_next_cells_as_arrays();
  }

  public function send_next_cells_as_arrays($scanner)
  {
    $args = new \Hypertable_ThriftGen\ClientService_next_cells_as_arrays_args();
    $args->scanner = $scanner;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'next_cells_as_arrays', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('next_cells_as_arrays', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_next_cells_as_arrays()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_next_cells_as_arrays_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_next_cells_as_arrays_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("next_cells_as_arrays failed: unknown result");
  }

  public function scanner_get_cells_serialized($scanner)
  {
    $this->send_scanner_get_cells_serialized($scanner);
    return $this->recv_scanner_get_cells_serialized();
  }

  public function send_scanner_get_cells_serialized($scanner)
  {
    $args = new \Hypertable_ThriftGen\ClientService_scanner_get_cells_serialized_args();
    $args->scanner = $scanner;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'scanner_get_cells_serialized', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('scanner_get_cells_serialized', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_scanner_get_cells_serialized()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_scanner_get_cells_serialized_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_scanner_get_cells_serialized_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("scanner_get_cells_serialized failed: unknown result");
  }

  public function next_cells_serialized($scanner)
  {
    $this->send_next_cells_serialized($scanner);
    return $this->recv_next_cells_serialized();
  }

  public function send_next_cells_serialized($scanner)
  {
    $args = new \Hypertable_ThriftGen\ClientService_next_cells_serialized_args();
    $args->scanner = $scanner;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'next_cells_serialized', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('next_cells_serialized', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_next_cells_serialized()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_next_cells_serialized_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_next_cells_serialized_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("next_cells_serialized failed: unknown result");
  }

  public function scanner_get_row($scanner)
  {
    $this->send_scanner_get_row($scanner);
    return $this->recv_scanner_get_row();
  }

  public function send_scanner_get_row($scanner)
  {
    $args = new \Hypertable_ThriftGen\ClientService_scanner_get_row_args();
    $args->scanner = $scanner;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'scanner_get_row', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('scanner_get_row', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_scanner_get_row()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_scanner_get_row_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_scanner_get_row_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("scanner_get_row failed: unknown result");
  }

  public function next_row($scanner)
  {
    $this->send_next_row($scanner);
    return $this->recv_next_row();
  }

  public function send_next_row($scanner)
  {
    $args = new \Hypertable_ThriftGen\ClientService_next_row_args();
    $args->scanner = $scanner;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'next_row', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('next_row', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_next_row()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_next_row_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_next_row_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("next_row failed: unknown result");
  }

  public function scanner_get_row_as_arrays($scanner)
  {
    $this->send_scanner_get_row_as_arrays($scanner);
    return $this->recv_scanner_get_row_as_arrays();
  }

  public function send_scanner_get_row_as_arrays($scanner)
  {
    $args = new \Hypertable_ThriftGen\ClientService_scanner_get_row_as_arrays_args();
    $args->scanner = $scanner;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'scanner_get_row_as_arrays', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('scanner_get_row_as_arrays', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_scanner_get_row_as_arrays()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_scanner_get_row_as_arrays_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_scanner_get_row_as_arrays_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("scanner_get_row_as_arrays failed: unknown result");
  }

  public function next_row_as_arrays($scanner)
  {
    $this->send_next_row_as_arrays($scanner);
    return $this->recv_next_row_as_arrays();
  }

  public function send_next_row_as_arrays($scanner)
  {
    $args = new \Hypertable_ThriftGen\ClientService_next_row_as_arrays_args();
    $args->scanner = $scanner;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'next_row_as_arrays', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('next_row_as_arrays', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_next_row_as_arrays()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_next_row_as_arrays_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_next_row_as_arrays_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("next_row_as_arrays failed: unknown result");
  }

  public function scanner_get_row_serialized($scanner)
  {
    $this->send_scanner_get_row_serialized($scanner);
    return $this->recv_scanner_get_row_serialized();
  }

  public function send_scanner_get_row_serialized($scanner)
  {
    $args = new \Hypertable_ThriftGen\ClientService_scanner_get_row_serialized_args();
    $args->scanner = $scanner;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'scanner_get_row_serialized', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('scanner_get_row_serialized', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_scanner_get_row_serialized()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_scanner_get_row_serialized_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_scanner_get_row_serialized_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("scanner_get_row_serialized failed: unknown result");
  }

  public function next_row_serialized($scanner)
  {
    $this->send_next_row_serialized($scanner);
    return $this->recv_next_row_serialized();
  }

  public function send_next_row_serialized($scanner)
  {
    $args = new \Hypertable_ThriftGen\ClientService_next_row_serialized_args();
    $args->scanner = $scanner;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'next_row_serialized', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('next_row_serialized', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_next_row_serialized()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_next_row_serialized_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_next_row_serialized_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("next_row_serialized failed: unknown result");
  }

  public function get_row($ns, $table_name, $row)
  {
    $this->send_get_row($ns, $table_name, $row);
    return $this->recv_get_row();
  }

  public function send_get_row($ns, $table_name, $row)
  {
    $args = new \Hypertable_ThriftGen\ClientService_get_row_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->row = $row;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_row', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_row', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_row()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_get_row_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_get_row_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("get_row failed: unknown result");
  }

  public function get_row_as_arrays($ns, $name, $row)
  {
    $this->send_get_row_as_arrays($ns, $name, $row);
    return $this->recv_get_row_as_arrays();
  }

  public function send_get_row_as_arrays($ns, $name, $row)
  {
    $args = new \Hypertable_ThriftGen\ClientService_get_row_as_arrays_args();
    $args->ns = $ns;
    $args->name = $name;
    $args->row = $row;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_row_as_arrays', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_row_as_arrays', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_row_as_arrays()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_get_row_as_arrays_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_get_row_as_arrays_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("get_row_as_arrays failed: unknown result");
  }

  public function get_row_serialized($ns, $table_name, $row)
  {
    $this->send_get_row_serialized($ns, $table_name, $row);
    return $this->recv_get_row_serialized();
  }

  public function send_get_row_serialized($ns, $table_name, $row)
  {
    $args = new \Hypertable_ThriftGen\ClientService_get_row_serialized_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->row = $row;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_row_serialized', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_row_serialized', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_row_serialized()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_get_row_serialized_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_get_row_serialized_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("get_row_serialized failed: unknown result");
  }

  public function get_cell($ns, $table_name, $row, $column)
  {
    $this->send_get_cell($ns, $table_name, $row, $column);
    return $this->recv_get_cell();
  }

  public function send_get_cell($ns, $table_name, $row, $column)
  {
    $args = new \Hypertable_ThriftGen\ClientService_get_cell_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->row = $row;
    $args->column = $column;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_cell', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_cell', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_cell()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_get_cell_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_get_cell_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("get_cell failed: unknown result");
  }

  public function get_cells($ns, $table_name, \Hypertable_ThriftGen\ScanSpec $scan_spec)
  {
    $this->send_get_cells($ns, $table_name, $scan_spec);
    return $this->recv_get_cells();
  }

  public function send_get_cells($ns, $table_name, \Hypertable_ThriftGen\ScanSpec $scan_spec)
  {
    $args = new \Hypertable_ThriftGen\ClientService_get_cells_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->scan_spec = $scan_spec;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_cells', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_cells', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_cells()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_get_cells_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_get_cells_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("get_cells failed: unknown result");
  }

  public function get_cells_as_arrays($ns, $name, \Hypertable_ThriftGen\ScanSpec $scan_spec)
  {
    $this->send_get_cells_as_arrays($ns, $name, $scan_spec);
    return $this->recv_get_cells_as_arrays();
  }

  public function send_get_cells_as_arrays($ns, $name, \Hypertable_ThriftGen\ScanSpec $scan_spec)
  {
    $args = new \Hypertable_ThriftGen\ClientService_get_cells_as_arrays_args();
    $args->ns = $ns;
    $args->name = $name;
    $args->scan_spec = $scan_spec;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_cells_as_arrays', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_cells_as_arrays', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_cells_as_arrays()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_get_cells_as_arrays_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_get_cells_as_arrays_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("get_cells_as_arrays failed: unknown result");
  }

  public function get_cells_serialized($ns, $name, \Hypertable_ThriftGen\ScanSpec $scan_spec)
  {
    $this->send_get_cells_serialized($ns, $name, $scan_spec);
    return $this->recv_get_cells_serialized();
  }

  public function send_get_cells_serialized($ns, $name, \Hypertable_ThriftGen\ScanSpec $scan_spec)
  {
    $args = new \Hypertable_ThriftGen\ClientService_get_cells_serialized_args();
    $args->ns = $ns;
    $args->name = $name;
    $args->scan_spec = $scan_spec;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_cells_serialized', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_cells_serialized', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_cells_serialized()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_get_cells_serialized_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_get_cells_serialized_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("get_cells_serialized failed: unknown result");
  }

  public function shared_mutator_refresh($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec)
  {
    $this->send_shared_mutator_refresh($ns, $table_name, $mutate_spec);
    $this->recv_shared_mutator_refresh();
  }

  public function send_shared_mutator_refresh($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec)
  {
    $args = new \Hypertable_ThriftGen\ClientService_shared_mutator_refresh_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->mutate_spec = $mutate_spec;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'shared_mutator_refresh', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('shared_mutator_refresh', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_shared_mutator_refresh()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_shared_mutator_refresh_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_shared_mutator_refresh_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function refresh_shared_mutator($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec)
  {
    $this->send_refresh_shared_mutator($ns, $table_name, $mutate_spec);
    $this->recv_refresh_shared_mutator();
  }

  public function send_refresh_shared_mutator($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec)
  {
    $args = new \Hypertable_ThriftGen\ClientService_refresh_shared_mutator_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->mutate_spec = $mutate_spec;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'refresh_shared_mutator', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('refresh_shared_mutator', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_refresh_shared_mutator()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_refresh_shared_mutator_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_refresh_shared_mutator_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function shared_mutator_set_cells($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec, array $cells)
  {
    $this->send_shared_mutator_set_cells($ns, $table_name, $mutate_spec, $cells);
    $this->recv_shared_mutator_set_cells();
  }

  public function send_shared_mutator_set_cells($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec, array $cells)
  {
    $args = new \Hypertable_ThriftGen\ClientService_shared_mutator_set_cells_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->mutate_spec = $mutate_spec;
    $args->cells = $cells;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'shared_mutator_set_cells', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('shared_mutator_set_cells', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_shared_mutator_set_cells()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_shared_mutator_set_cells_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_shared_mutator_set_cells_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function offer_cells($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec, array $cells)
  {
    $this->send_offer_cells($ns, $table_name, $mutate_spec, $cells);
    $this->recv_offer_cells();
  }

  public function send_offer_cells($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec, array $cells)
  {
    $args = new \Hypertable_ThriftGen\ClientService_offer_cells_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->mutate_spec = $mutate_spec;
    $args->cells = $cells;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'offer_cells', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('offer_cells', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_offer_cells()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_offer_cells_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_offer_cells_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function shared_mutator_set_cells_as_arrays($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec, array $cells)
  {
    $this->send_shared_mutator_set_cells_as_arrays($ns, $table_name, $mutate_spec, $cells);
    $this->recv_shared_mutator_set_cells_as_arrays();
  }

  public function send_shared_mutator_set_cells_as_arrays($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec, array $cells)
  {
    $args = new \Hypertable_ThriftGen\ClientService_shared_mutator_set_cells_as_arrays_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->mutate_spec = $mutate_spec;
    $args->cells = $cells;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'shared_mutator_set_cells_as_arrays', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('shared_mutator_set_cells_as_arrays', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_shared_mutator_set_cells_as_arrays()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_shared_mutator_set_cells_as_arrays_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_shared_mutator_set_cells_as_arrays_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function offer_cells_as_arrays($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec, array $cells)
  {
    $this->send_offer_cells_as_arrays($ns, $table_name, $mutate_spec, $cells);
    $this->recv_offer_cells_as_arrays();
  }

  public function send_offer_cells_as_arrays($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec, array $cells)
  {
    $args = new \Hypertable_ThriftGen\ClientService_offer_cells_as_arrays_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->mutate_spec = $mutate_spec;
    $args->cells = $cells;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'offer_cells_as_arrays', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('offer_cells_as_arrays', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_offer_cells_as_arrays()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_offer_cells_as_arrays_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_offer_cells_as_arrays_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function shared_mutator_set_cell($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec, \Hypertable_ThriftGen\Cell $cell)
  {
    $this->send_shared_mutator_set_cell($ns, $table_name, $mutate_spec, $cell);
    $this->recv_shared_mutator_set_cell();
  }

  public function send_shared_mutator_set_cell($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec, \Hypertable_ThriftGen\Cell $cell)
  {
    $args = new \Hypertable_ThriftGen\ClientService_shared_mutator_set_cell_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->mutate_spec = $mutate_spec;
    $args->cell = $cell;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'shared_mutator_set_cell', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('shared_mutator_set_cell', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_shared_mutator_set_cell()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_shared_mutator_set_cell_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_shared_mutator_set_cell_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function offer_cell($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec, \Hypertable_ThriftGen\Cell $cell)
  {
    $this->send_offer_cell($ns, $table_name, $mutate_spec, $cell);
    $this->recv_offer_cell();
  }

  public function send_offer_cell($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec, \Hypertable_ThriftGen\Cell $cell)
  {
    $args = new \Hypertable_ThriftGen\ClientService_offer_cell_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->mutate_spec = $mutate_spec;
    $args->cell = $cell;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'offer_cell', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('offer_cell', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_offer_cell()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_offer_cell_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_offer_cell_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function shared_mutator_set_cell_as_array($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec, $cell)
  {
    $this->send_shared_mutator_set_cell_as_array($ns, $table_name, $mutate_spec, $cell);
    $this->recv_shared_mutator_set_cell_as_array();
  }

  public function send_shared_mutator_set_cell_as_array($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec, $cell)
  {
    $args = new \Hypertable_ThriftGen\ClientService_shared_mutator_set_cell_as_array_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->mutate_spec = $mutate_spec;
    $args->cell = $cell;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'shared_mutator_set_cell_as_array', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('shared_mutator_set_cell_as_array', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_shared_mutator_set_cell_as_array()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_shared_mutator_set_cell_as_array_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_shared_mutator_set_cell_as_array_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function offer_cell_as_array($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec, $cell)
  {
    $this->send_offer_cell_as_array($ns, $table_name, $mutate_spec, $cell);
    $this->recv_offer_cell_as_array();
  }

  public function send_offer_cell_as_array($ns, $table_name, \Hypertable_ThriftGen\MutateSpec $mutate_spec, $cell)
  {
    $args = new \Hypertable_ThriftGen\ClientService_offer_cell_as_array_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->mutate_spec = $mutate_spec;
    $args->cell = $cell;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'offer_cell_as_array', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('offer_cell_as_array', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_offer_cell_as_array()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_offer_cell_as_array_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_offer_cell_as_array_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function mutator_open($ns, $table_name, $flags, $flush_interval)
  {
    $this->send_mutator_open($ns, $table_name, $flags, $flush_interval);
    return $this->recv_mutator_open();
  }

  public function send_mutator_open($ns, $table_name, $flags, $flush_interval)
  {
    $args = new \Hypertable_ThriftGen\ClientService_mutator_open_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->flags = $flags;
    $args->flush_interval = $flush_interval;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'mutator_open', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('mutator_open', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_mutator_open()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_mutator_open_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_mutator_open_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("mutator_open failed: unknown result");
  }

  public function open_mutator($ns, $table_name, $flags, $flush_interval)
  {
    $this->send_open_mutator($ns, $table_name, $flags, $flush_interval);
    return $this->recv_open_mutator();
  }

  public function send_open_mutator($ns, $table_name, $flags, $flush_interval)
  {
    $args = new \Hypertable_ThriftGen\ClientService_open_mutator_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->flags = $flags;
    $args->flush_interval = $flush_interval;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'open_mutator', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('open_mutator', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_open_mutator()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_open_mutator_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_open_mutator_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("open_mutator failed: unknown result");
  }

  public function async_mutator_open($ns, $table_name, $future, $flags)
  {
    $this->send_async_mutator_open($ns, $table_name, $future, $flags);
    return $this->recv_async_mutator_open();
  }

  public function send_async_mutator_open($ns, $table_name, $future, $flags)
  {
    $args = new \Hypertable_ThriftGen\ClientService_async_mutator_open_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->future = $future;
    $args->flags = $flags;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'async_mutator_open', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('async_mutator_open', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_async_mutator_open()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_async_mutator_open_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_async_mutator_open_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("async_mutator_open failed: unknown result");
  }

  public function open_mutator_async($ns, $table_name, $future, $flags)
  {
    $this->send_open_mutator_async($ns, $table_name, $future, $flags);
    return $this->recv_open_mutator_async();
  }

  public function send_open_mutator_async($ns, $table_name, $future, $flags)
  {
    $args = new \Hypertable_ThriftGen\ClientService_open_mutator_async_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->future = $future;
    $args->flags = $flags;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'open_mutator_async', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('open_mutator_async', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_open_mutator_async()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_open_mutator_async_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_open_mutator_async_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("open_mutator_async failed: unknown result");
  }

  public function mutator_close($mutator)
  {
    $this->send_mutator_close($mutator);
    $this->recv_mutator_close();
  }

  public function send_mutator_close($mutator)
  {
    $args = new \Hypertable_ThriftGen\ClientService_mutator_close_args();
    $args->mutator = $mutator;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'mutator_close', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('mutator_close', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_mutator_close()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_mutator_close_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_mutator_close_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function close_mutator($mutator)
  {
    $this->send_close_mutator($mutator);
    $this->recv_close_mutator();
  }

  public function send_close_mutator($mutator)
  {
    $args = new \Hypertable_ThriftGen\ClientService_close_mutator_args();
    $args->mutator = $mutator;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'close_mutator', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('close_mutator', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_close_mutator()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_close_mutator_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_close_mutator_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function async_mutator_cancel($mutator)
  {
    $this->send_async_mutator_cancel($mutator);
    $this->recv_async_mutator_cancel();
  }

  public function send_async_mutator_cancel($mutator)
  {
    $args = new \Hypertable_ThriftGen\ClientService_async_mutator_cancel_args();
    $args->mutator = $mutator;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'async_mutator_cancel', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('async_mutator_cancel', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_async_mutator_cancel()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_async_mutator_cancel_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_async_mutator_cancel_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function cancel_mutator_async($mutator)
  {
    $this->send_cancel_mutator_async($mutator);
    $this->recv_cancel_mutator_async();
  }

  public function send_cancel_mutator_async($mutator)
  {
    $args = new \Hypertable_ThriftGen\ClientService_cancel_mutator_async_args();
    $args->mutator = $mutator;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'cancel_mutator_async', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('cancel_mutator_async', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_cancel_mutator_async()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_cancel_mutator_async_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_cancel_mutator_async_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function async_mutator_close($mutator)
  {
    $this->send_async_mutator_close($mutator);
    $this->recv_async_mutator_close();
  }

  public function send_async_mutator_close($mutator)
  {
    $args = new \Hypertable_ThriftGen\ClientService_async_mutator_close_args();
    $args->mutator = $mutator;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'async_mutator_close', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('async_mutator_close', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_async_mutator_close()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_async_mutator_close_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_async_mutator_close_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function close_mutator_async($mutator)
  {
    $this->send_close_mutator_async($mutator);
    $this->recv_close_mutator_async();
  }

  public function send_close_mutator_async($mutator)
  {
    $args = new \Hypertable_ThriftGen\ClientService_close_mutator_async_args();
    $args->mutator = $mutator;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'close_mutator_async', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('close_mutator_async', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_close_mutator_async()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_close_mutator_async_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_close_mutator_async_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function mutator_set_cell($mutator, \Hypertable_ThriftGen\Cell $cell)
  {
    $this->send_mutator_set_cell($mutator, $cell);
    $this->recv_mutator_set_cell();
  }

  public function send_mutator_set_cell($mutator, \Hypertable_ThriftGen\Cell $cell)
  {
    $args = new \Hypertable_ThriftGen\ClientService_mutator_set_cell_args();
    $args->mutator = $mutator;
    $args->cell = $cell;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'mutator_set_cell', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('mutator_set_cell', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_mutator_set_cell()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_mutator_set_cell_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_mutator_set_cell_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function set_cell($ns, $table_name, \Hypertable_ThriftGen\Cell $cell)
  {
    $this->send_set_cell($ns, $table_name, $cell);
    $this->recv_set_cell();
  }

  public function send_set_cell($ns, $table_name, \Hypertable_ThriftGen\Cell $cell)
  {
    $args = new \Hypertable_ThriftGen\ClientService_set_cell_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->cell = $cell;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'set_cell', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('set_cell', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_set_cell()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_set_cell_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_set_cell_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function mutator_set_cell_as_array($mutator, $cell)
  {
    $this->send_mutator_set_cell_as_array($mutator, $cell);
    $this->recv_mutator_set_cell_as_array();
  }

  public function send_mutator_set_cell_as_array($mutator, $cell)
  {
    $args = new \Hypertable_ThriftGen\ClientService_mutator_set_cell_as_array_args();
    $args->mutator = $mutator;
    $args->cell = $cell;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'mutator_set_cell_as_array', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('mutator_set_cell_as_array', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_mutator_set_cell_as_array()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_mutator_set_cell_as_array_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_mutator_set_cell_as_array_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function set_cell_as_array($ns, $table_name, $cell)
  {
    $this->send_set_cell_as_array($ns, $table_name, $cell);
    $this->recv_set_cell_as_array();
  }

  public function send_set_cell_as_array($ns, $table_name, $cell)
  {
    $args = new \Hypertable_ThriftGen\ClientService_set_cell_as_array_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->cell = $cell;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'set_cell_as_array', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('set_cell_as_array', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_set_cell_as_array()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_set_cell_as_array_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_set_cell_as_array_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function mutator_set_cells($mutator, array $cells)
  {
    $this->send_mutator_set_cells($mutator, $cells);
    $this->recv_mutator_set_cells();
  }

  public function send_mutator_set_cells($mutator, array $cells)
  {
    $args = new \Hypertable_ThriftGen\ClientService_mutator_set_cells_args();
    $args->mutator = $mutator;
    $args->cells = $cells;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'mutator_set_cells', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('mutator_set_cells', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_mutator_set_cells()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_mutator_set_cells_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_mutator_set_cells_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function set_cells($ns, $table_name, array $cells)
  {
    $this->send_set_cells($ns, $table_name, $cells);
    $this->recv_set_cells();
  }

  public function send_set_cells($ns, $table_name, array $cells)
  {
    $args = new \Hypertable_ThriftGen\ClientService_set_cells_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->cells = $cells;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'set_cells', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('set_cells', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_set_cells()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_set_cells_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_set_cells_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function mutator_set_cells_as_arrays($mutator, array $cells)
  {
    $this->send_mutator_set_cells_as_arrays($mutator, $cells);
    $this->recv_mutator_set_cells_as_arrays();
  }

  public function send_mutator_set_cells_as_arrays($mutator, array $cells)
  {
    $args = new \Hypertable_ThriftGen\ClientService_mutator_set_cells_as_arrays_args();
    $args->mutator = $mutator;
    $args->cells = $cells;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'mutator_set_cells_as_arrays', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('mutator_set_cells_as_arrays', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_mutator_set_cells_as_arrays()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_mutator_set_cells_as_arrays_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_mutator_set_cells_as_arrays_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function set_cells_as_arrays($ns, $table_name, array $cells)
  {
    $this->send_set_cells_as_arrays($ns, $table_name, $cells);
    $this->recv_set_cells_as_arrays();
  }

  public function send_set_cells_as_arrays($ns, $table_name, array $cells)
  {
    $args = new \Hypertable_ThriftGen\ClientService_set_cells_as_arrays_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->cells = $cells;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'set_cells_as_arrays', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('set_cells_as_arrays', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_set_cells_as_arrays()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_set_cells_as_arrays_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_set_cells_as_arrays_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function mutator_set_cells_serialized($mutator, $cells, $flush)
  {
    $this->send_mutator_set_cells_serialized($mutator, $cells, $flush);
    $this->recv_mutator_set_cells_serialized();
  }

  public function send_mutator_set_cells_serialized($mutator, $cells, $flush)
  {
    $args = new \Hypertable_ThriftGen\ClientService_mutator_set_cells_serialized_args();
    $args->mutator = $mutator;
    $args->cells = $cells;
    $args->flush = $flush;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'mutator_set_cells_serialized', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('mutator_set_cells_serialized', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_mutator_set_cells_serialized()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_mutator_set_cells_serialized_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_mutator_set_cells_serialized_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function set_cells_serialized($ns, $table_name, $cells)
  {
    $this->send_set_cells_serialized($ns, $table_name, $cells);
    $this->recv_set_cells_serialized();
  }

  public function send_set_cells_serialized($ns, $table_name, $cells)
  {
    $args = new \Hypertable_ThriftGen\ClientService_set_cells_serialized_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->cells = $cells;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'set_cells_serialized', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('set_cells_serialized', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_set_cells_serialized()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_set_cells_serialized_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_set_cells_serialized_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function mutator_flush($mutator)
  {
    $this->send_mutator_flush($mutator);
    $this->recv_mutator_flush();
  }

  public function send_mutator_flush($mutator)
  {
    $args = new \Hypertable_ThriftGen\ClientService_mutator_flush_args();
    $args->mutator = $mutator;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'mutator_flush', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('mutator_flush', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_mutator_flush()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_mutator_flush_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_mutator_flush_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function flush_mutator($mutator)
  {
    $this->send_flush_mutator($mutator);
    $this->recv_flush_mutator();
  }

  public function send_flush_mutator($mutator)
  {
    $args = new \Hypertable_ThriftGen\ClientService_flush_mutator_args();
    $args->mutator = $mutator;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'flush_mutator', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('flush_mutator', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_flush_mutator()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_flush_mutator_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_flush_mutator_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function async_mutator_set_cell($mutator, \Hypertable_ThriftGen\Cell $cell)
  {
    $this->send_async_mutator_set_cell($mutator, $cell);
    $this->recv_async_mutator_set_cell();
  }

  public function send_async_mutator_set_cell($mutator, \Hypertable_ThriftGen\Cell $cell)
  {
    $args = new \Hypertable_ThriftGen\ClientService_async_mutator_set_cell_args();
    $args->mutator = $mutator;
    $args->cell = $cell;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'async_mutator_set_cell', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('async_mutator_set_cell', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_async_mutator_set_cell()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_async_mutator_set_cell_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_async_mutator_set_cell_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function set_cell_async($mutator, \Hypertable_ThriftGen\Cell $cell)
  {
    $this->send_set_cell_async($mutator, $cell);
    $this->recv_set_cell_async();
  }

  public function send_set_cell_async($mutator, \Hypertable_ThriftGen\Cell $cell)
  {
    $args = new \Hypertable_ThriftGen\ClientService_set_cell_async_args();
    $args->mutator = $mutator;
    $args->cell = $cell;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'set_cell_async', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('set_cell_async', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_set_cell_async()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_set_cell_async_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_set_cell_async_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function async_mutator_set_cell_as_array($mutator, $cell)
  {
    $this->send_async_mutator_set_cell_as_array($mutator, $cell);
    $this->recv_async_mutator_set_cell_as_array();
  }

  public function send_async_mutator_set_cell_as_array($mutator, $cell)
  {
    $args = new \Hypertable_ThriftGen\ClientService_async_mutator_set_cell_as_array_args();
    $args->mutator = $mutator;
    $args->cell = $cell;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'async_mutator_set_cell_as_array', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('async_mutator_set_cell_as_array', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_async_mutator_set_cell_as_array()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_async_mutator_set_cell_as_array_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_async_mutator_set_cell_as_array_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function set_cell_as_array_async($mutator, $cell)
  {
    $this->send_set_cell_as_array_async($mutator, $cell);
    $this->recv_set_cell_as_array_async();
  }

  public function send_set_cell_as_array_async($mutator, $cell)
  {
    $args = new \Hypertable_ThriftGen\ClientService_set_cell_as_array_async_args();
    $args->mutator = $mutator;
    $args->cell = $cell;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'set_cell_as_array_async', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('set_cell_as_array_async', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_set_cell_as_array_async()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_set_cell_as_array_async_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_set_cell_as_array_async_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function async_mutator_set_cells($mutator, array $cells)
  {
    $this->send_async_mutator_set_cells($mutator, $cells);
    $this->recv_async_mutator_set_cells();
  }

  public function send_async_mutator_set_cells($mutator, array $cells)
  {
    $args = new \Hypertable_ThriftGen\ClientService_async_mutator_set_cells_args();
    $args->mutator = $mutator;
    $args->cells = $cells;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'async_mutator_set_cells', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('async_mutator_set_cells', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_async_mutator_set_cells()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_async_mutator_set_cells_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_async_mutator_set_cells_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function set_cells_async($mutator, array $cells)
  {
    $this->send_set_cells_async($mutator, $cells);
    $this->recv_set_cells_async();
  }

  public function send_set_cells_async($mutator, array $cells)
  {
    $args = new \Hypertable_ThriftGen\ClientService_set_cells_async_args();
    $args->mutator = $mutator;
    $args->cells = $cells;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'set_cells_async', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('set_cells_async', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_set_cells_async()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_set_cells_async_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_set_cells_async_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function async_mutator_set_cells_as_arrays($mutator, array $cells)
  {
    $this->send_async_mutator_set_cells_as_arrays($mutator, $cells);
    $this->recv_async_mutator_set_cells_as_arrays();
  }

  public function send_async_mutator_set_cells_as_arrays($mutator, array $cells)
  {
    $args = new \Hypertable_ThriftGen\ClientService_async_mutator_set_cells_as_arrays_args();
    $args->mutator = $mutator;
    $args->cells = $cells;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'async_mutator_set_cells_as_arrays', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('async_mutator_set_cells_as_arrays', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_async_mutator_set_cells_as_arrays()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_async_mutator_set_cells_as_arrays_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_async_mutator_set_cells_as_arrays_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function set_cells_as_arrays_async($mutator, array $cells)
  {
    $this->send_set_cells_as_arrays_async($mutator, $cells);
    $this->recv_set_cells_as_arrays_async();
  }

  public function send_set_cells_as_arrays_async($mutator, array $cells)
  {
    $args = new \Hypertable_ThriftGen\ClientService_set_cells_as_arrays_async_args();
    $args->mutator = $mutator;
    $args->cells = $cells;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'set_cells_as_arrays_async', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('set_cells_as_arrays_async', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_set_cells_as_arrays_async()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_set_cells_as_arrays_async_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_set_cells_as_arrays_async_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function async_mutator_set_cells_serialized($mutator, $cells, $flush)
  {
    $this->send_async_mutator_set_cells_serialized($mutator, $cells, $flush);
    $this->recv_async_mutator_set_cells_serialized();
  }

  public function send_async_mutator_set_cells_serialized($mutator, $cells, $flush)
  {
    $args = new \Hypertable_ThriftGen\ClientService_async_mutator_set_cells_serialized_args();
    $args->mutator = $mutator;
    $args->cells = $cells;
    $args->flush = $flush;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'async_mutator_set_cells_serialized', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('async_mutator_set_cells_serialized', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_async_mutator_set_cells_serialized()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_async_mutator_set_cells_serialized_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_async_mutator_set_cells_serialized_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function set_cells_serialized_async($mutator, $cells, $flush)
  {
    $this->send_set_cells_serialized_async($mutator, $cells, $flush);
    $this->recv_set_cells_serialized_async();
  }

  public function send_set_cells_serialized_async($mutator, $cells, $flush)
  {
    $args = new \Hypertable_ThriftGen\ClientService_set_cells_serialized_async_args();
    $args->mutator = $mutator;
    $args->cells = $cells;
    $args->flush = $flush;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'set_cells_serialized_async', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('set_cells_serialized_async', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_set_cells_serialized_async()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_set_cells_serialized_async_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_set_cells_serialized_async_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function async_mutator_flush($mutator)
  {
    $this->send_async_mutator_flush($mutator);
    $this->recv_async_mutator_flush();
  }

  public function send_async_mutator_flush($mutator)
  {
    $args = new \Hypertable_ThriftGen\ClientService_async_mutator_flush_args();
    $args->mutator = $mutator;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'async_mutator_flush', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('async_mutator_flush', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_async_mutator_flush()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_async_mutator_flush_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_async_mutator_flush_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function flush_mutator_async($mutator)
  {
    $this->send_flush_mutator_async($mutator);
    $this->recv_flush_mutator_async();
  }

  public function send_flush_mutator_async($mutator)
  {
    $args = new \Hypertable_ThriftGen\ClientService_flush_mutator_async_args();
    $args->mutator = $mutator;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'flush_mutator_async', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('flush_mutator_async', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_flush_mutator_async()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_flush_mutator_async_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_flush_mutator_async_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function namespace_exists($ns)
  {
    $this->send_namespace_exists($ns);
    return $this->recv_namespace_exists();
  }

  public function send_namespace_exists($ns)
  {
    $args = new \Hypertable_ThriftGen\ClientService_namespace_exists_args();
    $args->ns = $ns;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'namespace_exists', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('namespace_exists', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_namespace_exists()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_namespace_exists_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_namespace_exists_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("namespace_exists failed: unknown result");
  }

  public function exists_namespace($ns)
  {
    $this->send_exists_namespace($ns);
    return $this->recv_exists_namespace();
  }

  public function send_exists_namespace($ns)
  {
    $args = new \Hypertable_ThriftGen\ClientService_exists_namespace_args();
    $args->ns = $ns;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'exists_namespace', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('exists_namespace', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_exists_namespace()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_exists_namespace_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_exists_namespace_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("exists_namespace failed: unknown result");
  }

  public function exists_table($ns, $name)
  {
    $this->send_exists_table($ns, $name);
    return $this->recv_exists_table();
  }

  public function send_exists_table($ns, $name)
  {
    $args = new \Hypertable_ThriftGen\ClientService_exists_table_args();
    $args->ns = $ns;
    $args->name = $name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'exists_table', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('exists_table', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_exists_table()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_exists_table_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_exists_table_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("exists_table failed: unknown result");
  }

  public function table_exists($ns, $name)
  {
    $this->send_table_exists($ns, $name);
    return $this->recv_table_exists();
  }

  public function send_table_exists($ns, $name)
  {
    $args = new \Hypertable_ThriftGen\ClientService_table_exists_args();
    $args->ns = $ns;
    $args->name = $name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'table_exists', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('table_exists', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_table_exists()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_table_exists_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_table_exists_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("table_exists failed: unknown result");
  }

  public function table_get_id($ns, $table_name)
  {
    $this->send_table_get_id($ns, $table_name);
    return $this->recv_table_get_id();
  }

  public function send_table_get_id($ns, $table_name)
  {
    $args = new \Hypertable_ThriftGen\ClientService_table_get_id_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'table_get_id', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('table_get_id', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_table_get_id()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_table_get_id_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_table_get_id_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("table_get_id failed: unknown result");
  }

  public function get_table_id($ns, $table_name)
  {
    $this->send_get_table_id($ns, $table_name);
    return $this->recv_get_table_id();
  }

  public function send_get_table_id($ns, $table_name)
  {
    $args = new \Hypertable_ThriftGen\ClientService_get_table_id_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_table_id', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_table_id', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_table_id()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_get_table_id_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_get_table_id_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("get_table_id failed: unknown result");
  }

  public function table_get_schema_str($ns, $table_name)
  {
    $this->send_table_get_schema_str($ns, $table_name);
    return $this->recv_table_get_schema_str();
  }

  public function send_table_get_schema_str($ns, $table_name)
  {
    $args = new \Hypertable_ThriftGen\ClientService_table_get_schema_str_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'table_get_schema_str', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('table_get_schema_str', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_table_get_schema_str()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_table_get_schema_str_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_table_get_schema_str_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("table_get_schema_str failed: unknown result");
  }

  public function get_schema_str($ns, $table_name)
  {
    $this->send_get_schema_str($ns, $table_name);
    return $this->recv_get_schema_str();
  }

  public function send_get_schema_str($ns, $table_name)
  {
    $args = new \Hypertable_ThriftGen\ClientService_get_schema_str_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_schema_str', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_schema_str', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_schema_str()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_get_schema_str_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_get_schema_str_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("get_schema_str failed: unknown result");
  }

  public function table_get_schema_str_with_ids($ns, $table_name)
  {
    $this->send_table_get_schema_str_with_ids($ns, $table_name);
    return $this->recv_table_get_schema_str_with_ids();
  }

  public function send_table_get_schema_str_with_ids($ns, $table_name)
  {
    $args = new \Hypertable_ThriftGen\ClientService_table_get_schema_str_with_ids_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'table_get_schema_str_with_ids', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('table_get_schema_str_with_ids', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_table_get_schema_str_with_ids()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_table_get_schema_str_with_ids_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_table_get_schema_str_with_ids_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("table_get_schema_str_with_ids failed: unknown result");
  }

  public function get_schema_str_with_ids($ns, $table_name)
  {
    $this->send_get_schema_str_with_ids($ns, $table_name);
    return $this->recv_get_schema_str_with_ids();
  }

  public function send_get_schema_str_with_ids($ns, $table_name)
  {
    $args = new \Hypertable_ThriftGen\ClientService_get_schema_str_with_ids_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_schema_str_with_ids', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_schema_str_with_ids', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_schema_str_with_ids()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_get_schema_str_with_ids_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_get_schema_str_with_ids_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("get_schema_str_with_ids failed: unknown result");
  }

  public function table_get_schema($ns, $table_name)
  {
    $this->send_table_get_schema($ns, $table_name);
    return $this->recv_table_get_schema();
  }

  public function send_table_get_schema($ns, $table_name)
  {
    $args = new \Hypertable_ThriftGen\ClientService_table_get_schema_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'table_get_schema', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('table_get_schema', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_table_get_schema()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_table_get_schema_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_table_get_schema_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("table_get_schema failed: unknown result");
  }

  public function get_schema($ns, $table_name)
  {
    $this->send_get_schema($ns, $table_name);
    return $this->recv_get_schema();
  }

  public function send_get_schema($ns, $table_name)
  {
    $args = new \Hypertable_ThriftGen\ClientService_get_schema_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_schema', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_schema', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_schema()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_get_schema_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_get_schema_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("get_schema failed: unknown result");
  }

  public function get_tables($ns)
  {
    $this->send_get_tables($ns);
    return $this->recv_get_tables();
  }

  public function send_get_tables($ns)
  {
    $args = new \Hypertable_ThriftGen\ClientService_get_tables_args();
    $args->ns = $ns;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_tables', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_tables', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_tables()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_get_tables_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_get_tables_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("get_tables failed: unknown result");
  }

  public function namespace_get_listing($ns)
  {
    $this->send_namespace_get_listing($ns);
    return $this->recv_namespace_get_listing();
  }

  public function send_namespace_get_listing($ns)
  {
    $args = new \Hypertable_ThriftGen\ClientService_namespace_get_listing_args();
    $args->ns = $ns;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'namespace_get_listing', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('namespace_get_listing', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_namespace_get_listing()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_namespace_get_listing_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_namespace_get_listing_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("namespace_get_listing failed: unknown result");
  }

  public function get_listing($ns)
  {
    $this->send_get_listing($ns);
    return $this->recv_get_listing();
  }

  public function send_get_listing($ns)
  {
    $args = new \Hypertable_ThriftGen\ClientService_get_listing_args();
    $args->ns = $ns;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_listing', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_listing', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_listing()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_get_listing_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_get_listing_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("get_listing failed: unknown result");
  }

  public function table_get_splits($ns, $table_name)
  {
    $this->send_table_get_splits($ns, $table_name);
    return $this->recv_table_get_splits();
  }

  public function send_table_get_splits($ns, $table_name)
  {
    $args = new \Hypertable_ThriftGen\ClientService_table_get_splits_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'table_get_splits', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('table_get_splits', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_table_get_splits()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_table_get_splits_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_table_get_splits_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("table_get_splits failed: unknown result");
  }

  public function get_table_splits($ns, $table_name)
  {
    $this->send_get_table_splits($ns, $table_name);
    return $this->recv_get_table_splits();
  }

  public function send_get_table_splits($ns, $table_name)
  {
    $args = new \Hypertable_ThriftGen\ClientService_get_table_splits_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_table_splits', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_table_splits', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_table_splits()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_get_table_splits_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_get_table_splits_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("get_table_splits failed: unknown result");
  }

  public function namespace_drop($ns, $if_exists)
  {
    $this->send_namespace_drop($ns, $if_exists);
    $this->recv_namespace_drop();
  }

  public function send_namespace_drop($ns, $if_exists)
  {
    $args = new \Hypertable_ThriftGen\ClientService_namespace_drop_args();
    $args->ns = $ns;
    $args->if_exists = $if_exists;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'namespace_drop', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('namespace_drop', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_namespace_drop()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_namespace_drop_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_namespace_drop_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function drop_namespace($ns, $if_exists)
  {
    $this->send_drop_namespace($ns, $if_exists);
    $this->recv_drop_namespace();
  }

  public function send_drop_namespace($ns, $if_exists)
  {
    $args = new \Hypertable_ThriftGen\ClientService_drop_namespace_args();
    $args->ns = $ns;
    $args->if_exists = $if_exists;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_namespace', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_namespace', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_namespace()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_drop_namespace_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_drop_namespace_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function rename_table($ns, $name, $new_name)
  {
    $this->send_rename_table($ns, $name, $new_name);
    $this->recv_rename_table();
  }

  public function send_rename_table($ns, $name, $new_name)
  {
    $args = new \Hypertable_ThriftGen\ClientService_rename_table_args();
    $args->ns = $ns;
    $args->name = $name;
    $args->new_name = $new_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'rename_table', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('rename_table', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_rename_table()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_rename_table_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_rename_table_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function table_rename($ns, $name, $new_name)
  {
    $this->send_table_rename($ns, $name, $new_name);
    $this->recv_table_rename();
  }

  public function send_table_rename($ns, $name, $new_name)
  {
    $args = new \Hypertable_ThriftGen\ClientService_table_rename_args();
    $args->ns = $ns;
    $args->name = $name;
    $args->new_name = $new_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'table_rename', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('table_rename', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_table_rename()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_table_rename_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_table_rename_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function drop_table($ns, $name, $if_exists)
  {
    $this->send_drop_table($ns, $name, $if_exists);
    $this->recv_drop_table();
  }

  public function send_drop_table($ns, $name, $if_exists)
  {
    $args = new \Hypertable_ThriftGen\ClientService_drop_table_args();
    $args->ns = $ns;
    $args->name = $name;
    $args->if_exists = $if_exists;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_table', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_table', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_table()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_drop_table_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_drop_table_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function table_drop($ns, $name, $if_exists)
  {
    $this->send_table_drop($ns, $name, $if_exists);
    $this->recv_table_drop();
  }

  public function send_table_drop($ns, $name, $if_exists)
  {
    $args = new \Hypertable_ThriftGen\ClientService_table_drop_args();
    $args->ns = $ns;
    $args->name = $name;
    $args->if_exists = $if_exists;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'table_drop', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('table_drop', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_table_drop()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_table_drop_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_table_drop_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

  public function generate_guid()
  {
    $this->send_generate_guid();
    return $this->recv_generate_guid();
  }

  public function send_generate_guid()
  {
    $args = new \Hypertable_ThriftGen\ClientService_generate_guid_args();
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'generate_guid', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('generate_guid', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_generate_guid()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_generate_guid_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_generate_guid_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("generate_guid failed: unknown result");
  }

  public function create_cell_unique($ns, $table_name, \Hypertable_ThriftGen\Key $key, $value)
  {
    $this->send_create_cell_unique($ns, $table_name, $key, $value);
    return $this->recv_create_cell_unique();
  }

  public function send_create_cell_unique($ns, $table_name, \Hypertable_ThriftGen\Key $key, $value)
  {
    $args = new \Hypertable_ThriftGen\ClientService_create_cell_unique_args();
    $args->ns = $ns;
    $args->table_name = $table_name;
    $args->key = $key;
    $args->value = $value;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'create_cell_unique', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('create_cell_unique', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_create_cell_unique()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_create_cell_unique_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_create_cell_unique_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("create_cell_unique failed: unknown result");
  }

  public function error_get_text($error_code)
  {
    $this->send_error_get_text($error_code);
    return $this->recv_error_get_text();
  }

  public function send_error_get_text($error_code)
  {
    $args = new \Hypertable_ThriftGen\ClientService_error_get_text_args();
    $args->error_code = $error_code;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'error_get_text', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('error_get_text', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_error_get_text()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_error_get_text_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_error_get_text_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("error_get_text failed: unknown result");
  }

  public function status()
  {
    $this->send_status();
    return $this->recv_status();
  }

  public function send_status()
  {
    $args = new \Hypertable_ThriftGen\ClientService_status_args();
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'status', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('status', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_status()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_status_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_status_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    throw new \Exception("status failed: unknown result");
  }

  public function shutdown()
  {
    $this->send_shutdown();
    $this->recv_shutdown();
  }

  public function send_shutdown()
  {
    $args = new \Hypertable_ThriftGen\ClientService_shutdown_args();
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'shutdown', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('shutdown', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_shutdown()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Hypertable_ThriftGen\ClientService_shutdown_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Hypertable_ThriftGen\ClientService_shutdown_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->e !== null) {
      throw $result->e;
    }
    return;
  }

}

// HELPER FUNCTIONS AND STRUCTURES

class ClientService_namespace_create_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $ns = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
    }
  }

  public function getName() {
    return 'ClientService_namespace_create_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_namespace_create_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::STRING, 1);
      $xfer += $output->writeString($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_namespace_create_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_namespace_create_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_namespace_create_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_create_namespace_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $ns = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
    }
  }

  public function getName() {
    return 'ClientService_create_namespace_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_create_namespace_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::STRING, 1);
      $xfer += $output->writeString($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_create_namespace_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_create_namespace_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_create_namespace_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_table_create_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var \Hypertable_ThriftGen\Schema
   */
  public $schema = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'schema',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\Schema',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['schema'])) {
        $this->schema = $vals['schema'];
      }
    }
  }

  public function getName() {
    return 'ClientService_table_create_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->schema = new \Hypertable_ThriftGen\Schema();
            $xfer += $this->schema->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_table_create_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->schema !== null) {
      if (!is_object($this->schema)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('schema', TType::STRUCT, 3);
      $xfer += $this->schema->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_table_create_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_table_create_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_table_create_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_table_alter_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var \Hypertable_ThriftGen\Schema
   */
  public $schema = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'schema',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\Schema',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['schema'])) {
        $this->schema = $vals['schema'];
      }
    }
  }

  public function getName() {
    return 'ClientService_table_alter_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->schema = new \Hypertable_ThriftGen\Schema();
            $xfer += $this->schema->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_table_alter_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->schema !== null) {
      if (!is_object($this->schema)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('schema', TType::STRUCT, 3);
      $xfer += $this->schema->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_table_alter_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_table_alter_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_table_alter_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_refresh_table_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
    }
  }

  public function getName() {
    return 'ClientService_refresh_table_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_refresh_table_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_refresh_table_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_refresh_table_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_refresh_table_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_namespace_open_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $ns = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
    }
  }

  public function getName() {
    return 'ClientService_namespace_open_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_namespace_open_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::STRING, 1);
      $xfer += $output->writeString($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_namespace_open_result {
  static $_TSPEC;

  /**
   * @var int
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::I64,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_namespace_open_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_namespace_open_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::I64, 0);
      $xfer += $output->writeI64($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_open_namespace_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $ns = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
    }
  }

  public function getName() {
    return 'ClientService_open_namespace_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_open_namespace_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::STRING, 1);
      $xfer += $output->writeString($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_open_namespace_result {
  static $_TSPEC;

  /**
   * @var int
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::I64,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_open_namespace_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_open_namespace_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::I64, 0);
      $xfer += $output->writeI64($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_namespace_close_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
    }
  }

  public function getName() {
    return 'ClientService_namespace_close_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_namespace_close_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_namespace_close_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_namespace_close_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_namespace_close_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_close_namespace_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
    }
  }

  public function getName() {
    return 'ClientService_close_namespace_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_close_namespace_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_close_namespace_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_close_namespace_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_close_namespace_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_future_open_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $capacity = 0;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'capacity',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['capacity'])) {
        $this->capacity = $vals['capacity'];
      }
    }
  }

  public function getName() {
    return 'ClientService_future_open_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->capacity);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_future_open_args');
    if ($this->capacity !== null) {
      $xfer += $output->writeFieldBegin('capacity', TType::I32, 1);
      $xfer += $output->writeI32($this->capacity);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_future_open_result {
  static $_TSPEC;

  /**
   * @var int
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::I64,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_future_open_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_future_open_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::I64, 0);
      $xfer += $output->writeI64($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_open_future_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $capacity = 0;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'capacity',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['capacity'])) {
        $this->capacity = $vals['capacity'];
      }
    }
  }

  public function getName() {
    return 'ClientService_open_future_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->capacity);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_open_future_args');
    if ($this->capacity !== null) {
      $xfer += $output->writeFieldBegin('capacity', TType::I32, 1);
      $xfer += $output->writeI32($this->capacity);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_open_future_result {
  static $_TSPEC;

  /**
   * @var int
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::I64,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_open_future_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_open_future_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::I64, 0);
      $xfer += $output->writeI64($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_future_cancel_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ff = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ff',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ff'])) {
        $this->ff = $vals['ff'];
      }
    }
  }

  public function getName() {
    return 'ClientService_future_cancel_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ff);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_future_cancel_args');
    if ($this->ff !== null) {
      $xfer += $output->writeFieldBegin('ff', TType::I64, 1);
      $xfer += $output->writeI64($this->ff);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_future_cancel_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_future_cancel_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_future_cancel_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_cancel_future_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ff = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ff',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ff'])) {
        $this->ff = $vals['ff'];
      }
    }
  }

  public function getName() {
    return 'ClientService_cancel_future_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ff);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_cancel_future_args');
    if ($this->ff !== null) {
      $xfer += $output->writeFieldBegin('ff', TType::I64, 1);
      $xfer += $output->writeI64($this->ff);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_cancel_future_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_cancel_future_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_cancel_future_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_future_get_result_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ff = null;
  /**
   * @var int
   */
  public $timeout_millis = 0;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ff',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'timeout_millis',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ff'])) {
        $this->ff = $vals['ff'];
      }
      if (isset($vals['timeout_millis'])) {
        $this->timeout_millis = $vals['timeout_millis'];
      }
    }
  }

  public function getName() {
    return 'ClientService_future_get_result_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ff);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->timeout_millis);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_future_get_result_args');
    if ($this->ff !== null) {
      $xfer += $output->writeFieldBegin('ff', TType::I64, 1);
      $xfer += $output->writeI64($this->ff);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->timeout_millis !== null) {
      $xfer += $output->writeFieldBegin('timeout_millis', TType::I32, 2);
      $xfer += $output->writeI32($this->timeout_millis);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_future_get_result_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\Result
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\Result',
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_future_get_result_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Hypertable_ThriftGen\Result();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_future_get_result_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_future_result_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ff = null;
  /**
   * @var int
   */
  public $timeout_millis = 0;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ff',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'timeout_millis',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ff'])) {
        $this->ff = $vals['ff'];
      }
      if (isset($vals['timeout_millis'])) {
        $this->timeout_millis = $vals['timeout_millis'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_future_result_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ff);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->timeout_millis);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_future_result_args');
    if ($this->ff !== null) {
      $xfer += $output->writeFieldBegin('ff', TType::I64, 1);
      $xfer += $output->writeI64($this->ff);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->timeout_millis !== null) {
      $xfer += $output->writeFieldBegin('timeout_millis', TType::I32, 2);
      $xfer += $output->writeI32($this->timeout_millis);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_future_result_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\Result
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\Result',
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_future_result_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Hypertable_ThriftGen\Result();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_future_result_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_future_get_result_as_arrays_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ff = null;
  /**
   * @var int
   */
  public $timeout_millis = 0;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ff',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'timeout_millis',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ff'])) {
        $this->ff = $vals['ff'];
      }
      if (isset($vals['timeout_millis'])) {
        $this->timeout_millis = $vals['timeout_millis'];
      }
    }
  }

  public function getName() {
    return 'ClientService_future_get_result_as_arrays_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ff);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->timeout_millis);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_future_get_result_as_arrays_args');
    if ($this->ff !== null) {
      $xfer += $output->writeFieldBegin('ff', TType::I64, 1);
      $xfer += $output->writeI64($this->ff);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->timeout_millis !== null) {
      $xfer += $output->writeFieldBegin('timeout_millis', TType::I32, 2);
      $xfer += $output->writeI32($this->timeout_millis);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_future_get_result_as_arrays_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ResultAsArrays
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ResultAsArrays',
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_future_get_result_as_arrays_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Hypertable_ThriftGen\ResultAsArrays();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_future_get_result_as_arrays_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_future_result_as_arrays_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ff = null;
  /**
   * @var int
   */
  public $timeout_millis = 0;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ff',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'timeout_millis',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ff'])) {
        $this->ff = $vals['ff'];
      }
      if (isset($vals['timeout_millis'])) {
        $this->timeout_millis = $vals['timeout_millis'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_future_result_as_arrays_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ff);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->timeout_millis);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_future_result_as_arrays_args');
    if ($this->ff !== null) {
      $xfer += $output->writeFieldBegin('ff', TType::I64, 1);
      $xfer += $output->writeI64($this->ff);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->timeout_millis !== null) {
      $xfer += $output->writeFieldBegin('timeout_millis', TType::I32, 2);
      $xfer += $output->writeI32($this->timeout_millis);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_future_result_as_arrays_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ResultAsArrays
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ResultAsArrays',
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_future_result_as_arrays_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Hypertable_ThriftGen\ResultAsArrays();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_future_result_as_arrays_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_future_get_result_serialized_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ff = null;
  /**
   * @var int
   */
  public $timeout_millis = 0;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ff',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'timeout_millis',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ff'])) {
        $this->ff = $vals['ff'];
      }
      if (isset($vals['timeout_millis'])) {
        $this->timeout_millis = $vals['timeout_millis'];
      }
    }
  }

  public function getName() {
    return 'ClientService_future_get_result_serialized_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ff);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->timeout_millis);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_future_get_result_serialized_args');
    if ($this->ff !== null) {
      $xfer += $output->writeFieldBegin('ff', TType::I64, 1);
      $xfer += $output->writeI64($this->ff);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->timeout_millis !== null) {
      $xfer += $output->writeFieldBegin('timeout_millis', TType::I32, 2);
      $xfer += $output->writeI32($this->timeout_millis);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_future_get_result_serialized_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ResultSerialized
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ResultSerialized',
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_future_get_result_serialized_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Hypertable_ThriftGen\ResultSerialized();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_future_get_result_serialized_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_future_result_serialized_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ff = null;
  /**
   * @var int
   */
  public $timeout_millis = 0;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ff',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'timeout_millis',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ff'])) {
        $this->ff = $vals['ff'];
      }
      if (isset($vals['timeout_millis'])) {
        $this->timeout_millis = $vals['timeout_millis'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_future_result_serialized_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ff);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->timeout_millis);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_future_result_serialized_args');
    if ($this->ff !== null) {
      $xfer += $output->writeFieldBegin('ff', TType::I64, 1);
      $xfer += $output->writeI64($this->ff);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->timeout_millis !== null) {
      $xfer += $output->writeFieldBegin('timeout_millis', TType::I32, 2);
      $xfer += $output->writeI32($this->timeout_millis);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_future_result_serialized_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ResultSerialized
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ResultSerialized',
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_future_result_serialized_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Hypertable_ThriftGen\ResultSerialized();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_future_result_serialized_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_future_is_empty_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ff = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ff',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ff'])) {
        $this->ff = $vals['ff'];
      }
    }
  }

  public function getName() {
    return 'ClientService_future_is_empty_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ff);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_future_is_empty_args');
    if ($this->ff !== null) {
      $xfer += $output->writeFieldBegin('ff', TType::I64, 1);
      $xfer += $output->writeI64($this->ff);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_future_is_empty_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_future_is_empty_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_future_is_empty_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_future_is_full_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ff = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ff',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ff'])) {
        $this->ff = $vals['ff'];
      }
    }
  }

  public function getName() {
    return 'ClientService_future_is_full_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ff);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_future_is_full_args');
    if ($this->ff !== null) {
      $xfer += $output->writeFieldBegin('ff', TType::I64, 1);
      $xfer += $output->writeI64($this->ff);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_future_is_full_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_future_is_full_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_future_is_full_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_future_is_cancelled_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ff = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ff',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ff'])) {
        $this->ff = $vals['ff'];
      }
    }
  }

  public function getName() {
    return 'ClientService_future_is_cancelled_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ff);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_future_is_cancelled_args');
    if ($this->ff !== null) {
      $xfer += $output->writeFieldBegin('ff', TType::I64, 1);
      $xfer += $output->writeI64($this->ff);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_future_is_cancelled_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_future_is_cancelled_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_future_is_cancelled_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_future_has_outstanding_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ff = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ff',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ff'])) {
        $this->ff = $vals['ff'];
      }
    }
  }

  public function getName() {
    return 'ClientService_future_has_outstanding_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ff);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_future_has_outstanding_args');
    if ($this->ff !== null) {
      $xfer += $output->writeFieldBegin('ff', TType::I64, 1);
      $xfer += $output->writeI64($this->ff);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_future_has_outstanding_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_future_has_outstanding_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_future_has_outstanding_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_future_close_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ff = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ff',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ff'])) {
        $this->ff = $vals['ff'];
      }
    }
  }

  public function getName() {
    return 'ClientService_future_close_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ff);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_future_close_args');
    if ($this->ff !== null) {
      $xfer += $output->writeFieldBegin('ff', TType::I64, 1);
      $xfer += $output->writeI64($this->ff);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_future_close_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_future_close_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_future_close_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_close_future_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ff = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ff',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ff'])) {
        $this->ff = $vals['ff'];
      }
    }
  }

  public function getName() {
    return 'ClientService_close_future_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ff);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_close_future_args');
    if ($this->ff !== null) {
      $xfer += $output->writeFieldBegin('ff', TType::I64, 1);
      $xfer += $output->writeI64($this->ff);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_close_future_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_close_future_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_close_future_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_scanner_open_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var \Hypertable_ThriftGen\ScanSpec
   */
  public $scan_spec = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'scan_spec',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ScanSpec',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['scan_spec'])) {
        $this->scan_spec = $vals['scan_spec'];
      }
    }
  }

  public function getName() {
    return 'ClientService_scanner_open_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->scan_spec = new \Hypertable_ThriftGen\ScanSpec();
            $xfer += $this->scan_spec->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_scanner_open_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->scan_spec !== null) {
      if (!is_object($this->scan_spec)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('scan_spec', TType::STRUCT, 3);
      $xfer += $this->scan_spec->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_scanner_open_result {
  static $_TSPEC;

  /**
   * @var int
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::I64,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_scanner_open_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_scanner_open_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::I64, 0);
      $xfer += $output->writeI64($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_open_scanner_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var \Hypertable_ThriftGen\ScanSpec
   */
  public $scan_spec = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'scan_spec',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ScanSpec',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['scan_spec'])) {
        $this->scan_spec = $vals['scan_spec'];
      }
    }
  }

  public function getName() {
    return 'ClientService_open_scanner_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->scan_spec = new \Hypertable_ThriftGen\ScanSpec();
            $xfer += $this->scan_spec->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_open_scanner_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->scan_spec !== null) {
      if (!is_object($this->scan_spec)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('scan_spec', TType::STRUCT, 3);
      $xfer += $this->scan_spec->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_open_scanner_result {
  static $_TSPEC;

  /**
   * @var int
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::I64,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_open_scanner_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_open_scanner_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::I64, 0);
      $xfer += $output->writeI64($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_async_scanner_open_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var int
   */
  public $future = null;
  /**
   * @var \Hypertable_ThriftGen\ScanSpec
   */
  public $scan_spec = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'future',
          'type' => TType::I64,
          ),
        4 => array(
          'var' => 'scan_spec',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ScanSpec',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['future'])) {
        $this->future = $vals['future'];
      }
      if (isset($vals['scan_spec'])) {
        $this->scan_spec = $vals['scan_spec'];
      }
    }
  }

  public function getName() {
    return 'ClientService_async_scanner_open_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->future);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->scan_spec = new \Hypertable_ThriftGen\ScanSpec();
            $xfer += $this->scan_spec->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_async_scanner_open_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->future !== null) {
      $xfer += $output->writeFieldBegin('future', TType::I64, 3);
      $xfer += $output->writeI64($this->future);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->scan_spec !== null) {
      if (!is_object($this->scan_spec)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('scan_spec', TType::STRUCT, 4);
      $xfer += $this->scan_spec->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_async_scanner_open_result {
  static $_TSPEC;

  /**
   * @var int
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::I64,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_async_scanner_open_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_async_scanner_open_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::I64, 0);
      $xfer += $output->writeI64($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_open_scanner_async_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var int
   */
  public $future = null;
  /**
   * @var \Hypertable_ThriftGen\ScanSpec
   */
  public $scan_spec = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'future',
          'type' => TType::I64,
          ),
        4 => array(
          'var' => 'scan_spec',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ScanSpec',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['future'])) {
        $this->future = $vals['future'];
      }
      if (isset($vals['scan_spec'])) {
        $this->scan_spec = $vals['scan_spec'];
      }
    }
  }

  public function getName() {
    return 'ClientService_open_scanner_async_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->future);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->scan_spec = new \Hypertable_ThriftGen\ScanSpec();
            $xfer += $this->scan_spec->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_open_scanner_async_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->future !== null) {
      $xfer += $output->writeFieldBegin('future', TType::I64, 3);
      $xfer += $output->writeI64($this->future);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->scan_spec !== null) {
      if (!is_object($this->scan_spec)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('scan_spec', TType::STRUCT, 4);
      $xfer += $this->scan_spec->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_open_scanner_async_result {
  static $_TSPEC;

  /**
   * @var int
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::I64,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_open_scanner_async_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_open_scanner_async_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::I64, 0);
      $xfer += $output->writeI64($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_scanner_close_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $scanner = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'scanner',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['scanner'])) {
        $this->scanner = $vals['scanner'];
      }
    }
  }

  public function getName() {
    return 'ClientService_scanner_close_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->scanner);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_scanner_close_args');
    if ($this->scanner !== null) {
      $xfer += $output->writeFieldBegin('scanner', TType::I64, 1);
      $xfer += $output->writeI64($this->scanner);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_scanner_close_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_scanner_close_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_scanner_close_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_close_scanner_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $scanner = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'scanner',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['scanner'])) {
        $this->scanner = $vals['scanner'];
      }
    }
  }

  public function getName() {
    return 'ClientService_close_scanner_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->scanner);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_close_scanner_args');
    if ($this->scanner !== null) {
      $xfer += $output->writeFieldBegin('scanner', TType::I64, 1);
      $xfer += $output->writeI64($this->scanner);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_close_scanner_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_close_scanner_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_close_scanner_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_async_scanner_cancel_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $scanner = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'scanner',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['scanner'])) {
        $this->scanner = $vals['scanner'];
      }
    }
  }

  public function getName() {
    return 'ClientService_async_scanner_cancel_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->scanner);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_async_scanner_cancel_args');
    if ($this->scanner !== null) {
      $xfer += $output->writeFieldBegin('scanner', TType::I64, 1);
      $xfer += $output->writeI64($this->scanner);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_async_scanner_cancel_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_async_scanner_cancel_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_async_scanner_cancel_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_cancel_scanner_async_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $scanner = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'scanner',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['scanner'])) {
        $this->scanner = $vals['scanner'];
      }
    }
  }

  public function getName() {
    return 'ClientService_cancel_scanner_async_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->scanner);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_cancel_scanner_async_args');
    if ($this->scanner !== null) {
      $xfer += $output->writeFieldBegin('scanner', TType::I64, 1);
      $xfer += $output->writeI64($this->scanner);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_cancel_scanner_async_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_cancel_scanner_async_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_cancel_scanner_async_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_async_scanner_close_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $scanner = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'scanner',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['scanner'])) {
        $this->scanner = $vals['scanner'];
      }
    }
  }

  public function getName() {
    return 'ClientService_async_scanner_close_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->scanner);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_async_scanner_close_args');
    if ($this->scanner !== null) {
      $xfer += $output->writeFieldBegin('scanner', TType::I64, 1);
      $xfer += $output->writeI64($this->scanner);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_async_scanner_close_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_async_scanner_close_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_async_scanner_close_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_close_scanner_async_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $scanner = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'scanner',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['scanner'])) {
        $this->scanner = $vals['scanner'];
      }
    }
  }

  public function getName() {
    return 'ClientService_close_scanner_async_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->scanner);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_close_scanner_async_args');
    if ($this->scanner !== null) {
      $xfer += $output->writeFieldBegin('scanner', TType::I64, 1);
      $xfer += $output->writeI64($this->scanner);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_close_scanner_async_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_close_scanner_async_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_close_scanner_async_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_scanner_get_cells_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $scanner = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'scanner',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['scanner'])) {
        $this->scanner = $vals['scanner'];
      }
    }
  }

  public function getName() {
    return 'ClientService_scanner_get_cells_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->scanner);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_scanner_get_cells_args');
    if ($this->scanner !== null) {
      $xfer += $output->writeFieldBegin('scanner', TType::I64, 1);
      $xfer += $output->writeI64($this->scanner);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_scanner_get_cells_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\Cell[]
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hypertable_ThriftGen\Cell',
            ),
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_scanner_get_cells_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size67 = 0;
            $_etype70 = 0;
            $xfer += $input->readListBegin($_etype70, $_size67);
            for ($_i71 = 0; $_i71 < $_size67; ++$_i71)
            {
              $elem72 = null;
              $elem72 = new \Hypertable_ThriftGen\Cell();
              $xfer += $elem72->read($input);
              $this->success []= $elem72;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_scanner_get_cells_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter73)
          {
            $xfer += $iter73->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_next_cells_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $scanner = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'scanner',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['scanner'])) {
        $this->scanner = $vals['scanner'];
      }
    }
  }

  public function getName() {
    return 'ClientService_next_cells_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->scanner);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_next_cells_args');
    if ($this->scanner !== null) {
      $xfer += $output->writeFieldBegin('scanner', TType::I64, 1);
      $xfer += $output->writeI64($this->scanner);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_next_cells_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\Cell[]
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hypertable_ThriftGen\Cell',
            ),
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_next_cells_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size74 = 0;
            $_etype77 = 0;
            $xfer += $input->readListBegin($_etype77, $_size74);
            for ($_i78 = 0; $_i78 < $_size74; ++$_i78)
            {
              $elem79 = null;
              $elem79 = new \Hypertable_ThriftGen\Cell();
              $xfer += $elem79->read($input);
              $this->success []= $elem79;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_next_cells_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter80)
          {
            $xfer += $iter80->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_scanner_get_cells_as_arrays_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $scanner = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'scanner',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['scanner'])) {
        $this->scanner = $vals['scanner'];
      }
    }
  }

  public function getName() {
    return 'ClientService_scanner_get_cells_as_arrays_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->scanner);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_scanner_get_cells_as_arrays_args');
    if ($this->scanner !== null) {
      $xfer += $output->writeFieldBegin('scanner', TType::I64, 1);
      $xfer += $output->writeI64($this->scanner);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_scanner_get_cells_as_arrays_result {
  static $_TSPEC;

  /**
   * @var string[][]
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::LST,
          'elem' => array(
            'type' => TType::LST,
            'etype' => TType::STRING,
            'elem' => array(
              'type' => TType::STRING,
              ),
            ),
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_scanner_get_cells_as_arrays_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size81 = 0;
            $_etype84 = 0;
            $xfer += $input->readListBegin($_etype84, $_size81);
            for ($_i85 = 0; $_i85 < $_size81; ++$_i85)
            {
              $elem86 = null;
              $elem86 = array();
              $_size87 = 0;
              $_etype90 = 0;
              $xfer += $input->readListBegin($_etype90, $_size87);
              for ($_i91 = 0; $_i91 < $_size87; ++$_i91)
              {
                $elem92 = null;
                $xfer += $input->readString($elem92);
                $elem86 []= $elem92;
              }
              $xfer += $input->readListEnd();
              $this->success []= $elem86;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_scanner_get_cells_as_arrays_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::LST, count($this->success));
        {
          foreach ($this->success as $iter93)
          {
            {
              $output->writeListBegin(TType::STRING, count($iter93));
              {
                foreach ($iter93 as $iter94)
                {
                  $xfer += $output->writeString($iter94);
                }
              }
              $output->writeListEnd();
            }
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_next_cells_as_arrays_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $scanner = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'scanner',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['scanner'])) {
        $this->scanner = $vals['scanner'];
      }
    }
  }

  public function getName() {
    return 'ClientService_next_cells_as_arrays_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->scanner);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_next_cells_as_arrays_args');
    if ($this->scanner !== null) {
      $xfer += $output->writeFieldBegin('scanner', TType::I64, 1);
      $xfer += $output->writeI64($this->scanner);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_next_cells_as_arrays_result {
  static $_TSPEC;

  /**
   * @var string[][]
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::LST,
          'elem' => array(
            'type' => TType::LST,
            'etype' => TType::STRING,
            'elem' => array(
              'type' => TType::STRING,
              ),
            ),
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_next_cells_as_arrays_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size95 = 0;
            $_etype98 = 0;
            $xfer += $input->readListBegin($_etype98, $_size95);
            for ($_i99 = 0; $_i99 < $_size95; ++$_i99)
            {
              $elem100 = null;
              $elem100 = array();
              $_size101 = 0;
              $_etype104 = 0;
              $xfer += $input->readListBegin($_etype104, $_size101);
              for ($_i105 = 0; $_i105 < $_size101; ++$_i105)
              {
                $elem106 = null;
                $xfer += $input->readString($elem106);
                $elem100 []= $elem106;
              }
              $xfer += $input->readListEnd();
              $this->success []= $elem100;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_next_cells_as_arrays_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::LST, count($this->success));
        {
          foreach ($this->success as $iter107)
          {
            {
              $output->writeListBegin(TType::STRING, count($iter107));
              {
                foreach ($iter107 as $iter108)
                {
                  $xfer += $output->writeString($iter108);
                }
              }
              $output->writeListEnd();
            }
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_scanner_get_cells_serialized_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $scanner = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'scanner',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['scanner'])) {
        $this->scanner = $vals['scanner'];
      }
    }
  }

  public function getName() {
    return 'ClientService_scanner_get_cells_serialized_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->scanner);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_scanner_get_cells_serialized_args');
    if ($this->scanner !== null) {
      $xfer += $output->writeFieldBegin('scanner', TType::I64, 1);
      $xfer += $output->writeI64($this->scanner);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_scanner_get_cells_serialized_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_scanner_get_cells_serialized_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_scanner_get_cells_serialized_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_next_cells_serialized_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $scanner = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'scanner',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['scanner'])) {
        $this->scanner = $vals['scanner'];
      }
    }
  }

  public function getName() {
    return 'ClientService_next_cells_serialized_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->scanner);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_next_cells_serialized_args');
    if ($this->scanner !== null) {
      $xfer += $output->writeFieldBegin('scanner', TType::I64, 1);
      $xfer += $output->writeI64($this->scanner);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_next_cells_serialized_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_next_cells_serialized_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_next_cells_serialized_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_scanner_get_row_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $scanner = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'scanner',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['scanner'])) {
        $this->scanner = $vals['scanner'];
      }
    }
  }

  public function getName() {
    return 'ClientService_scanner_get_row_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->scanner);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_scanner_get_row_args');
    if ($this->scanner !== null) {
      $xfer += $output->writeFieldBegin('scanner', TType::I64, 1);
      $xfer += $output->writeI64($this->scanner);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_scanner_get_row_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\Cell[]
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hypertable_ThriftGen\Cell',
            ),
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_scanner_get_row_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size109 = 0;
            $_etype112 = 0;
            $xfer += $input->readListBegin($_etype112, $_size109);
            for ($_i113 = 0; $_i113 < $_size109; ++$_i113)
            {
              $elem114 = null;
              $elem114 = new \Hypertable_ThriftGen\Cell();
              $xfer += $elem114->read($input);
              $this->success []= $elem114;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_scanner_get_row_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter115)
          {
            $xfer += $iter115->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_next_row_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $scanner = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'scanner',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['scanner'])) {
        $this->scanner = $vals['scanner'];
      }
    }
  }

  public function getName() {
    return 'ClientService_next_row_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->scanner);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_next_row_args');
    if ($this->scanner !== null) {
      $xfer += $output->writeFieldBegin('scanner', TType::I64, 1);
      $xfer += $output->writeI64($this->scanner);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_next_row_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\Cell[]
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hypertable_ThriftGen\Cell',
            ),
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_next_row_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size116 = 0;
            $_etype119 = 0;
            $xfer += $input->readListBegin($_etype119, $_size116);
            for ($_i120 = 0; $_i120 < $_size116; ++$_i120)
            {
              $elem121 = null;
              $elem121 = new \Hypertable_ThriftGen\Cell();
              $xfer += $elem121->read($input);
              $this->success []= $elem121;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_next_row_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter122)
          {
            $xfer += $iter122->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_scanner_get_row_as_arrays_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $scanner = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'scanner',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['scanner'])) {
        $this->scanner = $vals['scanner'];
      }
    }
  }

  public function getName() {
    return 'ClientService_scanner_get_row_as_arrays_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->scanner);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_scanner_get_row_as_arrays_args');
    if ($this->scanner !== null) {
      $xfer += $output->writeFieldBegin('scanner', TType::I64, 1);
      $xfer += $output->writeI64($this->scanner);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_scanner_get_row_as_arrays_result {
  static $_TSPEC;

  /**
   * @var string[][]
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::LST,
          'elem' => array(
            'type' => TType::LST,
            'etype' => TType::STRING,
            'elem' => array(
              'type' => TType::STRING,
              ),
            ),
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_scanner_get_row_as_arrays_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size123 = 0;
            $_etype126 = 0;
            $xfer += $input->readListBegin($_etype126, $_size123);
            for ($_i127 = 0; $_i127 < $_size123; ++$_i127)
            {
              $elem128 = null;
              $elem128 = array();
              $_size129 = 0;
              $_etype132 = 0;
              $xfer += $input->readListBegin($_etype132, $_size129);
              for ($_i133 = 0; $_i133 < $_size129; ++$_i133)
              {
                $elem134 = null;
                $xfer += $input->readString($elem134);
                $elem128 []= $elem134;
              }
              $xfer += $input->readListEnd();
              $this->success []= $elem128;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_scanner_get_row_as_arrays_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::LST, count($this->success));
        {
          foreach ($this->success as $iter135)
          {
            {
              $output->writeListBegin(TType::STRING, count($iter135));
              {
                foreach ($iter135 as $iter136)
                {
                  $xfer += $output->writeString($iter136);
                }
              }
              $output->writeListEnd();
            }
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_next_row_as_arrays_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $scanner = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'scanner',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['scanner'])) {
        $this->scanner = $vals['scanner'];
      }
    }
  }

  public function getName() {
    return 'ClientService_next_row_as_arrays_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->scanner);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_next_row_as_arrays_args');
    if ($this->scanner !== null) {
      $xfer += $output->writeFieldBegin('scanner', TType::I64, 1);
      $xfer += $output->writeI64($this->scanner);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_next_row_as_arrays_result {
  static $_TSPEC;

  /**
   * @var string[][]
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::LST,
          'elem' => array(
            'type' => TType::LST,
            'etype' => TType::STRING,
            'elem' => array(
              'type' => TType::STRING,
              ),
            ),
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_next_row_as_arrays_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size137 = 0;
            $_etype140 = 0;
            $xfer += $input->readListBegin($_etype140, $_size137);
            for ($_i141 = 0; $_i141 < $_size137; ++$_i141)
            {
              $elem142 = null;
              $elem142 = array();
              $_size143 = 0;
              $_etype146 = 0;
              $xfer += $input->readListBegin($_etype146, $_size143);
              for ($_i147 = 0; $_i147 < $_size143; ++$_i147)
              {
                $elem148 = null;
                $xfer += $input->readString($elem148);
                $elem142 []= $elem148;
              }
              $xfer += $input->readListEnd();
              $this->success []= $elem142;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_next_row_as_arrays_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::LST, count($this->success));
        {
          foreach ($this->success as $iter149)
          {
            {
              $output->writeListBegin(TType::STRING, count($iter149));
              {
                foreach ($iter149 as $iter150)
                {
                  $xfer += $output->writeString($iter150);
                }
              }
              $output->writeListEnd();
            }
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_scanner_get_row_serialized_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $scanner = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'scanner',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['scanner'])) {
        $this->scanner = $vals['scanner'];
      }
    }
  }

  public function getName() {
    return 'ClientService_scanner_get_row_serialized_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->scanner);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_scanner_get_row_serialized_args');
    if ($this->scanner !== null) {
      $xfer += $output->writeFieldBegin('scanner', TType::I64, 1);
      $xfer += $output->writeI64($this->scanner);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_scanner_get_row_serialized_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_scanner_get_row_serialized_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_scanner_get_row_serialized_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_next_row_serialized_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $scanner = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'scanner',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['scanner'])) {
        $this->scanner = $vals['scanner'];
      }
    }
  }

  public function getName() {
    return 'ClientService_next_row_serialized_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->scanner);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_next_row_serialized_args');
    if ($this->scanner !== null) {
      $xfer += $output->writeFieldBegin('scanner', TType::I64, 1);
      $xfer += $output->writeI64($this->scanner);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_next_row_serialized_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_next_row_serialized_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_next_row_serialized_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_row_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var string
   */
  public $row = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'row',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['row'])) {
        $this->row = $vals['row'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_row_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->row);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_row_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->row !== null) {
      $xfer += $output->writeFieldBegin('row', TType::STRING, 3);
      $xfer += $output->writeString($this->row);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_row_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\Cell[]
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hypertable_ThriftGen\Cell',
            ),
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_row_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size151 = 0;
            $_etype154 = 0;
            $xfer += $input->readListBegin($_etype154, $_size151);
            for ($_i155 = 0; $_i155 < $_size151; ++$_i155)
            {
              $elem156 = null;
              $elem156 = new \Hypertable_ThriftGen\Cell();
              $xfer += $elem156->read($input);
              $this->success []= $elem156;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_row_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter157)
          {
            $xfer += $iter157->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_row_as_arrays_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $name = null;
  /**
   * @var string
   */
  public $row = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'row',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
      if (isset($vals['row'])) {
        $this->row = $vals['row'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_row_as_arrays_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->row);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_row_as_arrays_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 2);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->row !== null) {
      $xfer += $output->writeFieldBegin('row', TType::STRING, 3);
      $xfer += $output->writeString($this->row);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_row_as_arrays_result {
  static $_TSPEC;

  /**
   * @var string[][]
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::LST,
          'elem' => array(
            'type' => TType::LST,
            'etype' => TType::STRING,
            'elem' => array(
              'type' => TType::STRING,
              ),
            ),
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_row_as_arrays_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size158 = 0;
            $_etype161 = 0;
            $xfer += $input->readListBegin($_etype161, $_size158);
            for ($_i162 = 0; $_i162 < $_size158; ++$_i162)
            {
              $elem163 = null;
              $elem163 = array();
              $_size164 = 0;
              $_etype167 = 0;
              $xfer += $input->readListBegin($_etype167, $_size164);
              for ($_i168 = 0; $_i168 < $_size164; ++$_i168)
              {
                $elem169 = null;
                $xfer += $input->readString($elem169);
                $elem163 []= $elem169;
              }
              $xfer += $input->readListEnd();
              $this->success []= $elem163;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_row_as_arrays_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::LST, count($this->success));
        {
          foreach ($this->success as $iter170)
          {
            {
              $output->writeListBegin(TType::STRING, count($iter170));
              {
                foreach ($iter170 as $iter171)
                {
                  $xfer += $output->writeString($iter171);
                }
              }
              $output->writeListEnd();
            }
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_row_serialized_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var string
   */
  public $row = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'row',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['row'])) {
        $this->row = $vals['row'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_row_serialized_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->row);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_row_serialized_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->row !== null) {
      $xfer += $output->writeFieldBegin('row', TType::STRING, 3);
      $xfer += $output->writeString($this->row);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_row_serialized_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_row_serialized_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_row_serialized_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_cell_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var string
   */
  public $row = null;
  /**
   * @var string
   */
  public $column = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'row',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'column',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['row'])) {
        $this->row = $vals['row'];
      }
      if (isset($vals['column'])) {
        $this->column = $vals['column'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_cell_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->row);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->column);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_cell_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->row !== null) {
      $xfer += $output->writeFieldBegin('row', TType::STRING, 3);
      $xfer += $output->writeString($this->row);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->column !== null) {
      $xfer += $output->writeFieldBegin('column', TType::STRING, 4);
      $xfer += $output->writeString($this->column);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_cell_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_cell_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_cell_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_cells_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var \Hypertable_ThriftGen\ScanSpec
   */
  public $scan_spec = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'scan_spec',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ScanSpec',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['scan_spec'])) {
        $this->scan_spec = $vals['scan_spec'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_cells_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->scan_spec = new \Hypertable_ThriftGen\ScanSpec();
            $xfer += $this->scan_spec->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_cells_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->scan_spec !== null) {
      if (!is_object($this->scan_spec)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('scan_spec', TType::STRUCT, 3);
      $xfer += $this->scan_spec->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_cells_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\Cell[]
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hypertable_ThriftGen\Cell',
            ),
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_cells_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size172 = 0;
            $_etype175 = 0;
            $xfer += $input->readListBegin($_etype175, $_size172);
            for ($_i176 = 0; $_i176 < $_size172; ++$_i176)
            {
              $elem177 = null;
              $elem177 = new \Hypertable_ThriftGen\Cell();
              $xfer += $elem177->read($input);
              $this->success []= $elem177;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_cells_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter178)
          {
            $xfer += $iter178->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_cells_as_arrays_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $name = null;
  /**
   * @var \Hypertable_ThriftGen\ScanSpec
   */
  public $scan_spec = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'scan_spec',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ScanSpec',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
      if (isset($vals['scan_spec'])) {
        $this->scan_spec = $vals['scan_spec'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_cells_as_arrays_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->scan_spec = new \Hypertable_ThriftGen\ScanSpec();
            $xfer += $this->scan_spec->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_cells_as_arrays_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 2);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->scan_spec !== null) {
      if (!is_object($this->scan_spec)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('scan_spec', TType::STRUCT, 3);
      $xfer += $this->scan_spec->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_cells_as_arrays_result {
  static $_TSPEC;

  /**
   * @var string[][]
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::LST,
          'elem' => array(
            'type' => TType::LST,
            'etype' => TType::STRING,
            'elem' => array(
              'type' => TType::STRING,
              ),
            ),
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_cells_as_arrays_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size179 = 0;
            $_etype182 = 0;
            $xfer += $input->readListBegin($_etype182, $_size179);
            for ($_i183 = 0; $_i183 < $_size179; ++$_i183)
            {
              $elem184 = null;
              $elem184 = array();
              $_size185 = 0;
              $_etype188 = 0;
              $xfer += $input->readListBegin($_etype188, $_size185);
              for ($_i189 = 0; $_i189 < $_size185; ++$_i189)
              {
                $elem190 = null;
                $xfer += $input->readString($elem190);
                $elem184 []= $elem190;
              }
              $xfer += $input->readListEnd();
              $this->success []= $elem184;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_cells_as_arrays_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::LST, count($this->success));
        {
          foreach ($this->success as $iter191)
          {
            {
              $output->writeListBegin(TType::STRING, count($iter191));
              {
                foreach ($iter191 as $iter192)
                {
                  $xfer += $output->writeString($iter192);
                }
              }
              $output->writeListEnd();
            }
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_cells_serialized_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $name = null;
  /**
   * @var \Hypertable_ThriftGen\ScanSpec
   */
  public $scan_spec = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'scan_spec',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ScanSpec',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
      if (isset($vals['scan_spec'])) {
        $this->scan_spec = $vals['scan_spec'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_cells_serialized_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->scan_spec = new \Hypertable_ThriftGen\ScanSpec();
            $xfer += $this->scan_spec->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_cells_serialized_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 2);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->scan_spec !== null) {
      if (!is_object($this->scan_spec)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('scan_spec', TType::STRUCT, 3);
      $xfer += $this->scan_spec->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_cells_serialized_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_cells_serialized_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_cells_serialized_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_shared_mutator_refresh_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var \Hypertable_ThriftGen\MutateSpec
   */
  public $mutate_spec = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'mutate_spec',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\MutateSpec',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['mutate_spec'])) {
        $this->mutate_spec = $vals['mutate_spec'];
      }
    }
  }

  public function getName() {
    return 'ClientService_shared_mutator_refresh_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->mutate_spec = new \Hypertable_ThriftGen\MutateSpec();
            $xfer += $this->mutate_spec->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_shared_mutator_refresh_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->mutate_spec !== null) {
      if (!is_object($this->mutate_spec)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('mutate_spec', TType::STRUCT, 3);
      $xfer += $this->mutate_spec->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_shared_mutator_refresh_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_shared_mutator_refresh_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_shared_mutator_refresh_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_refresh_shared_mutator_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var \Hypertable_ThriftGen\MutateSpec
   */
  public $mutate_spec = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'mutate_spec',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\MutateSpec',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['mutate_spec'])) {
        $this->mutate_spec = $vals['mutate_spec'];
      }
    }
  }

  public function getName() {
    return 'ClientService_refresh_shared_mutator_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->mutate_spec = new \Hypertable_ThriftGen\MutateSpec();
            $xfer += $this->mutate_spec->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_refresh_shared_mutator_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->mutate_spec !== null) {
      if (!is_object($this->mutate_spec)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('mutate_spec', TType::STRUCT, 3);
      $xfer += $this->mutate_spec->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_refresh_shared_mutator_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_refresh_shared_mutator_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_refresh_shared_mutator_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_shared_mutator_set_cells_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var \Hypertable_ThriftGen\MutateSpec
   */
  public $mutate_spec = null;
  /**
   * @var \Hypertable_ThriftGen\Cell[]
   */
  public $cells = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'mutate_spec',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\MutateSpec',
          ),
        4 => array(
          'var' => 'cells',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hypertable_ThriftGen\Cell',
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['mutate_spec'])) {
        $this->mutate_spec = $vals['mutate_spec'];
      }
      if (isset($vals['cells'])) {
        $this->cells = $vals['cells'];
      }
    }
  }

  public function getName() {
    return 'ClientService_shared_mutator_set_cells_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->mutate_spec = new \Hypertable_ThriftGen\MutateSpec();
            $xfer += $this->mutate_spec->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::LST) {
            $this->cells = array();
            $_size193 = 0;
            $_etype196 = 0;
            $xfer += $input->readListBegin($_etype196, $_size193);
            for ($_i197 = 0; $_i197 < $_size193; ++$_i197)
            {
              $elem198 = null;
              $elem198 = new \Hypertable_ThriftGen\Cell();
              $xfer += $elem198->read($input);
              $this->cells []= $elem198;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_shared_mutator_set_cells_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->mutate_spec !== null) {
      if (!is_object($this->mutate_spec)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('mutate_spec', TType::STRUCT, 3);
      $xfer += $this->mutate_spec->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cells !== null) {
      if (!is_array($this->cells)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('cells', TType::LST, 4);
      {
        $output->writeListBegin(TType::STRUCT, count($this->cells));
        {
          foreach ($this->cells as $iter199)
          {
            $xfer += $iter199->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_shared_mutator_set_cells_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_shared_mutator_set_cells_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_shared_mutator_set_cells_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_offer_cells_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var \Hypertable_ThriftGen\MutateSpec
   */
  public $mutate_spec = null;
  /**
   * @var \Hypertable_ThriftGen\Cell[]
   */
  public $cells = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'mutate_spec',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\MutateSpec',
          ),
        4 => array(
          'var' => 'cells',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hypertable_ThriftGen\Cell',
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['mutate_spec'])) {
        $this->mutate_spec = $vals['mutate_spec'];
      }
      if (isset($vals['cells'])) {
        $this->cells = $vals['cells'];
      }
    }
  }

  public function getName() {
    return 'ClientService_offer_cells_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->mutate_spec = new \Hypertable_ThriftGen\MutateSpec();
            $xfer += $this->mutate_spec->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::LST) {
            $this->cells = array();
            $_size200 = 0;
            $_etype203 = 0;
            $xfer += $input->readListBegin($_etype203, $_size200);
            for ($_i204 = 0; $_i204 < $_size200; ++$_i204)
            {
              $elem205 = null;
              $elem205 = new \Hypertable_ThriftGen\Cell();
              $xfer += $elem205->read($input);
              $this->cells []= $elem205;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_offer_cells_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->mutate_spec !== null) {
      if (!is_object($this->mutate_spec)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('mutate_spec', TType::STRUCT, 3);
      $xfer += $this->mutate_spec->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cells !== null) {
      if (!is_array($this->cells)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('cells', TType::LST, 4);
      {
        $output->writeListBegin(TType::STRUCT, count($this->cells));
        {
          foreach ($this->cells as $iter206)
          {
            $xfer += $iter206->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_offer_cells_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_offer_cells_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_offer_cells_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_shared_mutator_set_cells_as_arrays_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var \Hypertable_ThriftGen\MutateSpec
   */
  public $mutate_spec = null;
  /**
   * @var string[][]
   */
  public $cells = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'mutate_spec',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\MutateSpec',
          ),
        4 => array(
          'var' => 'cells',
          'type' => TType::LST,
          'etype' => TType::LST,
          'elem' => array(
            'type' => TType::LST,
            'etype' => TType::STRING,
            'elem' => array(
              'type' => TType::STRING,
              ),
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['mutate_spec'])) {
        $this->mutate_spec = $vals['mutate_spec'];
      }
      if (isset($vals['cells'])) {
        $this->cells = $vals['cells'];
      }
    }
  }

  public function getName() {
    return 'ClientService_shared_mutator_set_cells_as_arrays_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->mutate_spec = new \Hypertable_ThriftGen\MutateSpec();
            $xfer += $this->mutate_spec->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::LST) {
            $this->cells = array();
            $_size207 = 0;
            $_etype210 = 0;
            $xfer += $input->readListBegin($_etype210, $_size207);
            for ($_i211 = 0; $_i211 < $_size207; ++$_i211)
            {
              $elem212 = null;
              $elem212 = array();
              $_size213 = 0;
              $_etype216 = 0;
              $xfer += $input->readListBegin($_etype216, $_size213);
              for ($_i217 = 0; $_i217 < $_size213; ++$_i217)
              {
                $elem218 = null;
                $xfer += $input->readString($elem218);
                $elem212 []= $elem218;
              }
              $xfer += $input->readListEnd();
              $this->cells []= $elem212;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_shared_mutator_set_cells_as_arrays_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->mutate_spec !== null) {
      if (!is_object($this->mutate_spec)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('mutate_spec', TType::STRUCT, 3);
      $xfer += $this->mutate_spec->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cells !== null) {
      if (!is_array($this->cells)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('cells', TType::LST, 4);
      {
        $output->writeListBegin(TType::LST, count($this->cells));
        {
          foreach ($this->cells as $iter219)
          {
            {
              $output->writeListBegin(TType::STRING, count($iter219));
              {
                foreach ($iter219 as $iter220)
                {
                  $xfer += $output->writeString($iter220);
                }
              }
              $output->writeListEnd();
            }
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_shared_mutator_set_cells_as_arrays_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_shared_mutator_set_cells_as_arrays_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_shared_mutator_set_cells_as_arrays_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_offer_cells_as_arrays_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var \Hypertable_ThriftGen\MutateSpec
   */
  public $mutate_spec = null;
  /**
   * @var string[][]
   */
  public $cells = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'mutate_spec',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\MutateSpec',
          ),
        4 => array(
          'var' => 'cells',
          'type' => TType::LST,
          'etype' => TType::LST,
          'elem' => array(
            'type' => TType::LST,
            'etype' => TType::STRING,
            'elem' => array(
              'type' => TType::STRING,
              ),
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['mutate_spec'])) {
        $this->mutate_spec = $vals['mutate_spec'];
      }
      if (isset($vals['cells'])) {
        $this->cells = $vals['cells'];
      }
    }
  }

  public function getName() {
    return 'ClientService_offer_cells_as_arrays_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->mutate_spec = new \Hypertable_ThriftGen\MutateSpec();
            $xfer += $this->mutate_spec->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::LST) {
            $this->cells = array();
            $_size221 = 0;
            $_etype224 = 0;
            $xfer += $input->readListBegin($_etype224, $_size221);
            for ($_i225 = 0; $_i225 < $_size221; ++$_i225)
            {
              $elem226 = null;
              $elem226 = array();
              $_size227 = 0;
              $_etype230 = 0;
              $xfer += $input->readListBegin($_etype230, $_size227);
              for ($_i231 = 0; $_i231 < $_size227; ++$_i231)
              {
                $elem232 = null;
                $xfer += $input->readString($elem232);
                $elem226 []= $elem232;
              }
              $xfer += $input->readListEnd();
              $this->cells []= $elem226;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_offer_cells_as_arrays_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->mutate_spec !== null) {
      if (!is_object($this->mutate_spec)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('mutate_spec', TType::STRUCT, 3);
      $xfer += $this->mutate_spec->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cells !== null) {
      if (!is_array($this->cells)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('cells', TType::LST, 4);
      {
        $output->writeListBegin(TType::LST, count($this->cells));
        {
          foreach ($this->cells as $iter233)
          {
            {
              $output->writeListBegin(TType::STRING, count($iter233));
              {
                foreach ($iter233 as $iter234)
                {
                  $xfer += $output->writeString($iter234);
                }
              }
              $output->writeListEnd();
            }
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_offer_cells_as_arrays_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_offer_cells_as_arrays_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_offer_cells_as_arrays_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_shared_mutator_set_cell_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var \Hypertable_ThriftGen\MutateSpec
   */
  public $mutate_spec = null;
  /**
   * @var \Hypertable_ThriftGen\Cell
   */
  public $cell = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'mutate_spec',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\MutateSpec',
          ),
        4 => array(
          'var' => 'cell',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\Cell',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['mutate_spec'])) {
        $this->mutate_spec = $vals['mutate_spec'];
      }
      if (isset($vals['cell'])) {
        $this->cell = $vals['cell'];
      }
    }
  }

  public function getName() {
    return 'ClientService_shared_mutator_set_cell_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->mutate_spec = new \Hypertable_ThriftGen\MutateSpec();
            $xfer += $this->mutate_spec->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->cell = new \Hypertable_ThriftGen\Cell();
            $xfer += $this->cell->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_shared_mutator_set_cell_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->mutate_spec !== null) {
      if (!is_object($this->mutate_spec)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('mutate_spec', TType::STRUCT, 3);
      $xfer += $this->mutate_spec->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cell !== null) {
      if (!is_object($this->cell)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('cell', TType::STRUCT, 4);
      $xfer += $this->cell->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_shared_mutator_set_cell_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_shared_mutator_set_cell_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_shared_mutator_set_cell_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_offer_cell_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var \Hypertable_ThriftGen\MutateSpec
   */
  public $mutate_spec = null;
  /**
   * @var \Hypertable_ThriftGen\Cell
   */
  public $cell = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'mutate_spec',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\MutateSpec',
          ),
        4 => array(
          'var' => 'cell',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\Cell',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['mutate_spec'])) {
        $this->mutate_spec = $vals['mutate_spec'];
      }
      if (isset($vals['cell'])) {
        $this->cell = $vals['cell'];
      }
    }
  }

  public function getName() {
    return 'ClientService_offer_cell_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->mutate_spec = new \Hypertable_ThriftGen\MutateSpec();
            $xfer += $this->mutate_spec->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->cell = new \Hypertable_ThriftGen\Cell();
            $xfer += $this->cell->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_offer_cell_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->mutate_spec !== null) {
      if (!is_object($this->mutate_spec)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('mutate_spec', TType::STRUCT, 3);
      $xfer += $this->mutate_spec->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cell !== null) {
      if (!is_object($this->cell)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('cell', TType::STRUCT, 4);
      $xfer += $this->cell->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_offer_cell_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_offer_cell_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_offer_cell_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_shared_mutator_set_cell_as_array_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var \Hypertable_ThriftGen\MutateSpec
   */
  public $mutate_spec = null;
  /**
   * @var string[]
   */
  public $cell = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'mutate_spec',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\MutateSpec',
          ),
        4 => array(
          'var' => 'cell',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['mutate_spec'])) {
        $this->mutate_spec = $vals['mutate_spec'];
      }
      if (isset($vals['cell'])) {
        $this->cell = $vals['cell'];
      }
    }
  }

  public function getName() {
    return 'ClientService_shared_mutator_set_cell_as_array_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->mutate_spec = new \Hypertable_ThriftGen\MutateSpec();
            $xfer += $this->mutate_spec->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::LST) {
            $this->cell = array();
            $_size235 = 0;
            $_etype238 = 0;
            $xfer += $input->readListBegin($_etype238, $_size235);
            for ($_i239 = 0; $_i239 < $_size235; ++$_i239)
            {
              $elem240 = null;
              $xfer += $input->readString($elem240);
              $this->cell []= $elem240;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_shared_mutator_set_cell_as_array_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->mutate_spec !== null) {
      if (!is_object($this->mutate_spec)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('mutate_spec', TType::STRUCT, 3);
      $xfer += $this->mutate_spec->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cell !== null) {
      if (!is_array($this->cell)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('cell', TType::LST, 4);
      {
        $output->writeListBegin(TType::STRING, count($this->cell));
        {
          foreach ($this->cell as $iter241)
          {
            $xfer += $output->writeString($iter241);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_shared_mutator_set_cell_as_array_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_shared_mutator_set_cell_as_array_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_shared_mutator_set_cell_as_array_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_offer_cell_as_array_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var \Hypertable_ThriftGen\MutateSpec
   */
  public $mutate_spec = null;
  /**
   * @var string[]
   */
  public $cell = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'mutate_spec',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\MutateSpec',
          ),
        4 => array(
          'var' => 'cell',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['mutate_spec'])) {
        $this->mutate_spec = $vals['mutate_spec'];
      }
      if (isset($vals['cell'])) {
        $this->cell = $vals['cell'];
      }
    }
  }

  public function getName() {
    return 'ClientService_offer_cell_as_array_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->mutate_spec = new \Hypertable_ThriftGen\MutateSpec();
            $xfer += $this->mutate_spec->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::LST) {
            $this->cell = array();
            $_size242 = 0;
            $_etype245 = 0;
            $xfer += $input->readListBegin($_etype245, $_size242);
            for ($_i246 = 0; $_i246 < $_size242; ++$_i246)
            {
              $elem247 = null;
              $xfer += $input->readString($elem247);
              $this->cell []= $elem247;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_offer_cell_as_array_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->mutate_spec !== null) {
      if (!is_object($this->mutate_spec)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('mutate_spec', TType::STRUCT, 3);
      $xfer += $this->mutate_spec->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cell !== null) {
      if (!is_array($this->cell)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('cell', TType::LST, 4);
      {
        $output->writeListBegin(TType::STRING, count($this->cell));
        {
          foreach ($this->cell as $iter248)
          {
            $xfer += $output->writeString($iter248);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_offer_cell_as_array_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_offer_cell_as_array_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_offer_cell_as_array_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_mutator_open_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var int
   */
  public $flags = 0;
  /**
   * @var int
   */
  public $flush_interval = 0;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'flags',
          'type' => TType::I32,
          ),
        4 => array(
          'var' => 'flush_interval',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['flags'])) {
        $this->flags = $vals['flags'];
      }
      if (isset($vals['flush_interval'])) {
        $this->flush_interval = $vals['flush_interval'];
      }
    }
  }

  public function getName() {
    return 'ClientService_mutator_open_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->flags);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->flush_interval);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_mutator_open_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->flags !== null) {
      $xfer += $output->writeFieldBegin('flags', TType::I32, 3);
      $xfer += $output->writeI32($this->flags);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->flush_interval !== null) {
      $xfer += $output->writeFieldBegin('flush_interval', TType::I32, 4);
      $xfer += $output->writeI32($this->flush_interval);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_mutator_open_result {
  static $_TSPEC;

  /**
   * @var int
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::I64,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_mutator_open_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_mutator_open_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::I64, 0);
      $xfer += $output->writeI64($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_open_mutator_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var int
   */
  public $flags = 0;
  /**
   * @var int
   */
  public $flush_interval = 0;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'flags',
          'type' => TType::I32,
          ),
        4 => array(
          'var' => 'flush_interval',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['flags'])) {
        $this->flags = $vals['flags'];
      }
      if (isset($vals['flush_interval'])) {
        $this->flush_interval = $vals['flush_interval'];
      }
    }
  }

  public function getName() {
    return 'ClientService_open_mutator_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->flags);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->flush_interval);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_open_mutator_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->flags !== null) {
      $xfer += $output->writeFieldBegin('flags', TType::I32, 3);
      $xfer += $output->writeI32($this->flags);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->flush_interval !== null) {
      $xfer += $output->writeFieldBegin('flush_interval', TType::I32, 4);
      $xfer += $output->writeI32($this->flush_interval);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_open_mutator_result {
  static $_TSPEC;

  /**
   * @var int
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::I64,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_open_mutator_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_open_mutator_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::I64, 0);
      $xfer += $output->writeI64($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_async_mutator_open_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var int
   */
  public $future = null;
  /**
   * @var int
   */
  public $flags = 0;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'future',
          'type' => TType::I64,
          ),
        4 => array(
          'var' => 'flags',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['future'])) {
        $this->future = $vals['future'];
      }
      if (isset($vals['flags'])) {
        $this->flags = $vals['flags'];
      }
    }
  }

  public function getName() {
    return 'ClientService_async_mutator_open_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->future);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->flags);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_async_mutator_open_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->future !== null) {
      $xfer += $output->writeFieldBegin('future', TType::I64, 3);
      $xfer += $output->writeI64($this->future);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->flags !== null) {
      $xfer += $output->writeFieldBegin('flags', TType::I32, 4);
      $xfer += $output->writeI32($this->flags);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_async_mutator_open_result {
  static $_TSPEC;

  /**
   * @var int
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::I64,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_async_mutator_open_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_async_mutator_open_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::I64, 0);
      $xfer += $output->writeI64($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_open_mutator_async_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var int
   */
  public $future = null;
  /**
   * @var int
   */
  public $flags = 0;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'future',
          'type' => TType::I64,
          ),
        4 => array(
          'var' => 'flags',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['future'])) {
        $this->future = $vals['future'];
      }
      if (isset($vals['flags'])) {
        $this->flags = $vals['flags'];
      }
    }
  }

  public function getName() {
    return 'ClientService_open_mutator_async_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->future);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->flags);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_open_mutator_async_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->future !== null) {
      $xfer += $output->writeFieldBegin('future', TType::I64, 3);
      $xfer += $output->writeI64($this->future);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->flags !== null) {
      $xfer += $output->writeFieldBegin('flags', TType::I32, 4);
      $xfer += $output->writeI32($this->flags);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_open_mutator_async_result {
  static $_TSPEC;

  /**
   * @var int
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::I64,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_open_mutator_async_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_open_mutator_async_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::I64, 0);
      $xfer += $output->writeI64($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_mutator_close_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $mutator = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'mutator',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['mutator'])) {
        $this->mutator = $vals['mutator'];
      }
    }
  }

  public function getName() {
    return 'ClientService_mutator_close_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->mutator);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_mutator_close_args');
    if ($this->mutator !== null) {
      $xfer += $output->writeFieldBegin('mutator', TType::I64, 1);
      $xfer += $output->writeI64($this->mutator);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_mutator_close_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_mutator_close_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_mutator_close_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_close_mutator_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $mutator = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'mutator',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['mutator'])) {
        $this->mutator = $vals['mutator'];
      }
    }
  }

  public function getName() {
    return 'ClientService_close_mutator_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->mutator);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_close_mutator_args');
    if ($this->mutator !== null) {
      $xfer += $output->writeFieldBegin('mutator', TType::I64, 1);
      $xfer += $output->writeI64($this->mutator);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_close_mutator_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_close_mutator_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_close_mutator_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_async_mutator_cancel_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $mutator = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'mutator',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['mutator'])) {
        $this->mutator = $vals['mutator'];
      }
    }
  }

  public function getName() {
    return 'ClientService_async_mutator_cancel_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->mutator);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_async_mutator_cancel_args');
    if ($this->mutator !== null) {
      $xfer += $output->writeFieldBegin('mutator', TType::I64, 1);
      $xfer += $output->writeI64($this->mutator);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_async_mutator_cancel_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_async_mutator_cancel_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_async_mutator_cancel_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_cancel_mutator_async_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $mutator = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'mutator',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['mutator'])) {
        $this->mutator = $vals['mutator'];
      }
    }
  }

  public function getName() {
    return 'ClientService_cancel_mutator_async_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->mutator);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_cancel_mutator_async_args');
    if ($this->mutator !== null) {
      $xfer += $output->writeFieldBegin('mutator', TType::I64, 1);
      $xfer += $output->writeI64($this->mutator);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_cancel_mutator_async_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_cancel_mutator_async_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_cancel_mutator_async_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_async_mutator_close_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $mutator = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'mutator',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['mutator'])) {
        $this->mutator = $vals['mutator'];
      }
    }
  }

  public function getName() {
    return 'ClientService_async_mutator_close_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->mutator);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_async_mutator_close_args');
    if ($this->mutator !== null) {
      $xfer += $output->writeFieldBegin('mutator', TType::I64, 1);
      $xfer += $output->writeI64($this->mutator);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_async_mutator_close_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_async_mutator_close_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_async_mutator_close_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_close_mutator_async_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $mutator = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'mutator',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['mutator'])) {
        $this->mutator = $vals['mutator'];
      }
    }
  }

  public function getName() {
    return 'ClientService_close_mutator_async_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->mutator);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_close_mutator_async_args');
    if ($this->mutator !== null) {
      $xfer += $output->writeFieldBegin('mutator', TType::I64, 1);
      $xfer += $output->writeI64($this->mutator);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_close_mutator_async_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_close_mutator_async_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_close_mutator_async_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_mutator_set_cell_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $mutator = null;
  /**
   * @var \Hypertable_ThriftGen\Cell
   */
  public $cell = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'mutator',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'cell',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\Cell',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['mutator'])) {
        $this->mutator = $vals['mutator'];
      }
      if (isset($vals['cell'])) {
        $this->cell = $vals['cell'];
      }
    }
  }

  public function getName() {
    return 'ClientService_mutator_set_cell_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->mutator);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->cell = new \Hypertable_ThriftGen\Cell();
            $xfer += $this->cell->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_mutator_set_cell_args');
    if ($this->mutator !== null) {
      $xfer += $output->writeFieldBegin('mutator', TType::I64, 1);
      $xfer += $output->writeI64($this->mutator);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cell !== null) {
      if (!is_object($this->cell)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('cell', TType::STRUCT, 2);
      $xfer += $this->cell->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_mutator_set_cell_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_mutator_set_cell_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_mutator_set_cell_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_set_cell_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var \Hypertable_ThriftGen\Cell
   */
  public $cell = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'cell',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\Cell',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['cell'])) {
        $this->cell = $vals['cell'];
      }
    }
  }

  public function getName() {
    return 'ClientService_set_cell_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->cell = new \Hypertable_ThriftGen\Cell();
            $xfer += $this->cell->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_set_cell_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cell !== null) {
      if (!is_object($this->cell)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('cell', TType::STRUCT, 3);
      $xfer += $this->cell->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_set_cell_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_set_cell_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_set_cell_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_mutator_set_cell_as_array_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $mutator = null;
  /**
   * @var string[]
   */
  public $cell = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'mutator',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'cell',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['mutator'])) {
        $this->mutator = $vals['mutator'];
      }
      if (isset($vals['cell'])) {
        $this->cell = $vals['cell'];
      }
    }
  }

  public function getName() {
    return 'ClientService_mutator_set_cell_as_array_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->mutator);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::LST) {
            $this->cell = array();
            $_size249 = 0;
            $_etype252 = 0;
            $xfer += $input->readListBegin($_etype252, $_size249);
            for ($_i253 = 0; $_i253 < $_size249; ++$_i253)
            {
              $elem254 = null;
              $xfer += $input->readString($elem254);
              $this->cell []= $elem254;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_mutator_set_cell_as_array_args');
    if ($this->mutator !== null) {
      $xfer += $output->writeFieldBegin('mutator', TType::I64, 1);
      $xfer += $output->writeI64($this->mutator);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cell !== null) {
      if (!is_array($this->cell)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('cell', TType::LST, 2);
      {
        $output->writeListBegin(TType::STRING, count($this->cell));
        {
          foreach ($this->cell as $iter255)
          {
            $xfer += $output->writeString($iter255);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_mutator_set_cell_as_array_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_mutator_set_cell_as_array_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_mutator_set_cell_as_array_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_set_cell_as_array_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var string[]
   */
  public $cell = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'cell',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['cell'])) {
        $this->cell = $vals['cell'];
      }
    }
  }

  public function getName() {
    return 'ClientService_set_cell_as_array_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->cell = array();
            $_size256 = 0;
            $_etype259 = 0;
            $xfer += $input->readListBegin($_etype259, $_size256);
            for ($_i260 = 0; $_i260 < $_size256; ++$_i260)
            {
              $elem261 = null;
              $xfer += $input->readString($elem261);
              $this->cell []= $elem261;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_set_cell_as_array_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cell !== null) {
      if (!is_array($this->cell)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('cell', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->cell));
        {
          foreach ($this->cell as $iter262)
          {
            $xfer += $output->writeString($iter262);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_set_cell_as_array_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_set_cell_as_array_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_set_cell_as_array_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_mutator_set_cells_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $mutator = null;
  /**
   * @var \Hypertable_ThriftGen\Cell[]
   */
  public $cells = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'mutator',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'cells',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hypertable_ThriftGen\Cell',
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['mutator'])) {
        $this->mutator = $vals['mutator'];
      }
      if (isset($vals['cells'])) {
        $this->cells = $vals['cells'];
      }
    }
  }

  public function getName() {
    return 'ClientService_mutator_set_cells_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->mutator);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::LST) {
            $this->cells = array();
            $_size263 = 0;
            $_etype266 = 0;
            $xfer += $input->readListBegin($_etype266, $_size263);
            for ($_i267 = 0; $_i267 < $_size263; ++$_i267)
            {
              $elem268 = null;
              $elem268 = new \Hypertable_ThriftGen\Cell();
              $xfer += $elem268->read($input);
              $this->cells []= $elem268;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_mutator_set_cells_args');
    if ($this->mutator !== null) {
      $xfer += $output->writeFieldBegin('mutator', TType::I64, 1);
      $xfer += $output->writeI64($this->mutator);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cells !== null) {
      if (!is_array($this->cells)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('cells', TType::LST, 2);
      {
        $output->writeListBegin(TType::STRUCT, count($this->cells));
        {
          foreach ($this->cells as $iter269)
          {
            $xfer += $iter269->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_mutator_set_cells_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_mutator_set_cells_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_mutator_set_cells_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_set_cells_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var \Hypertable_ThriftGen\Cell[]
   */
  public $cells = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'cells',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hypertable_ThriftGen\Cell',
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['cells'])) {
        $this->cells = $vals['cells'];
      }
    }
  }

  public function getName() {
    return 'ClientService_set_cells_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->cells = array();
            $_size270 = 0;
            $_etype273 = 0;
            $xfer += $input->readListBegin($_etype273, $_size270);
            for ($_i274 = 0; $_i274 < $_size270; ++$_i274)
            {
              $elem275 = null;
              $elem275 = new \Hypertable_ThriftGen\Cell();
              $xfer += $elem275->read($input);
              $this->cells []= $elem275;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_set_cells_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cells !== null) {
      if (!is_array($this->cells)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('cells', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRUCT, count($this->cells));
        {
          foreach ($this->cells as $iter276)
          {
            $xfer += $iter276->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_set_cells_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_set_cells_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_set_cells_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_mutator_set_cells_as_arrays_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $mutator = null;
  /**
   * @var string[][]
   */
  public $cells = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'mutator',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'cells',
          'type' => TType::LST,
          'etype' => TType::LST,
          'elem' => array(
            'type' => TType::LST,
            'etype' => TType::STRING,
            'elem' => array(
              'type' => TType::STRING,
              ),
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['mutator'])) {
        $this->mutator = $vals['mutator'];
      }
      if (isset($vals['cells'])) {
        $this->cells = $vals['cells'];
      }
    }
  }

  public function getName() {
    return 'ClientService_mutator_set_cells_as_arrays_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->mutator);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::LST) {
            $this->cells = array();
            $_size277 = 0;
            $_etype280 = 0;
            $xfer += $input->readListBegin($_etype280, $_size277);
            for ($_i281 = 0; $_i281 < $_size277; ++$_i281)
            {
              $elem282 = null;
              $elem282 = array();
              $_size283 = 0;
              $_etype286 = 0;
              $xfer += $input->readListBegin($_etype286, $_size283);
              for ($_i287 = 0; $_i287 < $_size283; ++$_i287)
              {
                $elem288 = null;
                $xfer += $input->readString($elem288);
                $elem282 []= $elem288;
              }
              $xfer += $input->readListEnd();
              $this->cells []= $elem282;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_mutator_set_cells_as_arrays_args');
    if ($this->mutator !== null) {
      $xfer += $output->writeFieldBegin('mutator', TType::I64, 1);
      $xfer += $output->writeI64($this->mutator);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cells !== null) {
      if (!is_array($this->cells)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('cells', TType::LST, 2);
      {
        $output->writeListBegin(TType::LST, count($this->cells));
        {
          foreach ($this->cells as $iter289)
          {
            {
              $output->writeListBegin(TType::STRING, count($iter289));
              {
                foreach ($iter289 as $iter290)
                {
                  $xfer += $output->writeString($iter290);
                }
              }
              $output->writeListEnd();
            }
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_mutator_set_cells_as_arrays_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_mutator_set_cells_as_arrays_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_mutator_set_cells_as_arrays_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_set_cells_as_arrays_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var string[][]
   */
  public $cells = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'cells',
          'type' => TType::LST,
          'etype' => TType::LST,
          'elem' => array(
            'type' => TType::LST,
            'etype' => TType::STRING,
            'elem' => array(
              'type' => TType::STRING,
              ),
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['cells'])) {
        $this->cells = $vals['cells'];
      }
    }
  }

  public function getName() {
    return 'ClientService_set_cells_as_arrays_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->cells = array();
            $_size291 = 0;
            $_etype294 = 0;
            $xfer += $input->readListBegin($_etype294, $_size291);
            for ($_i295 = 0; $_i295 < $_size291; ++$_i295)
            {
              $elem296 = null;
              $elem296 = array();
              $_size297 = 0;
              $_etype300 = 0;
              $xfer += $input->readListBegin($_etype300, $_size297);
              for ($_i301 = 0; $_i301 < $_size297; ++$_i301)
              {
                $elem302 = null;
                $xfer += $input->readString($elem302);
                $elem296 []= $elem302;
              }
              $xfer += $input->readListEnd();
              $this->cells []= $elem296;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_set_cells_as_arrays_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cells !== null) {
      if (!is_array($this->cells)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('cells', TType::LST, 3);
      {
        $output->writeListBegin(TType::LST, count($this->cells));
        {
          foreach ($this->cells as $iter303)
          {
            {
              $output->writeListBegin(TType::STRING, count($iter303));
              {
                foreach ($iter303 as $iter304)
                {
                  $xfer += $output->writeString($iter304);
                }
              }
              $output->writeListEnd();
            }
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_set_cells_as_arrays_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_set_cells_as_arrays_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_set_cells_as_arrays_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_mutator_set_cells_serialized_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $mutator = null;
  /**
   * @var string
   */
  public $cells = null;
  /**
   * @var bool
   */
  public $flush = false;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'mutator',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'cells',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'flush',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['mutator'])) {
        $this->mutator = $vals['mutator'];
      }
      if (isset($vals['cells'])) {
        $this->cells = $vals['cells'];
      }
      if (isset($vals['flush'])) {
        $this->flush = $vals['flush'];
      }
    }
  }

  public function getName() {
    return 'ClientService_mutator_set_cells_serialized_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->mutator);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->cells);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->flush);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_mutator_set_cells_serialized_args');
    if ($this->mutator !== null) {
      $xfer += $output->writeFieldBegin('mutator', TType::I64, 1);
      $xfer += $output->writeI64($this->mutator);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cells !== null) {
      $xfer += $output->writeFieldBegin('cells', TType::STRING, 2);
      $xfer += $output->writeString($this->cells);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->flush !== null) {
      $xfer += $output->writeFieldBegin('flush', TType::BOOL, 3);
      $xfer += $output->writeBool($this->flush);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_mutator_set_cells_serialized_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_mutator_set_cells_serialized_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_mutator_set_cells_serialized_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_set_cells_serialized_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var string
   */
  public $cells = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'cells',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['cells'])) {
        $this->cells = $vals['cells'];
      }
    }
  }

  public function getName() {
    return 'ClientService_set_cells_serialized_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->cells);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_set_cells_serialized_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cells !== null) {
      $xfer += $output->writeFieldBegin('cells', TType::STRING, 3);
      $xfer += $output->writeString($this->cells);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_set_cells_serialized_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_set_cells_serialized_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_set_cells_serialized_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_mutator_flush_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $mutator = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'mutator',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['mutator'])) {
        $this->mutator = $vals['mutator'];
      }
    }
  }

  public function getName() {
    return 'ClientService_mutator_flush_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->mutator);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_mutator_flush_args');
    if ($this->mutator !== null) {
      $xfer += $output->writeFieldBegin('mutator', TType::I64, 1);
      $xfer += $output->writeI64($this->mutator);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_mutator_flush_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_mutator_flush_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_mutator_flush_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_flush_mutator_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $mutator = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'mutator',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['mutator'])) {
        $this->mutator = $vals['mutator'];
      }
    }
  }

  public function getName() {
    return 'ClientService_flush_mutator_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->mutator);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_flush_mutator_args');
    if ($this->mutator !== null) {
      $xfer += $output->writeFieldBegin('mutator', TType::I64, 1);
      $xfer += $output->writeI64($this->mutator);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_flush_mutator_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_flush_mutator_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_flush_mutator_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_async_mutator_set_cell_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $mutator = null;
  /**
   * @var \Hypertable_ThriftGen\Cell
   */
  public $cell = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'mutator',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'cell',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\Cell',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['mutator'])) {
        $this->mutator = $vals['mutator'];
      }
      if (isset($vals['cell'])) {
        $this->cell = $vals['cell'];
      }
    }
  }

  public function getName() {
    return 'ClientService_async_mutator_set_cell_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->mutator);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->cell = new \Hypertable_ThriftGen\Cell();
            $xfer += $this->cell->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_async_mutator_set_cell_args');
    if ($this->mutator !== null) {
      $xfer += $output->writeFieldBegin('mutator', TType::I64, 1);
      $xfer += $output->writeI64($this->mutator);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cell !== null) {
      if (!is_object($this->cell)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('cell', TType::STRUCT, 2);
      $xfer += $this->cell->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_async_mutator_set_cell_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_async_mutator_set_cell_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_async_mutator_set_cell_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_set_cell_async_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $mutator = null;
  /**
   * @var \Hypertable_ThriftGen\Cell
   */
  public $cell = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'mutator',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'cell',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\Cell',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['mutator'])) {
        $this->mutator = $vals['mutator'];
      }
      if (isset($vals['cell'])) {
        $this->cell = $vals['cell'];
      }
    }
  }

  public function getName() {
    return 'ClientService_set_cell_async_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->mutator);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->cell = new \Hypertable_ThriftGen\Cell();
            $xfer += $this->cell->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_set_cell_async_args');
    if ($this->mutator !== null) {
      $xfer += $output->writeFieldBegin('mutator', TType::I64, 1);
      $xfer += $output->writeI64($this->mutator);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cell !== null) {
      if (!is_object($this->cell)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('cell', TType::STRUCT, 2);
      $xfer += $this->cell->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_set_cell_async_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_set_cell_async_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_set_cell_async_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_async_mutator_set_cell_as_array_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $mutator = null;
  /**
   * @var string[]
   */
  public $cell = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'mutator',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'cell',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['mutator'])) {
        $this->mutator = $vals['mutator'];
      }
      if (isset($vals['cell'])) {
        $this->cell = $vals['cell'];
      }
    }
  }

  public function getName() {
    return 'ClientService_async_mutator_set_cell_as_array_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->mutator);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::LST) {
            $this->cell = array();
            $_size305 = 0;
            $_etype308 = 0;
            $xfer += $input->readListBegin($_etype308, $_size305);
            for ($_i309 = 0; $_i309 < $_size305; ++$_i309)
            {
              $elem310 = null;
              $xfer += $input->readString($elem310);
              $this->cell []= $elem310;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_async_mutator_set_cell_as_array_args');
    if ($this->mutator !== null) {
      $xfer += $output->writeFieldBegin('mutator', TType::I64, 1);
      $xfer += $output->writeI64($this->mutator);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cell !== null) {
      if (!is_array($this->cell)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('cell', TType::LST, 2);
      {
        $output->writeListBegin(TType::STRING, count($this->cell));
        {
          foreach ($this->cell as $iter311)
          {
            $xfer += $output->writeString($iter311);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_async_mutator_set_cell_as_array_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_async_mutator_set_cell_as_array_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_async_mutator_set_cell_as_array_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_set_cell_as_array_async_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $mutator = null;
  /**
   * @var string[]
   */
  public $cell = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'mutator',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'cell',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['mutator'])) {
        $this->mutator = $vals['mutator'];
      }
      if (isset($vals['cell'])) {
        $this->cell = $vals['cell'];
      }
    }
  }

  public function getName() {
    return 'ClientService_set_cell_as_array_async_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->mutator);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::LST) {
            $this->cell = array();
            $_size312 = 0;
            $_etype315 = 0;
            $xfer += $input->readListBegin($_etype315, $_size312);
            for ($_i316 = 0; $_i316 < $_size312; ++$_i316)
            {
              $elem317 = null;
              $xfer += $input->readString($elem317);
              $this->cell []= $elem317;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_set_cell_as_array_async_args');
    if ($this->mutator !== null) {
      $xfer += $output->writeFieldBegin('mutator', TType::I64, 1);
      $xfer += $output->writeI64($this->mutator);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cell !== null) {
      if (!is_array($this->cell)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('cell', TType::LST, 2);
      {
        $output->writeListBegin(TType::STRING, count($this->cell));
        {
          foreach ($this->cell as $iter318)
          {
            $xfer += $output->writeString($iter318);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_set_cell_as_array_async_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_set_cell_as_array_async_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_set_cell_as_array_async_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_async_mutator_set_cells_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $mutator = null;
  /**
   * @var \Hypertable_ThriftGen\Cell[]
   */
  public $cells = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'mutator',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'cells',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hypertable_ThriftGen\Cell',
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['mutator'])) {
        $this->mutator = $vals['mutator'];
      }
      if (isset($vals['cells'])) {
        $this->cells = $vals['cells'];
      }
    }
  }

  public function getName() {
    return 'ClientService_async_mutator_set_cells_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->mutator);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::LST) {
            $this->cells = array();
            $_size319 = 0;
            $_etype322 = 0;
            $xfer += $input->readListBegin($_etype322, $_size319);
            for ($_i323 = 0; $_i323 < $_size319; ++$_i323)
            {
              $elem324 = null;
              $elem324 = new \Hypertable_ThriftGen\Cell();
              $xfer += $elem324->read($input);
              $this->cells []= $elem324;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_async_mutator_set_cells_args');
    if ($this->mutator !== null) {
      $xfer += $output->writeFieldBegin('mutator', TType::I64, 1);
      $xfer += $output->writeI64($this->mutator);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cells !== null) {
      if (!is_array($this->cells)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('cells', TType::LST, 2);
      {
        $output->writeListBegin(TType::STRUCT, count($this->cells));
        {
          foreach ($this->cells as $iter325)
          {
            $xfer += $iter325->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_async_mutator_set_cells_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_async_mutator_set_cells_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_async_mutator_set_cells_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_set_cells_async_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $mutator = null;
  /**
   * @var \Hypertable_ThriftGen\Cell[]
   */
  public $cells = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'mutator',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'cells',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hypertable_ThriftGen\Cell',
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['mutator'])) {
        $this->mutator = $vals['mutator'];
      }
      if (isset($vals['cells'])) {
        $this->cells = $vals['cells'];
      }
    }
  }

  public function getName() {
    return 'ClientService_set_cells_async_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->mutator);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::LST) {
            $this->cells = array();
            $_size326 = 0;
            $_etype329 = 0;
            $xfer += $input->readListBegin($_etype329, $_size326);
            for ($_i330 = 0; $_i330 < $_size326; ++$_i330)
            {
              $elem331 = null;
              $elem331 = new \Hypertable_ThriftGen\Cell();
              $xfer += $elem331->read($input);
              $this->cells []= $elem331;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_set_cells_async_args');
    if ($this->mutator !== null) {
      $xfer += $output->writeFieldBegin('mutator', TType::I64, 1);
      $xfer += $output->writeI64($this->mutator);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cells !== null) {
      if (!is_array($this->cells)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('cells', TType::LST, 2);
      {
        $output->writeListBegin(TType::STRUCT, count($this->cells));
        {
          foreach ($this->cells as $iter332)
          {
            $xfer += $iter332->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_set_cells_async_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_set_cells_async_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_set_cells_async_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_async_mutator_set_cells_as_arrays_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $mutator = null;
  /**
   * @var string[][]
   */
  public $cells = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'mutator',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'cells',
          'type' => TType::LST,
          'etype' => TType::LST,
          'elem' => array(
            'type' => TType::LST,
            'etype' => TType::STRING,
            'elem' => array(
              'type' => TType::STRING,
              ),
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['mutator'])) {
        $this->mutator = $vals['mutator'];
      }
      if (isset($vals['cells'])) {
        $this->cells = $vals['cells'];
      }
    }
  }

  public function getName() {
    return 'ClientService_async_mutator_set_cells_as_arrays_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->mutator);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::LST) {
            $this->cells = array();
            $_size333 = 0;
            $_etype336 = 0;
            $xfer += $input->readListBegin($_etype336, $_size333);
            for ($_i337 = 0; $_i337 < $_size333; ++$_i337)
            {
              $elem338 = null;
              $elem338 = array();
              $_size339 = 0;
              $_etype342 = 0;
              $xfer += $input->readListBegin($_etype342, $_size339);
              for ($_i343 = 0; $_i343 < $_size339; ++$_i343)
              {
                $elem344 = null;
                $xfer += $input->readString($elem344);
                $elem338 []= $elem344;
              }
              $xfer += $input->readListEnd();
              $this->cells []= $elem338;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_async_mutator_set_cells_as_arrays_args');
    if ($this->mutator !== null) {
      $xfer += $output->writeFieldBegin('mutator', TType::I64, 1);
      $xfer += $output->writeI64($this->mutator);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cells !== null) {
      if (!is_array($this->cells)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('cells', TType::LST, 2);
      {
        $output->writeListBegin(TType::LST, count($this->cells));
        {
          foreach ($this->cells as $iter345)
          {
            {
              $output->writeListBegin(TType::STRING, count($iter345));
              {
                foreach ($iter345 as $iter346)
                {
                  $xfer += $output->writeString($iter346);
                }
              }
              $output->writeListEnd();
            }
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_async_mutator_set_cells_as_arrays_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_async_mutator_set_cells_as_arrays_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_async_mutator_set_cells_as_arrays_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_set_cells_as_arrays_async_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $mutator = null;
  /**
   * @var string[][]
   */
  public $cells = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'mutator',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'cells',
          'type' => TType::LST,
          'etype' => TType::LST,
          'elem' => array(
            'type' => TType::LST,
            'etype' => TType::STRING,
            'elem' => array(
              'type' => TType::STRING,
              ),
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['mutator'])) {
        $this->mutator = $vals['mutator'];
      }
      if (isset($vals['cells'])) {
        $this->cells = $vals['cells'];
      }
    }
  }

  public function getName() {
    return 'ClientService_set_cells_as_arrays_async_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->mutator);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::LST) {
            $this->cells = array();
            $_size347 = 0;
            $_etype350 = 0;
            $xfer += $input->readListBegin($_etype350, $_size347);
            for ($_i351 = 0; $_i351 < $_size347; ++$_i351)
            {
              $elem352 = null;
              $elem352 = array();
              $_size353 = 0;
              $_etype356 = 0;
              $xfer += $input->readListBegin($_etype356, $_size353);
              for ($_i357 = 0; $_i357 < $_size353; ++$_i357)
              {
                $elem358 = null;
                $xfer += $input->readString($elem358);
                $elem352 []= $elem358;
              }
              $xfer += $input->readListEnd();
              $this->cells []= $elem352;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_set_cells_as_arrays_async_args');
    if ($this->mutator !== null) {
      $xfer += $output->writeFieldBegin('mutator', TType::I64, 1);
      $xfer += $output->writeI64($this->mutator);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cells !== null) {
      if (!is_array($this->cells)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('cells', TType::LST, 2);
      {
        $output->writeListBegin(TType::LST, count($this->cells));
        {
          foreach ($this->cells as $iter359)
          {
            {
              $output->writeListBegin(TType::STRING, count($iter359));
              {
                foreach ($iter359 as $iter360)
                {
                  $xfer += $output->writeString($iter360);
                }
              }
              $output->writeListEnd();
            }
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_set_cells_as_arrays_async_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_set_cells_as_arrays_async_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_set_cells_as_arrays_async_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_async_mutator_set_cells_serialized_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $mutator = null;
  /**
   * @var string
   */
  public $cells = null;
  /**
   * @var bool
   */
  public $flush = false;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'mutator',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'cells',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'flush',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['mutator'])) {
        $this->mutator = $vals['mutator'];
      }
      if (isset($vals['cells'])) {
        $this->cells = $vals['cells'];
      }
      if (isset($vals['flush'])) {
        $this->flush = $vals['flush'];
      }
    }
  }

  public function getName() {
    return 'ClientService_async_mutator_set_cells_serialized_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->mutator);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->cells);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->flush);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_async_mutator_set_cells_serialized_args');
    if ($this->mutator !== null) {
      $xfer += $output->writeFieldBegin('mutator', TType::I64, 1);
      $xfer += $output->writeI64($this->mutator);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cells !== null) {
      $xfer += $output->writeFieldBegin('cells', TType::STRING, 2);
      $xfer += $output->writeString($this->cells);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->flush !== null) {
      $xfer += $output->writeFieldBegin('flush', TType::BOOL, 3);
      $xfer += $output->writeBool($this->flush);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_async_mutator_set_cells_serialized_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_async_mutator_set_cells_serialized_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_async_mutator_set_cells_serialized_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_set_cells_serialized_async_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $mutator = null;
  /**
   * @var string
   */
  public $cells = null;
  /**
   * @var bool
   */
  public $flush = false;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'mutator',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'cells',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'flush',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['mutator'])) {
        $this->mutator = $vals['mutator'];
      }
      if (isset($vals['cells'])) {
        $this->cells = $vals['cells'];
      }
      if (isset($vals['flush'])) {
        $this->flush = $vals['flush'];
      }
    }
  }

  public function getName() {
    return 'ClientService_set_cells_serialized_async_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->mutator);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->cells);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->flush);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_set_cells_serialized_async_args');
    if ($this->mutator !== null) {
      $xfer += $output->writeFieldBegin('mutator', TType::I64, 1);
      $xfer += $output->writeI64($this->mutator);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cells !== null) {
      $xfer += $output->writeFieldBegin('cells', TType::STRING, 2);
      $xfer += $output->writeString($this->cells);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->flush !== null) {
      $xfer += $output->writeFieldBegin('flush', TType::BOOL, 3);
      $xfer += $output->writeBool($this->flush);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_set_cells_serialized_async_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_set_cells_serialized_async_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_set_cells_serialized_async_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_async_mutator_flush_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $mutator = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'mutator',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['mutator'])) {
        $this->mutator = $vals['mutator'];
      }
    }
  }

  public function getName() {
    return 'ClientService_async_mutator_flush_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->mutator);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_async_mutator_flush_args');
    if ($this->mutator !== null) {
      $xfer += $output->writeFieldBegin('mutator', TType::I64, 1);
      $xfer += $output->writeI64($this->mutator);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_async_mutator_flush_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_async_mutator_flush_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_async_mutator_flush_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_flush_mutator_async_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $mutator = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'mutator',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['mutator'])) {
        $this->mutator = $vals['mutator'];
      }
    }
  }

  public function getName() {
    return 'ClientService_flush_mutator_async_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->mutator);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_flush_mutator_async_args');
    if ($this->mutator !== null) {
      $xfer += $output->writeFieldBegin('mutator', TType::I64, 1);
      $xfer += $output->writeI64($this->mutator);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_flush_mutator_async_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_flush_mutator_async_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_flush_mutator_async_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_namespace_exists_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $ns = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
    }
  }

  public function getName() {
    return 'ClientService_namespace_exists_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_namespace_exists_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::STRING, 1);
      $xfer += $output->writeString($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_namespace_exists_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_namespace_exists_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_namespace_exists_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_exists_namespace_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $ns = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
    }
  }

  public function getName() {
    return 'ClientService_exists_namespace_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_exists_namespace_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::STRING, 1);
      $xfer += $output->writeString($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_exists_namespace_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_exists_namespace_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_exists_namespace_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_exists_table_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
    }
  }

  public function getName() {
    return 'ClientService_exists_table_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_exists_table_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 2);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_exists_table_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_exists_table_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_exists_table_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_table_exists_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
    }
  }

  public function getName() {
    return 'ClientService_table_exists_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_table_exists_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 2);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_table_exists_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_table_exists_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_table_exists_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_table_get_id_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
    }
  }

  public function getName() {
    return 'ClientService_table_get_id_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_table_get_id_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_table_get_id_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_table_get_id_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_table_get_id_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_table_id_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_table_id_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_table_id_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_table_id_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_table_id_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_table_id_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_table_get_schema_str_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
    }
  }

  public function getName() {
    return 'ClientService_table_get_schema_str_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_table_get_schema_str_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_table_get_schema_str_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_table_get_schema_str_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_table_get_schema_str_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_schema_str_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_schema_str_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_schema_str_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_schema_str_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_schema_str_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_schema_str_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_table_get_schema_str_with_ids_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
    }
  }

  public function getName() {
    return 'ClientService_table_get_schema_str_with_ids_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_table_get_schema_str_with_ids_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_table_get_schema_str_with_ids_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_table_get_schema_str_with_ids_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_table_get_schema_str_with_ids_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_schema_str_with_ids_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_schema_str_with_ids_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_schema_str_with_ids_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_schema_str_with_ids_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_schema_str_with_ids_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_schema_str_with_ids_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_table_get_schema_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
    }
  }

  public function getName() {
    return 'ClientService_table_get_schema_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_table_get_schema_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_table_get_schema_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\Schema
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\Schema',
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_table_get_schema_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Hypertable_ThriftGen\Schema();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_table_get_schema_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_schema_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_schema_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_schema_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_schema_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\Schema
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\Schema',
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_schema_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Hypertable_ThriftGen\Schema();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_schema_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_tables_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_tables_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_tables_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_tables_result {
  static $_TSPEC;

  /**
   * @var string[]
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_tables_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size361 = 0;
            $_etype364 = 0;
            $xfer += $input->readListBegin($_etype364, $_size361);
            for ($_i365 = 0; $_i365 < $_size361; ++$_i365)
            {
              $elem366 = null;
              $xfer += $input->readString($elem366);
              $this->success []= $elem366;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_tables_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter367)
          {
            $xfer += $output->writeString($iter367);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_namespace_get_listing_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
    }
  }

  public function getName() {
    return 'ClientService_namespace_get_listing_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_namespace_get_listing_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_namespace_get_listing_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\NamespaceListing[]
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hypertable_ThriftGen\NamespaceListing',
            ),
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_namespace_get_listing_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size368 = 0;
            $_etype371 = 0;
            $xfer += $input->readListBegin($_etype371, $_size368);
            for ($_i372 = 0; $_i372 < $_size368; ++$_i372)
            {
              $elem373 = null;
              $elem373 = new \Hypertable_ThriftGen\NamespaceListing();
              $xfer += $elem373->read($input);
              $this->success []= $elem373;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_namespace_get_listing_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter374)
          {
            $xfer += $iter374->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_listing_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_listing_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_listing_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_listing_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\NamespaceListing[]
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hypertable_ThriftGen\NamespaceListing',
            ),
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_listing_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size375 = 0;
            $_etype378 = 0;
            $xfer += $input->readListBegin($_etype378, $_size375);
            for ($_i379 = 0; $_i379 < $_size375; ++$_i379)
            {
              $elem380 = null;
              $elem380 = new \Hypertable_ThriftGen\NamespaceListing();
              $xfer += $elem380->read($input);
              $this->success []= $elem380;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_listing_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter381)
          {
            $xfer += $iter381->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_table_get_splits_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
    }
  }

  public function getName() {
    return 'ClientService_table_get_splits_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_table_get_splits_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_table_get_splits_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\TableSplit[]
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hypertable_ThriftGen\TableSplit',
            ),
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_table_get_splits_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size382 = 0;
            $_etype385 = 0;
            $xfer += $input->readListBegin($_etype385, $_size382);
            for ($_i386 = 0; $_i386 < $_size382; ++$_i386)
            {
              $elem387 = null;
              $elem387 = new \Hypertable_ThriftGen\TableSplit();
              $xfer += $elem387->read($input);
              $this->success []= $elem387;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_table_get_splits_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter388)
          {
            $xfer += $iter388->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_table_splits_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_table_splits_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_table_splits_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_get_table_splits_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\TableSplit[]
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Hypertable_ThriftGen\TableSplit',
            ),
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_get_table_splits_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size389 = 0;
            $_etype392 = 0;
            $xfer += $input->readListBegin($_etype392, $_size389);
            for ($_i393 = 0; $_i393 < $_size389; ++$_i393)
            {
              $elem394 = null;
              $elem394 = new \Hypertable_ThriftGen\TableSplit();
              $xfer += $elem394->read($input);
              $this->success []= $elem394;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_get_table_splits_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter395)
          {
            $xfer += $iter395->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_namespace_drop_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $ns = null;
  /**
   * @var bool
   */
  public $if_exists = true;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'if_exists',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['if_exists'])) {
        $this->if_exists = $vals['if_exists'];
      }
    }
  }

  public function getName() {
    return 'ClientService_namespace_drop_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->if_exists);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_namespace_drop_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::STRING, 1);
      $xfer += $output->writeString($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->if_exists !== null) {
      $xfer += $output->writeFieldBegin('if_exists', TType::BOOL, 2);
      $xfer += $output->writeBool($this->if_exists);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_namespace_drop_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_namespace_drop_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_namespace_drop_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_drop_namespace_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $ns = null;
  /**
   * @var bool
   */
  public $if_exists = true;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'if_exists',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['if_exists'])) {
        $this->if_exists = $vals['if_exists'];
      }
    }
  }

  public function getName() {
    return 'ClientService_drop_namespace_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->if_exists);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_drop_namespace_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::STRING, 1);
      $xfer += $output->writeString($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->if_exists !== null) {
      $xfer += $output->writeFieldBegin('if_exists', TType::BOOL, 2);
      $xfer += $output->writeBool($this->if_exists);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_drop_namespace_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_drop_namespace_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_drop_namespace_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_rename_table_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $name = null;
  /**
   * @var string
   */
  public $new_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'new_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
      if (isset($vals['new_name'])) {
        $this->new_name = $vals['new_name'];
      }
    }
  }

  public function getName() {
    return 'ClientService_rename_table_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->new_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_rename_table_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 2);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->new_name !== null) {
      $xfer += $output->writeFieldBegin('new_name', TType::STRING, 3);
      $xfer += $output->writeString($this->new_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_rename_table_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_rename_table_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_rename_table_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_table_rename_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $name = null;
  /**
   * @var string
   */
  public $new_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'new_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
      if (isset($vals['new_name'])) {
        $this->new_name = $vals['new_name'];
      }
    }
  }

  public function getName() {
    return 'ClientService_table_rename_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->new_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_table_rename_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 2);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->new_name !== null) {
      $xfer += $output->writeFieldBegin('new_name', TType::STRING, 3);
      $xfer += $output->writeString($this->new_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_table_rename_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_table_rename_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_table_rename_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_drop_table_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $name = null;
  /**
   * @var bool
   */
  public $if_exists = true;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'if_exists',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
      if (isset($vals['if_exists'])) {
        $this->if_exists = $vals['if_exists'];
      }
    }
  }

  public function getName() {
    return 'ClientService_drop_table_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->if_exists);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_drop_table_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 2);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->if_exists !== null) {
      $xfer += $output->writeFieldBegin('if_exists', TType::BOOL, 3);
      $xfer += $output->writeBool($this->if_exists);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_drop_table_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_drop_table_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_drop_table_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_table_drop_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $name = null;
  /**
   * @var bool
   */
  public $if_exists = true;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'if_exists',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
      if (isset($vals['if_exists'])) {
        $this->if_exists = $vals['if_exists'];
      }
    }
  }

  public function getName() {
    return 'ClientService_table_drop_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->if_exists);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_table_drop_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 2);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->if_exists !== null) {
      $xfer += $output->writeFieldBegin('if_exists', TType::BOOL, 3);
      $xfer += $output->writeBool($this->if_exists);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_table_drop_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_table_drop_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_table_drop_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_generate_guid_args {
  static $_TSPEC;


  public function __construct() {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        );
    }
  }

  public function getName() {
    return 'ClientService_generate_guid_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_generate_guid_args');
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_generate_guid_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
    }
  }

  public function getName() {
    return 'ClientService_generate_guid_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_generate_guid_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_create_cell_unique_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $ns = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var \Hypertable_ThriftGen\Key
   */
  public $key = null;
  /**
   * @var string
   */
  public $value = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ns',
          'type' => TType::I64,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'key',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\Key',
          ),
        4 => array(
          'var' => 'value',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ns'])) {
        $this->ns = $vals['ns'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['key'])) {
        $this->key = $vals['key'];
      }
      if (isset($vals['value'])) {
        $this->value = $vals['value'];
      }
    }
  }

  public function getName() {
    return 'ClientService_create_cell_unique_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->ns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->key = new \Hypertable_ThriftGen\Key();
            $xfer += $this->key->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->value);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_create_cell_unique_args');
    if ($this->ns !== null) {
      $xfer += $output->writeFieldBegin('ns', TType::I64, 1);
      $xfer += $output->writeI64($this->ns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->key !== null) {
      if (!is_object($this->key)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('key', TType::STRUCT, 3);
      $xfer += $this->key->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->value !== null) {
      $xfer += $output->writeFieldBegin('value', TType::STRING, 4);
      $xfer += $output->writeString($this->value);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_create_cell_unique_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_create_cell_unique_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_create_cell_unique_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_error_get_text_args {
  static $_TSPEC;

  /**
   * @var int
   */
  public $error_code = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'error_code',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['error_code'])) {
        $this->error_code = $vals['error_code'];
      }
    }
  }

  public function getName() {
    return 'ClientService_error_get_text_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->error_code);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_error_get_text_args');
    if ($this->error_code !== null) {
      $xfer += $output->writeFieldBegin('error_code', TType::I32, 1);
      $xfer += $output->writeI32($this->error_code);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_error_get_text_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
    }
  }

  public function getName() {
    return 'ClientService_error_get_text_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_error_get_text_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_status_args {
  static $_TSPEC;


  public function __construct() {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        );
    }
  }

  public function getName() {
    return 'ClientService_status_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_status_args');
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_status_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\Status
   */
  public $success = null;
  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\Status',
          ),
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_status_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Hypertable_ThriftGen\Status();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_status_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_shutdown_args {
  static $_TSPEC;


  public function __construct() {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        );
    }
  }

  public function getName() {
    return 'ClientService_shutdown_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_shutdown_args');
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ClientService_shutdown_result {
  static $_TSPEC;

  /**
   * @var \Hypertable_ThriftGen\ClientException
   */
  public $e = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'e',
          'type' => TType::STRUCT,
          'class' => '\Hypertable_ThriftGen\ClientException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['e'])) {
        $this->e = $vals['e'];
      }
    }
  }

  public function getName() {
    return 'ClientService_shutdown_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->e = new \Hypertable_ThriftGen\ClientException();
            $xfer += $this->e->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ClientService_shutdown_result');
    if ($this->e !== null) {
      $xfer += $output->writeFieldBegin('e', TType::STRUCT, 1);
      $xfer += $this->e->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}


