/*
 Copyright (c) 2013 Bart van der Schoor

 Permission is hereby granted, free of charge, to any person
 obtaining a copy of this software and associated documentation
 files (the "Software"), to deal in the Software without
 restriction, including without limitation the rights to use,
 copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following
 conditions:

 The above copyright notice and this permission notice shall be
 included in all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 OTHER DEALINGS IN THE SOFTWARE.
 */

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
(function () {
	'use strict';

	function repeat(amount, char) {
		char = String(char).charAt(0);
		var ret = '';
		for (var i = 0; i < amount; i++) {
			ret += char;
		}
		return ret;
	}

	function appendL(input, amount, char) {
		char = String(char).charAt(0);
		input = String(input);
		for (var i = 0; i < amount; i++) {
			input = char + input;
		}
		return input;
	}

	function appendR(input, amount, char) {
		char = String(char).charAt(0);
		input = String(input);
		for (var i = 0; i < amount; i++) {
			input = input + char;
		}
		return input;
	}

	function appendC(input, amount, char, keepRight) {
		char = String(char).charAt(0);
		input = String(input);
		var i;
		var pad = Math.floor(amount * 0.5);
		for (i = 0; i < pad; i++) {
			input = char + input;
		}
		if (!keepRight) {
			pad = amount - pad;
			for (i = 0; i < pad; i++) {
				input = input + char;
			}
		}
		return input;
	}

	function alignSide(input, amount, char, side, keepRight) {
		if (side === 'right') {
			return appendL(input, amount, char);
		}
		else if (side === 'center') {
			return appendC(input, amount, char, keepRight);
		}
		if (keepRight) {
			return input;
		}
		return appendR(input, amount, char);
	}

	function maxLineDimension(lines, current) {
		if (!current || typeof current !== 'object') {
			current = {
				height: 0,
				width: 0
			};
		}
		current.height = Math.max(current.height, lines.length);
		current.width = lines.reduce(function (memo, line) {
			return Math.max(memo, line.length);
		}, current.width);
		return current;
	}

	/*jshint -W003*/
	function copyTo(target, source) {
		target = target ? target : (Array.isArray(source) ? [] : {});
		var name;
		var value;
		if (source) {
			for (name in source) {
				if (source.hasOwnProperty(name)) {
					value = source[name];
					if (typeof value === 'object' && value) {
						target[name] = copyTo(target[name], value);
					}
					else {
						target[name] = value;
					}
				}
			}
		}
		return target;
	}

	function clone(source) {
		var ret = Array.isArray(source) ? [] : {};
		for (var i = 0, ii = arguments.length; i < ii; i++) {
			copyTo(ret, arguments[i]);
		}
		return ret;
	}

	/*jshint +W003*/

	var common = {
		repeat: repeat,
		alignSide: alignSide,
		maxLineDimension: maxLineDimension,
		copyTo: copyTo,
		clone: clone
	};

	module.exports = common;

}).call();
