# tv4-reporter

[![Build Status](https://secure.travis-ci.org/Bartvds/tv4-reporter.png?branch=master)](http://travis-ci.org/Bartvds/tv4-reporter) [![Dependency Status](https://gemnasium.com/Bartvds/tv4-reporter.png)](https://gemnasium.com/Bartvds/tv4-reporter) [![NPM version](https://badge.fury.io/js/tv4-reporter.png)](http://badge.fury.io/js/tv4-reporter)

> Reporters to display usable [Tiny Validator tv4](https://github.com/geraintluff/tv4) output of [json-schema](http://jsonschema.org) validation.
 
This module is used by various dependants to render `tv4` validation result objects in a compact but highly readable (and possibly colourful) format. Functionality is tuned for both CLI output as well as plain-text or pre-formatted HTML/CSS. 

**Note:** at this point this is *not* a 'validator' or 'test runner', nor is it a finished application. It is a library to use as dependency in `tv4` based testers. Use plain `tv4` and pass the result(s) to one of `tv4-reporters` helpers. If you are looking for a validator see one of the implementing tv4 wrappers for convenience (some linked below). 

## Features

* Indented, tree-like display.
* Single and multiple errors.
* Optionally display summaries.
* Recursive sub-errors (as generated by `anyOf`, `oneOf` etc).
* Missing sub-schemas (optionally report as fail or pass reason).
* Various output writer/coloriser modes using [ministyle](https://github.com/Bartvds/ministyle) and [miniwrite](https://github.com/Bartvds/miniwrite).

## Examples

(possibly outdated)

1. Examples of many different kind of errors in [this Travis-Ci build](https://travis-ci.org/Bartvds/grunt-tv4/jobs/14469941).
1. Bulk reporter with single error:
 
  [![WebStorm example](https://raw.github.com/Bartvds/tv4-reporter/master/media/webstorm-example-01.png)](https://raw.github.com/Bartvds/tv4-reporter/master/media/webstorm-example-01.png)

## Installation

```shell
$ npm install tv4-reporter --save-dev
```

## Usage

Still very-much in flux so possibly outdated examples. 

Minimal use case (likely this is spread over the implementing application):
````js
// assemble the components
var tv4 = require('tv4');
var out = require('miniwrite').console();
var style = require('ministyle').ansi();
var reporter = require('tv4-reporter').getReporter(out, style);

// now validate
var result = tv4.validateMultiple(myValue, mySchema);
if (!result.valid || result.missing.length > 0) {
	// get data object (might get these in bulk/async from somewhere)
	var res = reporter.createTest(mySchema, myValue, 'my special test', true);
	
	// report error
	reporter.reportResult(res);

	// if you have a many results you can use bulk to print nicely with summaries
	reporter.reportBulk([res, res2, res3], [pass1, pass2]);
	
	// only totals
	reporter.reportTotals(3, 4);
}
````

Bulk reporting:
````js
// if you have a many results you can use bulk to print nicely with summaries
reporter.reportBulk([res, res2, res3], [pass1, pass2]);

// only totals
reporter.reportTotals(3, 4);
````

For more API surface like (partial) reporter and various helpers see the exports in the main module. Also see the 'known dependants' for more examples.

## Output

Report output and styling done via extensible mini-api's:
 
* [ministyle](https://github.com/Bartvds/ministyle) (bundled with plain, ansi, html/css etc + utils)
* [miniwrite](https://github.com/Bartvds/miniwrite) (bundled with streaming console.log, line buffer, node-streams etc + utils)

## Known dependants

* [grunt-tv4](https://github.com/Bartvds/grunt-tv4) (bulk validator with http lookup for grunt)
* ~~[chai-json-schema](https://github.com/Bartvds/chai-json-schema) (assertion wrappers)~~ (update in progress)
* (planned) a commandline validator (cued for extraction from `grunt-tv4`)
* (planned) a json-schema assert()-ion (chai-json-schema without chai)

## Future

1. Output will likely be tuned over time.
1. Current version is very functional but doesn't yet do anything specific for each validation rule type.

## History

* <= 0.0.4 - Many fixes and tweaks.
* 0.0.1 - Extracted formatting code from [grunt-tv4](https://github.com/Bartvds/grunt-tv4) and [chai-json-schema](https://github.com/Bartvds/chai-json-schema).

## Build

Nothing much here as the code is still being extracted from the original projects.

~~Install development dependencies in your git checkout:~~

    $ npm install

~~Build and run tests:~~

    $ grunt

See the `Gruntfile.js` for additional commands.

## Contributing

In lieu of a formal styleguide, take care to maintain the existing coding style. Add unit tests for any new or changed functionality. Lint and test your code using [Grunt](http://gruntjs.com/).

*Note:* this is an opinionated module: please create a [ticket](https://github.com/Bartvds/tv4-reporter/issues) to discuss any big ideas. Pull requests for bug fixes are of course always welcome. 

## License

Copyright (c) 2013 Bart van der Schoor

Licensed under the MIT license.


[![Bitdeli Badge](https://d2weczhvl823v0.cloudfront.net/Bartvds/tv4-reporter/trend.png)](https://bitdeli.com/free "Bitdeli Badge")

