'use strict';

var express = require('express'),
    app = express(),
    path = require('path'),
    bodyParser = require('body-parser'),
    session = require('express-session'),
    store = new session.MemoryStore(),
    passport = require('passport'),
    settings = require('config'),
    hbs = require('express-hbs').express4(
        {
            extname: ".hbs",
            layoutsDir: path.join(__dirname, 'resources/views/layouts/'),
            partialsDir: path.join(__dirname, 'resources/views/partials/')
        }
    );

app.engine('hbs', hbs);
app.set('view engine', 'hbs');
app.use(require('compression')());
app.set('views', path.join(__dirname, 'resources/views'));
app.use(require('serve-favicon')(path.join(__dirname, 'public', 'favicon.png')));
app.use(express.static(path.join(__dirname, 'public')));
app.use(require('morgan')('dev'));
app.use(bodyParser.json());
app.use(bodyParser.urlencoded({extended: true}));
app.use(require('cookie-parser')());
app.use(session(
        {
            secret: settings.session.secret,
            resave: false,
            saveUninitialized: false,
            store: store,
            cookie: {
                httpOnly: true,
                maxAge: (typeof settings.cookie.maxAge !== 'undefined')? settings.cookie.maxAge : 2419200000
            }
        }
    )
);

/**
 * helpers Handlebars.
 */
require('app/providers/helpers')();

/**
 * Authentication with Passport.
 */
require('app/providers/passport')(app);

/**
 * Middleware.
 */
require('app/providers/middleware')(app);

/**
 * Routes.
 */
require('app/providers/route').routes(app);

/**
 * Error handler.
 */
app.use(function (err, req, res) {
    res.status(err.status || 500);
    var msgError = '<h1>' + err.message + '</h1>';
    msgError += (app.get('env') === 'development') ? '<p>' + (err.status || 500) + '</p><p>' + err.stack + '</p>' : '';
    res.send(msgError);
});

module.exports = app;
