'use strict';

var express = require('express'),
    router = express.Router(),
    passport = require('passport'),
    auth = require('modules/auth'),
    requestAccountSignIn = require('app/http/requests/admin/accountSignIn');

/**
 * View sign in
 */
router.get('/signin', auth.isUnauthenticated, function (req, res) {
    res.render('admin/signin');
});

/**
 * Strategy local sign in.
 */
router.post('/signin', requestAccountSignIn, function (req, res, next) {
    passport.authenticate('signin', function (err, user, message) {

        if (err) {
            // Return error 500.
            return next(err);
        }
        else if (!user) {
            // Return 401 with message.
            return res.status(401).json(req.response.return(message));
        }

        req.logIn(user, function (err) {
            if (err) {
                // Return error 500.
                return next(err);
            }
            
            return req.setCookieLogin(true).then(function () {
                req.response.setData({
                    username: user.username
                });

                // Success
                req.response.setSuccess();
                return res.json(req.response.return());
            });
        });

    })(req, res, next);
});

/**
 * logout.
 */
router.post('/logout', function (req, res) {
    req.setCookieLogin(false).then(function () {
        req.logout();
        req.response.setSuccess();
        return res.json(req.response.return());
    });
});

module.exports = router;
