'use strict';

var express = require('express'),
    router = express.Router(),
    auth = require('modules/auth'),
    Model = require('app/models/model');

/*
 Method      Route                       Action      Return      Description                         Resource AngularJS
 GET         /article                    index       Html        Articles index.                     ---
 GET         /article/load               load        Action      Load articles.                      query({action: 'load'}... )
 GET	     /article/create             create      Html        Create article.                     ---
 POST        /article	                 store       Action      Store article.                      save(... )
 GET         /article/{article}          show        Html        Preview article.                    ---
 GET	     /article/{article}/edit	 edit        Html        Edit article.                       ---
 GET         /article/{article}/load     load        Action      Load article for show or edit.      get({article: article.id, action: 'load'}... )
 PUT/PATCH   /article/{article}          update      Action      Update article.                     update({article: article.id}... )
 DELETE      /article/{article}          destroy     Action      Delete article.                     delete({article: article.id}... )
 */


// All routes require authentication.
router.use(auth.isAuthenticated);

// Index
router.get('/', function (req, res) {
    res.render('article/index');
});

// Load articles
// Documentation paginate:
//  https://www.npmjs.com/package/mongoose-paginate
router.get('/load', function (req, res) {
    var data = req.query;

    Model.paginate({}, { page: data.page, limit: 5 }, function(err, result) {
        res.json(result);
    });
});

// Create
router.get('/create', function (req, res) {

});

// Store
router.post('/', function (req, res) {

});

// Show
router.get('/:article', function (req, res) {

});

// Edit
router.get('/:article/edit', function (req, res) {

});

// Load article
router.get('/:article/load', function (req, res) {

});

// Update
router.put('/:article', function (req, res) {

});

// Delete
router.delete('/:article', function (req, res) {

});

module.exports = router;
