var validator = require('modules/validation');

var releaseRequest = function () {

    /**
     * Authorized access. [Optional]
     *   Default true.
     *
     * @param req
     * @returns {boolean}
     */
    this.authorized = function (req) {
        return req.isAuthenticated();
    };

    /**
     * Rules. [Required]
     *
     * @type {{version: string, description: string, publish: string}}
     */
    this.rules = {
        version: 'required|min:3|max:10',
        description: 'required|min:10',
        published: 'required|boolean'
    };

    /**
     * Labels of attributes. [Optional]
     *
     * @type {{version: string, description: string, publish: string}}
     */
    this.labels = {
        version: 'version',
        description: 'description',
        published: 'publish'
    };

    /**
     * Messages. [Optional]
     *
     * @type {{required: string, min: string, boolean: string}}
     */
    this.message.required = 'Please :attribute is required !';
};

module.exports = validator(releaseRequest);
