'use strict';

var passport = require('passport'),
    User = require('app/models/user').User,
    localStrategy = require('./local-strategy');

/**
 * Create strategies to login.
 *
 */
module.exports = function (app) {

    /**
     * Init.
     */
    app.use(passport.initialize());
    app.use(passport.session());

    /**
     * Serialize id user for session.
     */
    passport.serializeUser(function (user, done) {
        done(null, user.id);
    });

    /**
     * Find user by deserialize id.
     */
    passport.deserializeUser(function (id, done) {
        User.findById(id, function (err, user) {
            done(err, user);
        });
    });

    /**
     * Strategy Local - Sign In
     */
    passport.use('signin', localStrategy.signIn)
};
