angular.module("App")
    .controller("adminDocumentationEditController", ['$scope', '$state', 'request', 'toaster', '$stateParams', '$timeout', function ($scope, $state, request, toaster, $stateParams, $timeout) {

        $scope.onloadPretty = true;

        $scope.$watch('onloadPretty', function () {
            if ($scope.onloadPretty) {
                prettyPrint();
            }
        });

        $scope.$watch('documentation.description', function () {
            $timeout(function () {
                if ($scope.onloadPretty) {
                    prettyPrint();
                }
            });
        });

        /**
         * Init scope releases.
         *
         * @type {Array}
         */
        $scope.releases = [];

        request('admin/release/list').post(
            {
                options: {
                    sort: {version: 'desc'},
                    select: '_id version'
                }
            },
            function (response) {
                if (response.success) {
                    $scope.releases = response.data.releases;
                } else {
                    return toaster.error(response.msg);
                }
            }
        );

        /**
         * Init scope documentation.
         *
         * @type {{}}
         */
        $scope.documentation = {};

        // Load documentation.
        request('admin/documentation/' + $stateParams.documentation + '/load').post(
            {},
            function (response) {
                if (response.success) {
                    var documentation = response.data.documentation;

                    $scope.createdAt = moment(documentation.createdAt).format('DD/MM/YYYY hh:mm');
                    $scope.updatedAt = moment(documentation.updatedAt).format('DD/MM/YYYY hh:mm');

                    $scope.documentation.published = String(documentation.published);

                    $scope.documentation.releases = documentation.releases.map(function (value) {
                        return {
                            _id: value._id,
                            version: value.version
                        };
                    });

                    $scope.documentation.title = documentation.title;

                    $scope.documentation.description = documentation.description;
                } else {
                    toaster.error("Error", response.msg.join('<br>'));
                    $state.go('admin-documentation');
                }
            }
        );

        $scope.action = function () {
            // Clear message.
            toaster.clear();

            request('admin/documentation/' + $stateParams.documentation).put(
                $scope.documentation,
                function (response) {
                    if (response.success) {
                        toaster.success("Success", response.msg.join('<br>'));

                        $state.go('admin-documentation');
                    } else {
                        toaster.error("Error", response.msg.join('<br>'));
                    }
                }
            );
        };
    }]);
