angular.module('App')
    .controller('adminReleaseController', ['$scope', 'request', '$uibModal', 'adminReleaseService', function ($scope, request, $uibModal, adminReleaseService) {

        $scope.$watch('currentPage', function () {
            $scope.list();
        });

        $scope.currentPage = 1;
        $scope.size = 3;
        $scope.releases = [];

        $scope.setPage = function (page) {
            $scope.currentPage = page;
        };

        $scope.list = function () {
            adminReleaseService.query({
                action: 'load',
                page: $stateParams.page
            }).$promise.then(function (response) {
                
            });
            
            request('admin/release/list').post(
                {
                    paginate: {
                        page: $scope.currentPage,
                        limit: 5,
                        sort: {version: 'desc'}
                    }
                },
                function (response) {
                    if (response.success) {
                        $scope.total = response.data.total;
                        $scope.releases = response.data.docs;
                        $scope.itemsPerPage = response.data.limit;
                    } else {
                        return toaster.error(response.msg);
                    }
                }
            );
        };

        $scope.modalDelete = function (version) {
            $uibModal.open({
                animation: true,
                templateUrl: 'model.html',
                controller: 'adminReleaseModalDeleteController',
                resolve: {
                    modalConfig: {
                        id: version,
                        title: 'Delete release',
                        body: 'Really want to delete ?',
                        close: {
                            text: 'Cancel',
                            visible: true
                        },
                        ok: {
                            text: 'Delete',
                            visible: true
                        }
                    }
                }
            });
        };
    }])

    // Model Delete
    .controller('adminReleaseModalDeleteController', ['$scope', '$state', 'request', 'toaster', '$uibModalInstance', 'modalConfig', function ($scope, $state, request, toaster, $uibModalInstance, modalConfig) {

        $scope.modalConfig = modalConfig;

        $scope.ok = function () {
            $uibModalInstance.close(
                request('admin/release/' + modalConfig.id).delete(
                    {},
                    function (response) {
                        if (response.success) {
                            toaster.success('Success', response.msg.join('<br>'));

                            // Force reload
                            $state.go('admin-release', {}, {reload: true});
                        } else {
                            toaster.error('Error', response.msg.join('<br>'));
                        }

                        // Close modal
                        return true;
                    }
                )
            );
        };

        $scope.close = function () {
            $uibModalInstance.dismiss('cancel');
        };
    }]);
