angular.module('App')
    .controller('adminDocumentationController', ['$scope', 'request', '$uibModal', function ($scope, request, $uibModal) {

        $scope.$watch('currentPage', function() {
            $scope.list();
        });

        $scope.currentPage = 1;
        $scope.size = 3;
        $scope.documentations = [];

        $scope.setPage = function (page) {
            $scope.currentPage = page;
        };

        $scope.list = function() {
            request('admin/documentation/list').post(
                {
                    paginate: {
                        page: $scope.currentPage,
                        limit: 5,
                        sort: {version: 'desc'}
                    }
                },
                function (response) {
                    if (response.success) {
                        $scope.total = response.data.total;
                        $scope.documentations = response.data.docs;
                        $scope.itemsPerPage = response.data.limit;
                    } else {
                        return toaster.error(response.msg);
                    }
                }
            );
        };

        $scope.modalDelete = function (id) {
            $uibModal.open({
                animation: true,
                templateUrl: 'model.html',
                controller: 'adminDocumentationModalDeleteController',
                resolve: {
                    modalConfig: {
                        id: id,
                        title: 'Delete documentation',
                        body: 'Really want to delete ?',
                        close: {
                            text: 'Cancel',
                            visible: true
                        },
                        ok: {
                            text: 'Delete',
                            visible: true
                        }
                    }
                }
            });
        };
    }])

    // Model Delete
    .controller('adminDocumentationModalDeleteController', ['$scope', '$state', 'request', 'toaster', '$uibModalInstance', 'modalConfig', function ($scope, $state, request, toaster, $uibModalInstance, modalConfig) {

        $scope.modalConfig = modalConfig;

        $scope.ok = function () {
            $uibModalInstance.close(
                request('admin/documentation/' + modalConfig.id).delete(
                    {},
                    function (response) {
                        if (response.success) {
                            toaster.success('Success', response.msg.join('<br>'));

                            // Force reload
                            $state.go('admin-documentation', {}, {reload: true});
                        } else {
                            toaster.error('Error', response.msg.join('<br>'));
                        }

                        // Close modal
                        return true;
                    }
                )
            );
        };

        $scope.close = function () {
            $uibModalInstance.dismiss('cancel');
        };
    }]);
