angular.module("App")
    .controller("adminDocumentationCreateController", ['$scope', '$state', 'request', 'toaster', '$timeout', function ($scope, $state, request, toaster, $timeout) {

        $scope.onloadPretty = true;

        $scope.$watch('onloadPretty', function () {
            if ($scope.onloadPretty) {
                prettyPrint();
            }
        });

        $scope.$watch('documentation.description', function () {
            $timeout(function () {
                if ($scope.onloadPretty) {
                    prettyPrint();
                }
            });
        });

        /**
         * Init scope releases.
         *
         * @type {Array}
         */
        $scope.releases = [];

        request('admin/release/list').post(
            {
                options: {
                    sort: {version: 'desc'},
                    select: '_id version'
                }
            },
            function (response) {
                if (response.success) {
                    $scope.releases = response.data.releases;
                } else {
                    return toaster.error(response.msg);
                }
            }
        );


        /**
         * Init scope documentation.
         *
         * @type {{}}
         */
        $scope.documentation = {};

        $scope.action = function () {
            // Clear message.
            toaster.clear();

            request('admin/documentation').post(
                $scope.documentation,
                function (response) {
                    if (response.success) {
                        toaster.success("Success", response.msg.join('<br>'));

                        $state.go('admin-documentation');
                    } else {
                        toaster.error("Error", response.msg.join('<br>'));
                    }
                }
            );
        };
    }]);
