/**
 * Factory service account.
 */
angular.module("App").factory('accountService',
    ['$http', 'route', '$templateCache', '$rootScope', '$state', '$stateParams', 'toaster', 'auth',
        function ($http, route, $templateCache, $rootScope, $state, $stateParams, toaster, auth) {
            return {
                signIn: function (user) {
                    // Clear message.
                    toaster.clear();

                    return $http.post(route.namespace('admin/signin'), user)
                        .success(function (response) {
                            // Clear cache templates.
                            $templateCache.removeAll();

                            // Alter username navbar.
                            $rootScope.$emit('username', response.data.username);

                            // Get parameters for redirect
                            var paramsRedirectionLogin = auth.paramsRedirectionLogin();

                            // Go to page redirect.
                            $state.go(paramsRedirectionLogin.redirect, paramsRedirectionLogin.params);
                        })
                        .error(function (response) {
                            toaster.error("Error", response.msg.join('<br>'));
                        });
                },
                logout: function () {
                    return $http.post(route.namespace('/admin/logout'))
                        .success(function () {
                            // Clear cache templates.
                            $templateCache.removeAll();

                            return $state.go('home');
                        })
                        .error(function () {
                            toaster.error("Error in logout");
                        });
                }
            };
        }]
);
