App.config(['$interpolateProvider', '$locationProvider', 'settings', 'routeProvider', 'pathProvider', 'authProvider', '$ocLazyLoadProvider', '$showdownProvider', '$urlMatcherFactoryProvider',
    function ($interpolateProvider, $locationProvider, settings, routeProvider, pathProvider, authProvider, $ocLazyLoadProvider, $showdownProvider, $urlMatcherFactoryProvider) {

        /**
         * Alter symbol of AngularJS because Handlebars possesses the same symbol.
         *
         * Handlebars:
         *   Alternative delimiters are not supported.
         * https://github.com/wycats/handlebars.js#compatibility
         */
        $interpolateProvider.startSymbol('[[');
        $interpolateProvider.endSymbol(']]');

        /**
         * Config Modules
         *
         * Route, Path, Auth, ocLazyLoad, Location, Showdown, urlMatcherFactoryProvider
         */
        routeProvider.config(settings.route);

        pathProvider.config(settings.path);

        authProvider.config(settings.auth);

        $ocLazyLoadProvider.config({
            debug: true
        });

        $locationProvider.html5Mode({
            enabled: true,
            requireBase: false
        });

        $showdownProvider.loadExtension('prettify');

        // Url contains a trailing slash or not
        $urlMatcherFactoryProvider.strictMode(false);
    }]);
